/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionManagerEx;
import com.intellij.codeInspection.ex.InspectionTool;
import com.intellij.codeInspection.ex.ToolsImpl;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.impl.ProgressManagerImpl;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMUtil;
import java.io.CharArrayReader;
import java.io.File;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.Iterator;
import junit.framework.Assert;
import org.jdom.Document;
import org.jdom.Element;

public class InspectionTestUtil {
    private InspectionTestUtil() {
    }

    protected static void compareWithExpected(Document expectedDoc, Document doc, boolean checkRange) throws Exception {
        ArrayList expectedProblems = new ArrayList(expectedDoc.getRootElement().getChildren("problem"));
        ArrayList reportedProblems = new ArrayList(doc.getRootElement().getChildren("problem"));
        Element[] expectedArrayed = expectedProblems.toArray(new Element[expectedProblems.size()]);
        boolean failed = false;
        block0: for (Element expectedProblem : expectedArrayed) {
            Element[] reportedArrayed;
            for (Element reportedProblem : reportedArrayed = reportedProblems.toArray(new Element[reportedProblems.size()])) {
                if (!InspectionTestUtil.compareProblemWithExpected(reportedProblem, expectedProblem, checkRange)) continue;
                expectedProblems.remove(expectedProblem);
                reportedProblems.remove(reportedProblem);
                continue block0;
            }
            Document missing = new Document((Element)expectedProblem.clone());
            System.out.println("The following haven't been reported as expected: " + new String(JDOMUtil.printDocument((Document)missing, (String)"\n")));
            failed = true;
        }
        Iterator i$ = reportedProblems.iterator();
        while (i$.hasNext()) {
            Element reportedProblem1;
            Element reportedProblem = reportedProblem1 = (Element)i$.next();
            Document extra = new Document((Element)reportedProblem.clone());
            System.out.println("The following has been unexpectedly reported: " + new String(JDOMUtil.printDocument((Document)extra, (String)"\n")));
            failed = true;
        }
        Assert.assertFalse((boolean)failed);
    }

    static boolean compareProblemWithExpected(Element reportedProblem, Element expectedProblem, boolean checkRange) throws Exception {
        if (!InspectionTestUtil.compareFiles(reportedProblem, expectedProblem)) {
            return false;
        }
        if (!InspectionTestUtil.compareLines(reportedProblem, expectedProblem)) {
            return false;
        }
        if (!InspectionTestUtil.compareDescriptions(reportedProblem, expectedProblem)) {
            return false;
        }
        return !checkRange || InspectionTestUtil.compareTextRange(reportedProblem, expectedProblem);
    }

    static boolean compareTextRange(Element reportedProblem, Element expectedProblem) {
        Element reportedTextRange = reportedProblem.getChild("entry_point");
        if (reportedTextRange == null) {
            return false;
        }
        Element expectedTextRange = expectedProblem.getChild("entry_point");
        return Comparing.equal((String)reportedTextRange.getAttributeValue("TYPE"), (String)expectedTextRange.getAttributeValue("TYPE")) && Comparing.equal((String)reportedTextRange.getAttributeValue("FQNAME"), (String)expectedTextRange.getAttributeValue("FQNAME"));
    }

    static boolean compareDescriptions(Element reportedProblem, Element expectedProblem) throws Exception {
        String reportedDescription;
        String expectedDescription = expectedProblem.getChildText("description");
        if (expectedDescription.equals(reportedDescription = reportedProblem.getChildText("description"))) {
            return true;
        }
        StreamTokenizer tokenizer = new StreamTokenizer(new CharArrayReader(expectedDescription.toCharArray()));
        tokenizer.quoteChar(39);
        int idx = 0;
        while (tokenizer.nextToken() != -1) {
            String word;
            if (tokenizer.sval != null) {
                word = tokenizer.sval;
            } else {
                if (tokenizer.ttype != -2) continue;
                word = Double.toString(tokenizer.nval);
            }
            idx = reportedDescription.indexOf(word, idx);
            if (idx == -1) {
                return false;
            }
            idx += word.length();
        }
        return true;
    }

    static boolean compareLines(Element reportedProblem, Element expectedProblem) {
        return Comparing.equal((String)reportedProblem.getChildText("line"), (String)expectedProblem.getChildText("line"));
    }

    static boolean compareFiles(Element reportedProblem, Element expectedProblem) {
        String reportedFileName = reportedProblem.getChildText("file");
        File reportedFile = new File(reportedFileName);
        return Comparing.equal((String)reportedFile.getName(), (String)expectedProblem.getChildText("file"));
    }

    public static void compareToolResults(InspectionTool tool, boolean checkRange, String testDir) throws Exception {
        Element root = new Element("problems");
        Document doc = new Document(root);
        tool.updateContent();
        tool.exportResults(root);
        File file = new File(testDir + "/expected.xml");
        Document expectedDocument = JDOMUtil.loadDocument((File)file);
        InspectionTestUtil.compareWithExpected(expectedDocument, doc, checkRange);
    }

    public static void runTool(final InspectionTool tool, final AnalysisScope scope, GlobalInspectionContextImpl globalContext, final InspectionManagerEx inspectionManager) {
        String shortName = tool.getShortName();
        HighlightDisplayKey key = HighlightDisplayKey.find((String)shortName);
        if (key == null) {
            HighlightDisplayKey.register((String)shortName);
        }
        globalContext.getTools().put(tool.getShortName(), new ToolsImpl(tool, tool.getDefaultLevel(), true));
        tool.initialize(globalContext);
        ((RefManagerImpl)globalContext.getRefManager()).initializeAnnotators();
        if (tool.isGraphNeeded()) {
            ((RefManagerImpl)tool.getRefManager()).findAllDeclarations();
        }
        ((ProgressManagerImpl)ProgressManager.getInstance()).executeProcessUnderProgress(new Runnable(){

            @Override
            public void run() {
                tool.runInspection(scope, inspectionManager);
            }
        }, (ProgressIndicator)new EmptyProgressIndicator());
        tool.queryExternalUsagesRequests(inspectionManager);
    }
}

