/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.ProjectTopics;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.completion.CompletionProgressIndicator;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionTool;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.ex.ToolsImpl;
import com.intellij.ide.startup.impl.StartupManagerImpl;
import com.intellij.idea.IdeaLogger;
import com.intellij.idea.IdeaTestApplication;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerImpl;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.EmptyModuleType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.profile.Profile;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.impl.PsiDocumentManagerImpl;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageManagerImpl;
import com.intellij.testFramework.LightProjectDescriptor;
import com.intellij.testFramework.PlatformTestCase;
import com.intellij.testFramework.ThreadTracker;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.IndexableFileSet;
import com.intellij.util.messages.MessageBusConnection;
import gnu.trove.THashMap;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class LightPlatformTestCase
extends UsefulTestCase
implements DataProvider {
    public static final String PROFILE = "Configurable";
    private static IdeaTestApplication ourApplication;
    protected static Project ourProject;
    private static Module ourModule;
    private static PsiManager ourPsiManager;
    private static boolean ourAssertionsInTestDetected;
    private static VirtualFile ourSourceRoot;
    private static TestCase ourTestCase;
    public static Thread ourTestThread;
    private static LightProjectDescriptor ourProjectDescriptor;
    private final Map<String, InspectionTool> myAvailableInspectionTools = new THashMap();
    private static boolean ourHaveShutdownHook;
    private ThreadTracker myThreadTracker;

    public static Project getProject() {
        return ourProject;
    }

    public static Module getModule() {
        return ourModule;
    }

    public static PsiManager getPsiManager() {
        if (ourPsiManager == null) {
            ourPsiManager = PsiManager.getInstance((Project)ourProject);
        }
        return ourPsiManager;
    }

    public static void initApplication(DataProvider dataProvider) throws Exception {
        ourApplication = IdeaTestApplication.getInstance(null);
        ourApplication.setDataProvider(dataProvider);
    }

    public static IdeaTestApplication getApplication() {
        return ourApplication;
    }

    protected void resetAllFields() {
        this.resetClassFields(((Object)((Object)this)).getClass());
    }

    private void resetClassFields(Class<?> aClass) {
        try {
            UsefulTestCase.clearDeclaredFields((Object)this, aClass);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        if (aClass == LightPlatformTestCase.class) {
            return;
        }
        this.resetClassFields(aClass.getSuperclass());
    }

    private static void cleanPersistedVFSContent() {
        ((PersistentFS)ManagingFS.getInstance()).cleanPersistedContents();
    }

    private static void initProject(final LightProjectDescriptor descriptor) throws Exception {
        ourProjectDescriptor = descriptor;
        final File projectFile = File.createTempFile("lighttemp", ".ipr");
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                if (ourProject != null) {
                    LightPlatformTestCase.closeAndDeleteProject();
                } else {
                    LightPlatformTestCase.cleanPersistedVFSContent();
                }
                LocalFileSystem.getInstance().refreshAndFindFileByIoFile(projectFile);
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                new Throwable(projectFile.getPath()).printStackTrace(new PrintStream(buffer));
                ourProject = PlatformTestCase.createProject(projectFile, buffer.toString());
                if (!ourHaveShutdownHook) {
                    ourHaveShutdownHook = true;
                    LightPlatformTestCase.registerShutdownHook();
                }
                ourPsiManager = null;
                ourModule = LightPlatformTestCase.createMainModule(descriptor.getModuleType());
                VirtualFile dummyRoot = VirtualFileManager.getInstance().findFileByUrl("temp:///");
                dummyRoot.refresh(false, false);
                try {
                    ourSourceRoot = dummyRoot.createChildDirectory((Object)this, "src");
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                FileBasedIndex.getInstance().registerIndexableSet(new IndexableFileSet(){

                    @Override
                    public boolean isInSet(VirtualFile file) {
                        return ourSourceRoot != null && file.getFileSystem() == ourSourceRoot.getFileSystem();
                    }

                    @Override
                    public void iterateIndexableFilesIn(VirtualFile file, ContentIterator iterator) {
                        if (file.isDirectory()) {
                            for (VirtualFile child : file.getChildren()) {
                                this.iterateIndexableFilesIn(child, iterator);
                            }
                        } else {
                            iterator.processFile(file);
                        }
                    }
                }, null);
                ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)ourModule);
                ModifiableRootModel rootModel = rootManager.getModifiableModel();
                if (descriptor.getSdk() != null) {
                    rootModel.setSdk(descriptor.getSdk());
                }
                ContentEntry contentEntry = rootModel.addContentEntry(ourSourceRoot);
                contentEntry.addSourceFolder(ourSourceRoot, false);
                descriptor.configureModule(ourModule, rootModel, contentEntry);
                rootModel.commit();
                MessageBusConnection connection = ourProject.getMessageBus().connect();
                connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

                    public void beforeRootsChange(ModuleRootEvent event) {
                        if (!event.isCausedByFileTypesChange()) {
                            // empty if block
                        }
                    }

                    public void rootsChanged(ModuleRootEvent event) {
                    }
                });
                connection.subscribe(ProjectTopics.MODULES, (Object)new ModuleListener(){

                    public void moduleAdded(Project project, Module module) {
                        Assert.fail((String)"Adding modules is not permitted in LightIdeaTestCase.");
                    }

                    public void beforeModuleRemoved(Project project, Module module) {
                    }

                    public void moduleRemoved(Project project, Module module) {
                    }

                    public void modulesRenamed(Project project, List<Module> modules) {
                    }
                });
                ((StartupManagerImpl)StartupManager.getInstance((Project)LightPlatformTestCase.getProject())).runStartupActivities();
            }
        });
    }

    protected static Module createMainModule(final ModuleType moduleType) {
        return (Module)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<Module>(){

            public Module compute() {
                return ModuleManager.getInstance((Project)ourProject).newModule("light_idea_test_case.iml", moduleType);
            }
        });
    }

    public static VirtualFile getSourceRoot() {
        return ourSourceRoot;
    }

    protected void setUp() throws Exception {
        super.setUp();
        LightPlatformTestCase.initApplication(this);
        LightPlatformTestCase.doSetup(new SimpleLightProjectDescriptor(this.getModuleType(), this.getProjectJDK()), this.configureLocalInspectionTools(), this.myAvailableInspectionTools);
        ((InjectedLanguageManagerImpl)InjectedLanguageManager.getInstance((Project)LightPlatformTestCase.getProject())).pushInjectors();
        this.storeSettings();
        this.myThreadTracker = new ThreadTracker();
    }

    public static void doSetup(LightProjectDescriptor descriptor, LocalInspectionTool[] localInspectionTools, final Map<String, InspectionTool> availableInspectionTools) throws Exception {
        LightPlatformTestCase.assertNull((String)("Previous test " + ourTestCase + " hasn't called tearDown(). Probably overriden without super call."), (Object)ourTestCase);
        IdeaLogger.ourErrorsOccurred = null;
        if (ourProject == null || !ourProjectDescriptor.equals(descriptor)) {
            LightPlatformTestCase.initProject(descriptor);
        }
        ProjectManagerEx.getInstanceEx().setCurrentTestProject(ourProject);
        ((PsiDocumentManagerImpl)PsiDocumentManager.getInstance((Project)LightPlatformTestCase.getProject())).clearUncommitedDocuments();
        for (LocalInspectionTool tool : localInspectionTools) {
            LightPlatformTestCase.enableInspectionTool(availableInspectionTools, new LocalInspectionToolWrapper(tool));
        }
        InspectionProfileImpl profile = new InspectionProfileImpl(PROFILE){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            @NotNull
            public InspectionProfileEntry[] getInspectionTools(PsiElement element) {
                InspectionProfileEntry[] inspectionProfileEntryArray;
                if (availableInspectionTools != null) {
                    Collection tools = availableInspectionTools.values();
                    inspectionProfileEntryArray = tools.toArray(new InspectionTool[tools.size()]);
                    if (inspectionProfileEntryArray == null) throw new IllegalStateException("@NotNull method com/intellij/testFramework/LightPlatformTestCase$3.getInspectionTools must not return null");
                    return inspectionProfileEntryArray;
                }
                inspectionProfileEntryArray = new InspectionTool[]{};
                if (inspectionProfileEntryArray != null) return inspectionProfileEntryArray;
                throw new IllegalStateException("@NotNull method com/intellij/testFramework/LightPlatformTestCase$3.getInspectionTools must not return null");
            }

            @Override
            public List<ToolsImpl> getAllEnabledInspectionTools() {
                ArrayList<ToolsImpl> result = new ArrayList<ToolsImpl>();
                for (InspectionProfileEntry entry : this.getInspectionTools(null)) {
                    result.add(new ToolsImpl(entry, entry.getDefaultLevel(), true));
                }
                return result;
            }

            @Override
            public boolean isToolEnabled(HighlightDisplayKey key, PsiElement element) {
                return key != null && availableInspectionTools.containsKey(key.toString());
            }

            @Override
            public HighlightDisplayLevel getErrorLevel(@NotNull HighlightDisplayKey key, PsiElement element) {
                if (key == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/testFramework/LightPlatformTestCase$3.getErrorLevel must not be null");
                }
                InspectionTool localInspectionTool = (InspectionTool)((Object)availableInspectionTools.get(key.toString()));
                return localInspectionTool != null ? localInspectionTool.getDefaultLevel() : HighlightDisplayLevel.WARNING;
            }

            @Override
            public InspectionTool getInspectionTool(@NotNull String shortName, @NotNull PsiElement element) {
                if (shortName == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/testFramework/LightPlatformTestCase$3.getInspectionTool must not be null");
                }
                if (element == null) {
                    throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/testFramework/LightPlatformTestCase$3.getInspectionTool must not be null");
                }
                if (availableInspectionTools.containsKey(shortName)) {
                    return (InspectionTool)((Object)availableInspectionTools.get(shortName));
                }
                return null;
            }
        };
        InspectionProfileManager inspectionProfileManager = InspectionProfileManager.getInstance();
        inspectionProfileManager.addProfile((Profile)profile);
        inspectionProfileManager.setRootProfile(profile.getName());
        InspectionProjectProfileManager.getInstance(LightPlatformTestCase.getProject()).updateProfile((Profile)profile);
        InspectionProjectProfileManager.getInstance(LightPlatformTestCase.getProject()).setProjectProfile(profile.getName());
        LightPlatformTestCase.assertFalse((boolean)LightPlatformTestCase.getPsiManager().isDisposed());
        CodeStyleSettingsManager.getInstance((Project)LightPlatformTestCase.getProject()).setTemporarySettings(new CodeStyleSettings());
    }

    protected void enableInspectionTool(LocalInspectionTool tool) {
        this.enableInspectionTool(new LocalInspectionToolWrapper(tool));
    }

    protected void enableInspectionTool(InspectionTool tool) {
        LightPlatformTestCase.enableInspectionTool(this.myAvailableInspectionTools, tool);
    }

    private static void enableInspectionTool(Map<String, InspectionTool> availableLocalTools, InspectionTool wrapper) {
        String shortName = wrapper.getShortName();
        HighlightDisplayKey key = HighlightDisplayKey.find((String)shortName);
        if (key == null) {
            HighlightDisplayKey.register((String)shortName, (String)wrapper.getDisplayName(), (String)(wrapper instanceof LocalInspectionToolWrapper ? ((LocalInspectionToolWrapper)wrapper).getTool().getID() : wrapper.getShortName()));
        }
        availableLocalTools.put(shortName, wrapper);
    }

    protected LocalInspectionTool[] configureLocalInspectionTools() {
        return new LocalInspectionTool[0];
    }

    @Override
    protected void tearDown() throws Exception {
        CodeStyleSettingsManager.getInstance((Project)LightPlatformTestCase.getProject()).dropTemporarySettings();
        this.checkForSettingsDamage();
        LightPlatformTestCase.doTearDown(LightPlatformTestCase.getProject(), ourApplication, true);
        super.tearDown();
        this.myThreadTracker.checkLeak();
        LightPlatformTestCase.checkInjectorsAreDisposed();
    }

    public static void doTearDown(Project project, IdeaTestApplication application, boolean checkForEditors) throws Exception {
        LightPlatformTestCase.checkAllTimersAreDisposed();
        UsefulTestCase.doPostponedFormatting(project);
        LookupManager lookupManager = LookupManager.getInstance(project);
        if (lookupManager != null) {
            lookupManager.hideActiveLookup();
        }
        ((StartupManagerImpl)StartupManager.getInstance((Project)project)).prepareForNextTest();
        InspectionProfileManager.getInstance().deleteProfile(PROFILE);
        LightPlatformTestCase.assertNotNull((String)"Application components damaged", (Object)ProjectManager.getInstance());
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                FileDocumentManager manager;
                if (ourSourceRoot != null) {
                    try {
                        VirtualFile[] children;
                        for (VirtualFile child : children = ourSourceRoot.getChildren()) {
                            child.delete((Object)this);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if ((manager = FileDocumentManager.getInstance()) instanceof FileDocumentManagerImpl) {
                    ((FileDocumentManagerImpl)manager).dropAllUnsavedDocuments();
                }
                ApplicationManager.getApplication().runWriteAction(EmptyRunnable.getInstance());
                manager.saveAllDocuments();
            }
        });
        LightPlatformTestCase.assertFalse((boolean)PsiManager.getInstance((Project)project).isDisposed());
        if (!ourAssertionsInTestDetected && IdeaLogger.ourErrorsOccurred != null) {
            throw IdeaLogger.ourErrorsOccurred;
        }
        ((PsiDocumentManagerImpl)PsiDocumentManager.getInstance((Project)project)).clearUncommitedDocuments();
        ((UndoManagerImpl)UndoManager.getGlobalInstance()).dropHistoryInTests();
        ProjectManagerEx.getInstanceEx().setCurrentTestProject(null);
        application.setDataProvider(null);
        ourTestCase = null;
        ((PsiManagerImpl)PsiManager.getInstance((Project)project)).cleanupForNextTest();
        CompletionProgressIndicator.cleanupForNextTest();
        if (checkForEditors) {
            LightPlatformTestCase.checkEditorsReleased();
        }
    }

    public static void checkEditorsReleased() {
        Editor[] allEditors = EditorFactory.getInstance().getAllEditors();
        if (allEditors.length > 0) {
            for (Editor allEditor : allEditors) {
                EditorFactory.getInstance().releaseEditor(allEditor);
            }
            LightPlatformTestCase.fail((String)("Unreleased editors: " + allEditors.length));
        }
    }

    private static void checkInjectorsAreDisposed() {
        ((InjectedLanguageManagerImpl)InjectedLanguageManager.getInstance((Project)LightPlatformTestCase.getProject())).checkInjectorsAreDisposed();
    }

    public final void runBare() throws Throwable {
        final Throwable[] throwables = new Throwable[1];
        SwingUtilities.invokeAndWait(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    ourTestThread = Thread.currentThread();
                    LightPlatformTestCase.this.startRunAndTear();
                }
                catch (Throwable throwable) {
                    throwables[0] = throwable;
                }
                finally {
                    ourTestThread = null;
                    try {
                        PlatformTestCase.cleanupApplicationCaches(ourProject);
                        LightPlatformTestCase.this.resetAllFields();
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        if (throwables[0] != null) {
            throw throwables[0];
        }
        SwingUtilities.invokeAndWait(EmptyRunnable.getInstance());
        if (IdeaLogger.ourErrorsOccurred != null) {
            throw IdeaLogger.ourErrorsOccurred;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startRunAndTear() throws Throwable {
        this.setUp();
        try {
            ourAssertionsInTestDetected = true;
            this.runTest();
            ourAssertionsInTestDetected = false;
        }
        finally {
            this.tearDown();
        }
    }

    public Object getData(String dataId) {
        if (PlatformDataKeys.PROJECT.is(dataId)) {
            return ourProject;
        }
        return null;
    }

    protected Sdk getProjectJDK() {
        return null;
    }

    protected ModuleType getModuleType() {
        return EmptyModuleType.getInstance();
    }

    protected static PsiFile createFile(@NonNls String fileName, String text) throws IncorrectOperationException {
        return LightPlatformTestCase.createPseudoPhysicalFile(fileName, text);
    }

    protected static PsiFile createLightFile(String fileName, String text) throws IncorrectOperationException {
        return PsiFileFactory.getInstance((Project)LightPlatformTestCase.getProject()).createFileFromText(fileName, FileTypeManager.getInstance().getFileTypeByFileName(fileName), (CharSequence)text, LocalTimeCounter.currentTime(), false);
    }

    protected static PsiFile createPseudoPhysicalFile(@NonNls String fileName, String text) throws IncorrectOperationException {
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(fileName);
        return PsiFileFactory.getInstance((Project)LightPlatformTestCase.getProject()).createFileFromText(fileName, fileType, (CharSequence)text, LocalTimeCounter.currentTime(), true);
    }

    @Override
    protected String getTestName(boolean lowercaseFirstLetter) {
        String name = this.getName();
        LightPlatformTestCase.assertTrue((String)"Test name should start with 'test'", (boolean)name.startsWith("test"));
        name = name.substring("test".length());
        if (lowercaseFirstLetter && !UsefulTestCase.isAllUppercaseName(name)) {
            name = Character.toLowerCase(name.charAt(0)) + name.substring(1);
        }
        return name;
    }

    protected static void commitDocument(Document document) {
        PsiDocumentManager.getInstance((Project)LightPlatformTestCase.getProject()).commitDocument(document);
    }

    protected static void commitAllDocuments() {
        PsiDocumentManager.getInstance((Project)LightPlatformTestCase.getProject()).commitAllDocuments();
    }

    @Override
    protected CodeStyleSettings getCurrentCodeStyleSettings() {
        return CodeStyleSettingsManager.getSettings((Project)LightPlatformTestCase.getProject());
    }

    protected static Document getDocument(PsiFile file) {
        return PsiDocumentManager.getInstance((Project)LightPlatformTestCase.getProject()).getDocument(file);
    }

    protected static synchronized void closeAndDeleteProject() {
        if (ourProject != null) {
            File projectFile;
            VirtualFile projFile = ((ProjectEx)ourProject).getStateStore().getProjectFile();
            File file = projectFile = projFile == null ? null : VfsUtil.virtualToIoFile((VirtualFile)projFile);
            if (!ourProject.isDisposed()) {
                Disposer.dispose((Disposable)ourProject);
            }
            if (projectFile != null) {
                FileUtil.delete((File)projectFile);
            }
        }
    }

    private static void registerShutdownHook() {
        ShutDownTracker.getInstance().registerShutdownTask(new Runnable(){

            @Override
            public void run() {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            LightPlatformTestCase.closeAndDeleteProject();
                        }
                    });
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    static {
        ourTestCase = null;
        System.setProperty("jbdt.test.fixture", "com.intellij.designer.dt.IJTestFixture");
    }

    private static class SimpleLightProjectDescriptor
    implements LightProjectDescriptor {
        private final ModuleType myModuleType;
        private final Sdk mySdk;

        SimpleLightProjectDescriptor(ModuleType moduleType, Sdk sdk) {
            this.myModuleType = moduleType;
            this.mySdk = sdk;
        }

        @Override
        public ModuleType getModuleType() {
            return this.myModuleType;
        }

        @Override
        public Sdk getSdk() {
            return this.mySdk;
        }

        @Override
        public void configureModule(Module module, ModifiableRootModel model, ContentEntry contentEntry) {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SimpleLightProjectDescriptor that = (SimpleLightProjectDescriptor)o;
            if (this.myModuleType != null ? !this.myModuleType.equals((Object)that.myModuleType) : that.myModuleType != null) {
                return false;
            }
            return !this.isJDKChanged(that.getSdk());
        }

        public int hashCode() {
            int result = this.myModuleType != null ? this.myModuleType.hashCode() : 0;
            result = 31 * result + (this.mySdk != null ? this.mySdk.hashCode() : 0);
            return result;
        }

        private boolean isJDKChanged(Sdk newJDK) {
            if (this.mySdk == null && newJDK == null) {
                return false;
            }
            return this.mySdk == null || newJDK == null || !Comparing.equal((String)this.mySdk.getVersionString(), (String)newJDK.getVersionString());
        }
    }
}

