/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Enumeration;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DuplicateNodeRenderer {
    public static void paintDuplicateNodesBackground(Graphics g, JTree tree) {
        Rectangle clipBounds = g.getClipBounds();
        int start = tree.getClosestRowForLocation(clipBounds.x, clipBounds.y);
        int end = Math.min(tree.getRowCount(), tree.getClosestRowForLocation(clipBounds.x + clipBounds.width, clipBounds.y + clipBounds.height) + 1);
        Color old = g.getColor();
        for (int i = start; i < end; ++i) {
            DuplicatableNode duplicatableNode;
            Object duplicate;
            Object userObject;
            DefaultMutableTreeNode node;
            TreePath path = tree.getPathForRow(i);
            if (path == null) continue;
            Rectangle accumRect = null;
            TreePath accumPath = null;
            for (node = (DefaultMutableTreeNode)path.getLastPathComponent(); node != null && (userObject = node.getUserObject()) instanceof DuplicatableNode && (duplicate = (duplicatableNode = (DuplicatableNode)userObject).getDuplicate()) != null; node = (DefaultMutableTreeNode)node.getParent()) {
                accumPath = accumRect == null ? path : accumPath.getParentPath();
                accumRect = DuplicateNodeRenderer.union(tree.getPathBounds(accumPath), accumRect);
            }
            if (accumRect == null) continue;
            Rectangle rowRect = tree.getRowBounds(tree.getRowForPath(accumPath));
            accumRect = accumRect.intersection(new Rectangle(rowRect.x, rowRect.y, Integer.MAX_VALUE, Integer.MAX_VALUE));
            node = (DefaultMutableTreeNode)accumPath.getLastPathComponent();
            accumRect = DuplicateNodeRenderer.union(accumRect, DuplicateNodeRenderer.getExpandedNodesRect(tree, node, accumPath));
            g.setColor(new Color(230, 230, 230));
            g.fillRoundRect(accumRect.x, accumRect.y, accumRect.width, accumRect.height, 10, 10);
            g.setColor(Color.lightGray);
            g.drawRoundRect(accumRect.x, accumRect.y, accumRect.width, accumRect.height, 10, 10);
        }
        g.setColor(old);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static Rectangle union(Rectangle r1, Rectangle r2) {
        Rectangle rectangle;
        if (r1 == null) {
            rectangle = r2;
            if (rectangle == null) throw new IllegalStateException("@NotNull method com/intellij/ui/DuplicateNodeRenderer.union must not return null");
            return rectangle;
        }
        if (r2 == null) {
            rectangle = r1;
            if (rectangle == null) throw new IllegalStateException("@NotNull method com/intellij/ui/DuplicateNodeRenderer.union must not return null");
            return rectangle;
        }
        rectangle = r1.union(r2);
        if (rectangle != null) return rectangle;
        throw new IllegalStateException("@NotNull method com/intellij/ui/DuplicateNodeRenderer.union must not return null");
    }

    private static Rectangle getExpandedNodesRect(JTree tree, DefaultMutableTreeNode node, TreePath path) {
        Rectangle rect = tree.getRowBounds(tree.getRowForPath(path));
        if (tree.isExpanded(path)) {
            Enumeration<TreeNode> children = node.children();
            while (children.hasMoreElements()) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)children.nextElement();
                TreePath childPath = path.pathByAddingChild(child);
                assert (!path.equals(childPath)) : path + ";" + child;
                rect = DuplicateNodeRenderer.union(rect, DuplicateNodeRenderer.getExpandedNodesRect(tree, child, childPath));
            }
        }
        return rect;
    }

    public static interface DuplicatableNode<T> {
        @Nullable
        public T getDuplicate();
    }
}

