/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usageView.impl;

import com.intellij.ide.impl.ContentManagerWatcher;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.usageView.UsageViewManager;
import com.intellij.usages.UsageView;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class UsageViewManagerImpl
extends UsageViewManager {
    private final Key<Boolean> REUSABLE_CONTENT_KEY = Key.create((String)"UsageTreeManager.REUSABLE_CONTENT_KEY");
    private final Key<Boolean> NOT_REUSABLE_CONTENT_KEY = Key.create((String)"UsageTreeManager.NOT_REUSABLE_CONTENT_KEY");
    private final Key<UsageView> NEW_USAGE_VIEW_KEY = Key.create((String)"NEW_USAGE_VIEW_KEY");
    private final ToolWindowManager myToolWindowManager;
    private ContentManager myFindContentManager;

    public UsageViewManagerImpl(Project project, ToolWindowManager toolWindowManager) {
        this.myToolWindowManager = toolWindowManager;
        ToolWindow toolWindow = this.myToolWindowManager.registerToolWindow(ToolWindowId.FIND, true, ToolWindowAnchor.BOTTOM, (Disposable)project, true);
        toolWindow.setToHideOnEmptyContent(true);
        toolWindow.setIcon(IconLoader.getIcon((String)"/general/toolWindowFind.png"));
        this.myFindContentManager = toolWindow.getContentManager();
        this.myFindContentManager.addContentManagerListener((ContentManagerListener)new ContentManagerAdapter(){

            public void contentRemoved(ContentManagerEvent event) {
                event.getContent().release();
            }
        });
        new ContentManagerWatcher(toolWindow, this.myFindContentManager);
    }

    public Content addContent(String contentName, boolean reusable, JComponent component, boolean toOpenInNewTab, boolean isLockable) {
        return this.addContent(contentName, null, null, reusable, component, toOpenInNewTab, isLockable);
    }

    public Content addContent(String contentName, String tabName, String toolwindowTitle, boolean reusable, JComponent component, boolean toOpenInNewTab, boolean isLockable) {
        Key<Boolean> contentKey;
        Key<Boolean> key = contentKey = reusable ? this.REUSABLE_CONTENT_KEY : this.NOT_REUSABLE_CONTENT_KEY;
        if (!toOpenInNewTab && reusable) {
            Content[] contents = this.myFindContentManager.getContents();
            Content contentToDelete = null;
            for (Content content : contents) {
                UsageView usageView;
                if (content.isPinned() || content.getUserData(contentKey) == null || (usageView = (UsageView)content.getUserData(this.NEW_USAGE_VIEW_KEY)) != null && usageView.isSearchInProgress()) continue;
                contentToDelete = content;
            }
            if (contentToDelete != null) {
                this.myFindContentManager.removeContent(contentToDelete, true);
            }
        }
        Content content = ContentFactory.SERVICE.getInstance().createContent(component, contentName, isLockable);
        content.setTabName(tabName);
        content.setToolwindowTitle(toolwindowTitle);
        content.putUserData(contentKey, (Object)Boolean.TRUE);
        this.myFindContentManager.addContent(content);
        this.myFindContentManager.setSelectedContent(content);
        return content;
    }

    public int getReusableContentsCount() {
        return this.getContentCount(true);
    }

    private int getContentCount(boolean reusable) {
        Content[] contents;
        Key<Boolean> contentKey = reusable ? this.REUSABLE_CONTENT_KEY : this.NOT_REUSABLE_CONTENT_KEY;
        int count = 0;
        for (Content content : contents = this.myFindContentManager.getContents()) {
            if (content.getUserData(contentKey) == null) continue;
            ++count;
        }
        return count;
    }

    public Content getSelectedContent(boolean reusable) {
        Key<Boolean> contentKey = reusable ? this.REUSABLE_CONTENT_KEY : this.NOT_REUSABLE_CONTENT_KEY;
        Content selectedContent = this.myFindContentManager.getSelectedContent();
        return selectedContent == null || selectedContent.getUserData(contentKey) == null ? null : selectedContent;
    }

    public Content getSelectedContent() {
        return this.myFindContentManager == null ? null : this.myFindContentManager.getSelectedContent();
    }

    public void closeContent(@NotNull Content content) {
        if (content == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/usageView/impl/UsageViewManagerImpl.closeContent must not be null");
        }
        this.myFindContentManager.removeContent(content, true);
        content.release();
    }
}

