/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.fileIndex;

import com.intellij.ide.caches.CacheUpdater;
import com.intellij.ide.caches.FileContent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileManagerListener;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.ex.VirtualFileManagerEx;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.util.fileIndex.AbstractFileIndex;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class FileIndexRefreshCacheUpdater
extends VirtualFileAdapter
implements CacheUpdater,
VirtualFileManagerListener,
Disposable {
    private final AbstractFileIndex myFileIndex;
    private final VirtualFileManagerEx myVirtualFileManager;
    private final ProjectRootManagerEx myProjectRootManager;
    private final Set<VirtualFile> myChangedFiles = new HashSet<VirtualFile>();
    private final Set<VirtualFile> myRemovedFiles = new HashSet<VirtualFile>();

    public FileIndexRefreshCacheUpdater(Project project, AbstractFileIndex fileIndex) {
        this.myFileIndex = fileIndex;
        this.myVirtualFileManager = (VirtualFileManagerEx)VirtualFileManager.getInstance();
        this.myProjectRootManager = ProjectRootManagerEx.getInstanceEx(project);
        this.myVirtualFileManager.addVirtualFileManagerListener(this);
        this.myVirtualFileManager.addVirtualFileListener((VirtualFileListener)this, this);
        this.myProjectRootManager.registerRefreshUpdater(this);
    }

    public void dispose() {
        this.myVirtualFileManager.removeVirtualFileManagerListener(this);
        this.myProjectRootManager.unregisterRefreshUpdater(this);
    }

    public void beforeRefreshStart(boolean asynchonous) {
    }

    public void afterRefreshFinish(boolean asynchonous) {
        if (!asynchonous) {
            for (VirtualFile file : this.myChangedFiles) {
                this.myFileIndex.updateIndexEntry(file);
            }
            this.updatingDone();
        }
    }

    public int getNumberOfPendingUpdateJobs() {
        return 0;
    }

    public VirtualFile[] queryNeededFiles() {
        return VfsUtil.toVirtualFileArray(this.myChangedFiles);
    }

    public void processFile(FileContent fileContent) {
        this.myFileIndex.updateIndexEntry(fileContent.getVirtualFile());
    }

    public void updatingDone() {
        this.myChangedFiles.clear();
        for (VirtualFile file : this.myRemovedFiles) {
            this.myFileIndex.removeIndexEntry(file);
        }
        this.myRemovedFiles.clear();
    }

    public void canceled() {
    }

    public void fileCreated(VirtualFileEvent event) {
        VirtualFile file = event.getFile();
        this.handleCreateDeleteFile(file, event.isFromRefresh(), true);
    }

    public void contentsChanged(VirtualFileEvent event) {
        VirtualFile file = event.getFile();
        if (this.myFileIndex.belongs(file)) {
            if (event.isFromRefresh()) {
                this.myChangedFiles.add(file);
            } else {
                this.myFileIndex.queueEntryUpdate(file);
            }
        }
    }

    private void handleCreateDeleteFile(VirtualFile file, boolean fromRefresh, boolean create) {
        if (!this.myFileIndex.getProjectFileIndex().isInContent(file)) {
            return;
        }
        if (file.isDirectory()) {
            Collection<Object> children = create ? Arrays.asList(file.getChildren()) : ((NewVirtualFile)file).getCachedChildren();
            for (VirtualFile virtualFile : children) {
                this.handleCreateDeleteFile(virtualFile, fromRefresh, create);
            }
            return;
        }
        if (this.myFileIndex.belongs(file)) {
            if (fromRefresh) {
                if (create) {
                    this.myChangedFiles.add(file);
                } else {
                    this.myRemovedFiles.add(file);
                }
            } else if (create) {
                this.myFileIndex.updateIndexEntry(file);
            } else {
                this.myFileIndex.removeIndexEntry(file);
            }
        }
    }

    public void beforePropertyChange(VirtualFilePropertyEvent event) {
        if ("name".equals(event.getPropertyName())) {
            this.beforeFileDeletion((VirtualFileEvent)event);
        }
    }

    public void beforeFileMovement(VirtualFileMoveEvent event) {
        this.beforeFileDeletion((VirtualFileEvent)event);
    }

    public void fileMoved(VirtualFileMoveEvent event) {
        this.fileCreated((VirtualFileEvent)event);
    }

    public void propertyChanged(VirtualFilePropertyEvent event) {
        VirtualFile file = event.getFile();
        if ("name".equals(event.getPropertyName()) && this.myFileIndex.belongs(file)) {
            this.fileCreated((VirtualFileEvent)event);
        }
    }

    public void beforeFileDeletion(VirtualFileEvent event) {
        VirtualFile file = event.getFile();
        this.handleCreateDeleteFile(file, event.isFromRefresh(), false);
    }
}

