/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.indexing.AdditionalIndexableFileSet;
import com.intellij.util.indexing.IndexableFileSet;
import com.intellij.util.indexing.IndexedRootsProvider;
import org.jetbrains.annotations.NotNull;

public class AdditionalIndexedRootsScope
extends GlobalSearchScope {
    private final GlobalSearchScope myBaseScope;
    private final IndexableFileSet myFileSet;

    public AdditionalIndexedRootsScope(GlobalSearchScope baseScope) {
        this(baseScope, new AdditionalIndexableFileSet());
    }

    public AdditionalIndexedRootsScope(GlobalSearchScope baseScope, Class<? extends IndexedRootsProvider> providerClass) {
        this(baseScope, new AdditionalIndexableFileSet((IndexedRootsProvider)IndexedRootsProvider.EP_NAME.findExtension(providerClass)));
    }

    public AdditionalIndexedRootsScope(GlobalSearchScope baseScope, IndexableFileSet myFileSet) {
        super(baseScope.getProject());
        this.myBaseScope = baseScope;
        this.myFileSet = myFileSet;
    }

    public boolean contains(VirtualFile file) {
        return this.myBaseScope.contains(file) || this.myFileSet.isInSet(file);
    }

    public int compare(VirtualFile file1, VirtualFile file2) {
        return this.myBaseScope.compare(file1, file2);
    }

    public boolean isSearchInModuleContent(@NotNull Module aModule) {
        if (aModule == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/indexing/AdditionalIndexedRootsScope.isSearchInModuleContent must not be null");
        }
        return this.myBaseScope.isSearchInModuleContent(aModule);
    }

    public boolean isSearchInLibraries() {
        return this.myBaseScope.isSearchInLibraries();
    }
}

