/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.AppTopics;
import com.intellij.concurrency.JobScheduler;
import com.intellij.ide.caches.CacheUpdater;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationAdapter;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerAdapter;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeEvent;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.DumbModeAction;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.DumbServiceImpl;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.CollectingContentIterator;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.ex.VirtualFileManagerEx;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.impl.NullVirtualFile;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLock;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.impl.PsiDocumentTransactionListener;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.search.EverythingGlobalScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.concurrency.JBLock;
import com.intellij.util.concurrency.JBReentrantReadWriteLock;
import com.intellij.util.concurrency.LockFactory;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ConcurrentHashSet;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.AdditionalIndexableFileSet;
import com.intellij.util.indexing.CustomImplementationFileBasedIndexExtension;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.indexing.IndexStorage;
import com.intellij.util.indexing.IndexableFileSet;
import com.intellij.util.indexing.IndexedRootsProvider;
import com.intellij.util.indexing.IndexingStamp;
import com.intellij.util.indexing.MapIndexStorage;
import com.intellij.util.indexing.MapReduceIndex;
import com.intellij.util.indexing.MemoryIndexStorage;
import com.intellij.util.indexing.PerIndexDocumentMap;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.UnindexedFilesUpdater;
import com.intellij.util.indexing.UpdatableIndex;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import com.intellij.util.io.storage.HeavyProcessLatch;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntIterator;
import gnu.trove.TObjectIntHashMap;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileBasedIndex
implements ApplicationComponent {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.indexing.FileBasedIndex");
    @NonNls
    private static final String CORRUPTION_MARKER_NAME = "corruption.marker";
    private final Map<ID<?, ?>, Pair<UpdatableIndex<?, ?, FileContent>, InputFilter>> myIndices = new HashMap();
    private final Map<ID<?, ?>, Semaphore> myUnsavedDataIndexingSemaphores = new HashMap();
    private final TObjectIntHashMap<ID<?, ?>> myIndexIdToVersionMap = new TObjectIntHashMap();
    private final Set<ID<?, ?>> myNotRequiringContentIndices = new HashSet();
    private final Set<FileType> myNoLimitCheckTypes = new HashSet<FileType>();
    private final PerIndexDocumentMap<Long> myLastIndexedDocStamps = new PerIndexDocumentMap<Long>(){

        @Override
        protected Long createDefault(Document document) {
            return 0L;
        }
    };
    private final ChangedFilesCollector myChangedFilesCollector;
    private final List<IndexableFileSet> myIndexableSets = ContainerUtil.createEmptyCOWList();
    private final Map<IndexableFileSet, Project> myIndexableSetToProjectMap = new HashMap<IndexableFileSet, Project>();
    public static final int OK = 1;
    public static final int REQUIRES_REBUILD = 2;
    public static final int REBUILD_IN_PROGRESS = 3;
    private static final Map<ID<?, ?>, AtomicInteger> ourRebuildStatus = new HashMap();
    private final VirtualFileManagerEx myVfManager;
    private final FileDocumentManager myFileDocumentManager;
    private final ConcurrentHashSet<ID<?, ?>> myUpToDateIndices = new ConcurrentHashSet();
    private final Map<Document, PsiFile> myTransactionMap = new HashMap<Document, PsiFile>();
    private static final int ALREADY_PROCESSED = 2;
    @Nullable
    private String myConfigPath;
    @Nullable
    private String mySystemPath;
    private final boolean myIsUnitTestMode;
    private ScheduledFuture<?> myFlushingFuture;
    private volatile int myLocalModCount;
    private AtomicBoolean myShutdownPerformed = new AtomicBoolean(false);
    private static final ThreadLocal<Integer> myUpToDateCheckState = new ThreadLocal();
    private final ThreadLocal<Boolean> myReentrancyGuard = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };
    public static final Key<PsiFile> PSI_FILE = new Key("PSI for stubs");
    public static final Key<EditorHighlighter> EDITOR_HIGHLIGHTER = new Key("Editor");
    public static final Key<Project> PROJECT = new Key("Context project");
    public static final Key<VirtualFile> VIRTUAL_FILE = new Key("Context virtual file");
    private final StorageGuard myStorageLock = new StorageGuard();

    public void requestReindex(VirtualFile file) {
        this.myChangedFilesCollector.invalidateIndices(file, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileBasedIndex(VirtualFileManagerEx vfManager, FileDocumentManager fdm, MessageBus bus) throws IOException {
        this.myVfManager = vfManager;
        this.myFileDocumentManager = fdm;
        this.myIsUnitTestMode = ApplicationManager.getApplication().isUnitTestMode();
        this.myConfigPath = FileBasedIndex.calcConfigPath(PathManager.getConfigPath());
        this.mySystemPath = FileBasedIndex.calcConfigPath(PathManager.getSystemPath());
        MessageBusConnection connection = bus.connect();
        connection.subscribe(PsiDocumentTransactionListener.TOPIC, (Object)new PsiDocumentTransactionListener(){

            @Override
            public void transactionStarted(Document doc, PsiFile file) {
                if (file != null) {
                    FileBasedIndex.this.myTransactionMap.put(doc, file);
                    FileBasedIndex.this.myUpToDateIndices.clear();
                }
            }

            @Override
            public void transactionCompleted(Document doc, PsiFile file) {
                FileBasedIndex.this.myTransactionMap.remove(doc);
            }
        });
        connection.subscribe(AppTopics.FILE_TYPES, (Object)new FileTypeListener(){
            private Map<FileType, Set<String>> myTypeToExtensionMap;

            public void beforeFileTypesChanged(FileTypeEvent event) {
                FileBasedIndex.cleanupProcessedFlag();
                this.myTypeToExtensionMap = new HashMap<FileType, Set<String>>();
                FileTypeManager manager = event.getManager();
                for (FileType type : manager.getRegisteredFileTypes()) {
                    this.myTypeToExtensionMap.put(type, this.getExtensions(manager, type));
                }
            }

            public void fileTypesChanged(FileTypeEvent event) {
                Map<FileType, Set<String>> oldExtensions = this.myTypeToExtensionMap;
                this.myTypeToExtensionMap = null;
                if (oldExtensions != null) {
                    FileTypeManager manager = event.getManager();
                    HashMap<FileType, Set<String>> newExtensions = new HashMap<FileType, Set<String>>();
                    for (FileType type : manager.getRegisteredFileTypes()) {
                        newExtensions.put(type, this.getExtensions(manager, type));
                    }
                    if (!newExtensions.keySet().containsAll(oldExtensions.keySet())) {
                        this.rebuildAllndices();
                        return;
                    }
                    for (FileType type : oldExtensions.keySet()) {
                        if (((Set)newExtensions.get(type)).containsAll((Collection)oldExtensions.get(type))) continue;
                        this.rebuildAllndices();
                        return;
                    }
                }
            }

            private Set<String> getExtensions(FileTypeManager manager, FileType type) {
                HashSet<String> set = new HashSet<String>();
                for (FileNameMatcher matcher : manager.getAssociations(type)) {
                    set.add(matcher.getPresentableString());
                }
                return set;
            }

            private void rebuildAllndices() {
                for (ID indexId : FileBasedIndex.this.myIndices.keySet()) {
                    try {
                        FileBasedIndex.this.clearIndex(indexId);
                    }
                    catch (StorageException e) {
                        LOG.info((Throwable)e);
                    }
                }
                FileBasedIndex.this.scheduleIndexRebuild(true);
            }
        });
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void before(List<? extends VFileEvent> events) {
                for (VFileEvent vFileEvent : events) {
                    if (!(vFileEvent.getRequestor() instanceof FileDocumentManager)) continue;
                    FileBasedIndex.this.cleanupMemoryStorage();
                    break;
                }
            }

            public void after(List<? extends VFileEvent> events) {
            }
        });
        connection.subscribe(AppTopics.FILE_DOCUMENT_SYNC, (Object)new FileDocumentManagerAdapter(){

            public void fileContentReloaded(VirtualFile file, Document document) {
                FileBasedIndex.this.cleanupMemoryStorage();
            }

            public void unsavedDocumentsDropped() {
                FileBasedIndex.this.cleanupMemoryStorage();
            }
        });
        ApplicationManager.getApplication().addApplicationListener((ApplicationListener)new ApplicationAdapter(){

            public void writeActionStarted(Object action) {
                FileBasedIndex.this.myUpToDateIndices.clear();
            }
        });
        this.myChangedFilesCollector = new ChangedFilesCollector();
        try {
            FileBasedIndexExtension[] extensions;
            for (FileBasedIndexExtension extension : extensions = (FileBasedIndexExtension[])Extensions.getExtensions(FileBasedIndexExtension.EXTENSION_POINT_NAME)) {
                ourRebuildStatus.put(extension.getName(), new AtomicInteger(1));
            }
            File corruptionMarker = new File(PathManager.getIndexRoot(), CORRUPTION_MARKER_NAME);
            boolean currentVersionCorrupted = corruptionMarker.exists();
            for (FileBasedIndexExtension extension : extensions) {
                this.registerIndexer(extension, currentVersionCorrupted);
            }
            FileUtil.delete((File)corruptionMarker);
            this.dropUnregisteredIndices();
            for (ID<?, ?> indexId : this.myIndices.keySet()) {
                if (!ourRebuildStatus.get(indexId).compareAndSet(2, 1)) continue;
                try {
                    this.clearIndex(indexId);
                }
                catch (StorageException e) {
                    FileBasedIndex.requestRebuild(indexId);
                    LOG.error((Throwable)e);
                }
            }
            this.myVfManager.addVirtualFileListener((VirtualFileListener)this.myChangedFilesCollector);
            this.registerIndexableSet(new AdditionalIndexableFileSet(), null);
        }
        catch (Throwable throwable) {
            ShutDownTracker.getInstance().registerShutdownTask(new Runnable(){

                @Override
                public void run() {
                    FileBasedIndex.this.performShutdown();
                }
            });
            FileBasedIndex.saveRegisteredIndices(this.myIndices.keySet());
            this.myFlushingFuture = JobScheduler.getScheduler().scheduleAtFixedRate(new Runnable(){
                int lastModCount = 0;

                @Override
                public void run() {
                    if (this.lastModCount == FileBasedIndex.this.myLocalModCount && !HeavyProcessLatch.INSTANCE.isRunning()) {
                        FileBasedIndex.this.flushAllIndices();
                    }
                    this.lastModCount = FileBasedIndex.this.myLocalModCount;
                }
            }, 5000L, 5000L, TimeUnit.MILLISECONDS);
            throw throwable;
        }
        ShutDownTracker.getInstance().registerShutdownTask(new /* invalid duplicate definition of identical inner class */);
        FileBasedIndex.saveRegisteredIndices(this.myIndices.keySet());
        this.myFlushingFuture = JobScheduler.getScheduler().scheduleAtFixedRate(new /* invalid duplicate definition of identical inner class */, 5000L, 5000L, TimeUnit.MILLISECONDS);
    }

    public void initComponent() {
    }

    private static String calcConfigPath(String path) {
        try {
            String _path = FileUtil.toSystemIndependentName((String)new File(path).getCanonicalPath());
            return _path.endsWith("/") ? _path : _path + "/";
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            return null;
        }
    }

    public static FileBasedIndex getInstance() {
        return FileBasedIndexHolder.ourInstance;
    }

    private <K, V> void registerIndexer(FileBasedIndexExtension<K, V> extension, boolean isCurrentVersionCorrupted) throws IOException {
        ID<K, V> name = extension.getName();
        int version = extension.getVersion();
        if (!extension.dependsOnFileContent()) {
            this.myNotRequiringContentIndices.add(name);
        }
        this.myIndexIdToVersionMap.put(name, version);
        File versionFile = IndexInfrastructure.getVersionFile(name);
        if (isCurrentVersionCorrupted || IndexInfrastructure.versionDiffers(versionFile, version)) {
            if (!isCurrentVersionCorrupted) {
                LOG.info("Version has changed for index " + extension.getName() + ". The index will be rebuilt.");
            }
            FileUtil.delete((File)IndexInfrastructure.getIndexRootDir(name));
            IndexInfrastructure.rewriteVersion(versionFile, version);
        }
        for (int attempt = 0; attempt < 2; ++attempt) {
            try {
                MapIndexStorage<K, V> storage = new MapIndexStorage<K, V>(IndexInfrastructure.getStorageFile(name), extension.getKeyDescriptor(), extension.getValueExternalizer(), extension.getCacheSize());
                MemoryIndexStorage<K, V> memStorage = new MemoryIndexStorage<K, V>(storage);
                UpdatableIndex<K, V, FileContent> index = this.createIndex(name, extension, memStorage);
                this.myIndices.put(name, new Pair(index, (Object)new IndexableFilesFilter(extension.getInputFilter())));
                this.myUnsavedDataIndexingSemaphores.put(name, new Semaphore());
                this.myNoLimitCheckTypes.addAll(extension.getFileTypesWithSizeLimitNotApplicable());
                break;
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
                FileUtil.delete((File)IndexInfrastructure.getIndexRootDir(name));
                IndexInfrastructure.rewriteVersion(versionFile, version);
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveRegisteredIndices(Collection<ID<?, ?>> ids) {
        File file = FileBasedIndex.getRegisteredIndicesFile();
        try {
            FileUtil.createIfDoesntExist((File)file);
            DataOutputStream os = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            try {
                os.writeInt(ids.size());
                for (ID<?, ?> id : ids) {
                    IOUtil.writeString((String)id.toString(), (DataOutput)os);
                }
            }
            finally {
                os.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<String> readRegistsredIndexNames() {
        HashSet<String> result = new HashSet<String>();
        try {
            DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(FileBasedIndex.getRegisteredIndicesFile())));
            try {
                int size = in.readInt();
                for (int idx = 0; idx < size; ++idx) {
                    result.add(IOUtil.readString((DataInput)in));
                }
            }
            finally {
                in.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    private static File getRegisteredIndicesFile() {
        return new File(PathManager.getIndexRoot(), "registered");
    }

    private static File getMarkerFile() {
        return new File(PathManager.getIndexRoot(), "work_in_progress");
    }

    private <K, V> UpdatableIndex<K, V, FileContent> createIndex(final ID<K, V> indexId, FileBasedIndexExtension<K, V> extension, final MemoryIndexStorage<K, V> storage) throws IOException {
        MapReduceIndex index;
        if (extension instanceof CustomImplementationFileBasedIndexExtension) {
            UpdatableIndex custom = ((CustomImplementationFileBasedIndexExtension)extension).createIndexImplementation(indexId, this, storage);
            if (!(custom instanceof MapReduceIndex)) {
                return custom;
            }
            index = (MapReduceIndex)custom;
        } else {
            index = new MapReduceIndex(indexId, extension.getIndexer(), storage);
        }
        final KeyDescriptor<K> keyDescriptor = extension.getKeyDescriptor();
        index.setInputIdToDataKeysIndex(new Factory<PersistentHashMap<Integer, Collection<K>>>(){

            public PersistentHashMap<Integer, Collection<K>> create() {
                try {
                    return FileBasedIndex.createIdToDataKeysIndex(indexId, keyDescriptor, storage);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        return index;
    }

    private static <K> PersistentHashMap<Integer, Collection<K>> createIdToDataKeysIndex(ID<K, ?> indexId, final KeyDescriptor<K> keyDescriptor, MemoryIndexStorage<K, ?> storage) throws IOException {
        File indexStorageFile = IndexInfrastructure.getInputIndexStorageFile(indexId);
        final Ref isBufferingMode = new Ref((Object)false);
        com.intellij.util.containers.HashMap tempMap = new com.intellij.util.containers.HashMap();
        DataExternalizer dataExternalizer = new DataExternalizer<Collection<K>>(){

            public void save(DataOutput out, Collection<K> value) throws IOException {
                DataInputOutputUtil.writeINT((DataOutput)out, (int)value.size());
                for (Object key : value) {
                    keyDescriptor.save(out, key);
                }
            }

            public Collection<K> read(DataInput in) throws IOException {
                int size = DataInputOutputUtil.readINT((DataInput)in);
                ArrayList<Object> list = new ArrayList<Object>();
                for (int idx = 0; idx < size; ++idx) {
                    list.add(keyDescriptor.read(in));
                }
                return list;
            }
        };
        final PersistentHashMap map = new PersistentHashMap<Integer, Collection<K>>(indexStorageFile, (KeyDescriptor)new EnumeratorIntegerDescriptor(), dataExternalizer, (Map)tempMap){
            final /* synthetic */ Map val$tempMap;
            {
                this.val$tempMap = map;
                super(x0, x1, x2);
            }

            public synchronized Collection<K> get(Integer integer) throws IOException {
                Collection collection;
                if (((Boolean)isBufferingMode.get()).booleanValue() && (collection = (Collection)this.val$tempMap.get(integer)) != null) {
                    return collection;
                }
                return (Collection)super.get((Object)integer);
            }

            public synchronized void put(Integer integer, Collection<K> ks) throws IOException {
                if (((Boolean)isBufferingMode.get()).booleanValue()) {
                    this.val$tempMap.put(integer, ks == null ? Collections.emptySet() : ks);
                } else {
                    super.put((Object)integer, ks);
                }
            }

            public synchronized void remove(Integer integer) throws IOException {
                if (((Boolean)isBufferingMode.get()).booleanValue()) {
                    this.val$tempMap.put(integer, Collections.emptySet());
                } else {
                    super.remove((Object)integer);
                }
            }
        };
        storage.addBufferingStateListsner(new MemoryIndexStorage.BufferingStateListener((Map)tempMap){
            final /* synthetic */ Map val$tempMap;
            {
                this.val$tempMap = map2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void bufferingStateChanged(boolean newState) {
                PersistentHashMap persistentHashMap = map;
                synchronized (persistentHashMap) {
                    isBufferingMode.set((Object)newState);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void memoryStorageCleared() {
                PersistentHashMap persistentHashMap = map;
                synchronized (persistentHashMap) {
                    this.val$tempMap.clear();
                }
            }
        });
        return map;
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if ("FileBasedIndex" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/indexing/FileBasedIndex.getComponentName must not return null");
        }
        return "FileBasedIndex";
    }

    public void disposeComponent() {
        this.performShutdown();
    }

    private void performShutdown() {
        if (!this.myShutdownPerformed.compareAndSet(false, true)) {
            return;
        }
        if (this.myFlushingFuture != null) {
            this.myFlushingFuture.cancel(false);
            this.myFlushingFuture = null;
        }
        this.myFileDocumentManager.saveAllDocuments();
        LOG.info("START INDEX SHUTDOWN");
        try {
            this.myChangedFilesCollector.forceUpdate(null, null, true);
            for (ID<?, ?> indexId : this.myIndices.keySet()) {
                UpdatableIndex<?, ?, FileContent> index = this.getIndex(indexId);
                assert (index != null);
                this.checkRebuild(indexId, true);
                index.dispose();
            }
            this.myVfManager.removeVirtualFileListener((VirtualFileListener)this.myChangedFilesCollector);
        }
        catch (Throwable e) {
            LOG.info("Problems during index shutdown", e);
            throw new RuntimeException(e);
        }
        LOG.info("END INDEX SHUTDOWN");
    }

    private void flushAllIndices() {
        IndexingStamp.flushCache();
        for (ID<?, ?> indexId : new ArrayList(this.myIndices.keySet())) {
            try {
                UpdatableIndex<?, ?, FileContent> index = this.getIndex(indexId);
                if (index == null) continue;
                index.flush();
            }
            catch (StorageException e) {
                LOG.info((Throwable)e);
                FileBasedIndex.requestRebuild(indexId);
            }
        }
    }

    @NotNull
    public <K> Collection<K> getAllKeys(ID<K, ?> indexId, @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/indexing/FileBasedIndex.getAllKeys must not be null");
        }
        HashSet allKeys = new HashSet();
        this.processAllKeys(indexId, (Processor<K>)new CommonProcessors.CollectProcessor(allKeys), project);
        HashSet hashSet = allKeys;
        if (hashSet == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/indexing/FileBasedIndex.getAllKeys must not return null");
        }
        return hashSet;
    }

    public <K> boolean processAllKeys(ID<K, ?> indexId, Processor<K> processor, @Nullable Project project) {
        try {
            this.ensureUpToDate(indexId, project, (GlobalSearchScope)(project != null ? GlobalSearchScope.allScope((Project)project) : new EverythingGlobalScope()));
            UpdatableIndex<K, ?, FileContent> index = this.getIndex(indexId);
            if (index == null) {
                return true;
            }
            return index.processAllKeys(processor);
        }
        catch (StorageException e) {
            this.scheduleRebuild(indexId, e);
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof StorageException || cause instanceof IOException) {
                this.scheduleRebuild(indexId, cause);
            }
            throw e;
        }
        return false;
    }

    public static void disableUpToDateCheckForCurrentThread() {
        Integer currentValue = myUpToDateCheckState.get();
        myUpToDateCheckState.set(currentValue == null ? 1 : currentValue + 1);
    }

    public static void enableUpToDateCheckForCurrentThread() {
        Integer currentValue = myUpToDateCheckState.get();
        if (currentValue != null) {
            int newValue = currentValue - 1;
            if (newValue != 0) {
                myUpToDateCheckState.set(newValue);
            } else {
                myUpToDateCheckState.remove();
            }
        }
    }

    private static boolean isUpToDateCheckEnabled() {
        Integer value = myUpToDateCheckState.get();
        return value == null || value == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K> void ensureUpToDate(ID<K, ?> indexId, @Nullable Project project, @Nullable GlobalSearchScope filter) {
        block9: {
            if (FileBasedIndex.isDumb(project)) {
                this.handleDumbMode(indexId, project);
            }
            if (this.myReentrancyGuard.get().booleanValue()) {
                return;
            }
            this.myReentrancyGuard.set(Boolean.TRUE);
            try {
                this.myChangedFilesCollector.ensureAllInvalidateTasksCompleted();
                if (!FileBasedIndex.isUpToDateCheckEnabled()) break block9;
                try {
                    this.checkRebuild(indexId, false);
                    this.myChangedFilesCollector.forceUpdate(project, filter, false);
                    this.indexUnsavedDocuments(indexId, project, filter);
                }
                catch (StorageException e) {
                    this.scheduleRebuild(indexId, e);
                }
                catch (RuntimeException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof StorageException || cause instanceof IOException) {
                        this.scheduleRebuild(indexId, e);
                        break block9;
                    }
                    throw e;
                }
            }
            finally {
                this.myReentrancyGuard.set(Boolean.FALSE);
            }
        }
    }

    private void handleDumbMode(ID<?, ?> indexId, @Nullable Project project) {
        BackgroundableProcessIndicator indicator;
        ProgressIndicator progressIndicator;
        if (this.myNotRequiringContentIndices.contains(indexId)) {
            return;
        }
        ProgressManager.checkCanceled();
        if (project != null && (progressIndicator = ProgressManager.getInstance().getProgressIndicator()) instanceof BackgroundableProcessIndicator && (indicator = (BackgroundableProcessIndicator)progressIndicator).getDumbModeAction() == DumbModeAction.WAIT) {
            assert (!ApplicationManager.getApplication().isDispatchThread());
            DumbService.getInstance((Project)project).waitForSmartMode();
            return;
        }
        throw new IndexNotReadyException();
    }

    private static boolean isDumb(@Nullable Project project) {
        if (project != null) {
            return DumbServiceImpl.getInstance(project).isDumb();
        }
        for (Project proj : ProjectManager.getInstance().getOpenProjects()) {
            if (!DumbServiceImpl.getInstance(proj).isDumb()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public <K, V> List<V> getValues(ID<K, V> indexId, @NotNull K dataKey, @NotNull GlobalSearchScope filter) {
        if (dataKey == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/indexing/FileBasedIndex.getValues must not be null");
        }
        if (filter == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/util/indexing/FileBasedIndex.getValues must not be null");
        }
        final ArrayList values = new ArrayList();
        this.processValuesImpl(indexId, dataKey, true, null, new ValueProcessor<V>(){

            @Override
            public boolean process(VirtualFile file, V value) {
                values.add(value);
                return true;
            }
        }, filter);
        ArrayList arrayList = values;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/indexing/FileBasedIndex.getValues must not return null");
        }
        return arrayList;
    }

    @NotNull
    public <K, V> Collection<VirtualFile> getContainingFiles(ID<K, V> indexId, @NotNull K dataKey, @NotNull GlobalSearchScope filter) {
        if (dataKey == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/indexing/FileBasedIndex.getContainingFiles must not be null");
        }
        if (filter == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/util/indexing/FileBasedIndex.getContainingFiles must not be null");
        }
        final HashSet<VirtualFile> files = new HashSet<VirtualFile>();
        this.processValuesImpl(indexId, dataKey, false, null, new ValueProcessor<V>(){

            @Override
            public boolean process(VirtualFile file, V value) {
                files.add(file);
                return true;
            }
        }, filter);
        HashSet<VirtualFile> hashSet = files;
        if (hashSet == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/indexing/FileBasedIndex.getContainingFiles must not return null");
        }
        return hashSet;
    }

    public <K, V> boolean processValues(ID<K, V> indexId, @NotNull K dataKey, @Nullable VirtualFile inFile, ValueProcessor<V> processor, @NotNull GlobalSearchScope filter) {
        if (dataKey == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/indexing/FileBasedIndex.processValues must not be null");
        }
        if (filter == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of com/intellij/util/indexing/FileBasedIndex.processValues must not be null");
        }
        return this.processValuesImpl(indexId, dataKey, false, inFile, processor, filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <K, V> boolean processValuesImpl(ID<K, V> indexId, K dataKey, boolean ensureValueProcessedOnce, @Nullable VirtualFile restrictToFile, ValueProcessor<V> processor, GlobalSearchScope filter) {
        block14: {
            Project project = filter.getProject();
            this.ensureUpToDate(indexId, project, filter);
            UpdatableIndex<K, V, FileContent> index = this.getIndex(indexId);
            if (index == null) {
                return true;
            }
            Lock readLock = index.getReadLock();
            try {
                readLock.lock();
                ValueContainer container = index.getData(dataKey);
                boolean shouldContinue = true;
                if (restrictToFile != null) {
                    if (restrictToFile instanceof VirtualFileWithId) {
                        Object value;
                        int restrictedFileId = FileBasedIndex.getFileId(restrictToFile);
                        Iterator valueIt = container.getValueIterator();
                        while (valueIt.hasNext() && (!container.isAssociated(value = valueIt.next(), restrictedFileId) || (shouldContinue = processor.process(restrictToFile, value)))) {
                        }
                    }
                } else {
                    PersistentFS fs = (PersistentFS)ManagingFS.getInstance();
                    Iterator valueIt = container.getValueIterator();
                    block7: while (valueIt.hasNext()) {
                        Object value = valueIt.next();
                        ValueContainer.IntIterator inputIdsIterator = container.getInputIdsIterator(value);
                        while (inputIdsIterator.hasNext()) {
                            int id = inputIdsIterator.next();
                            VirtualFile file = IndexInfrastructure.findFileById(fs, id);
                            if (file == null || !filter.accept(file)) continue;
                            shouldContinue = processor.process(file, value);
                            if (!shouldContinue) break block7;
                            if (!ensureValueProcessedOnce) continue;
                            continue block7;
                        }
                    }
                }
                boolean bl = shouldContinue;
                index.getReadLock().unlock();
                return bl;
            }
            catch (Throwable throwable) {
                try {
                    index.getReadLock().unlock();
                    throw throwable;
                }
                catch (StorageException e) {
                    this.scheduleRebuild(indexId, e);
                }
                catch (RuntimeException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof StorageException || cause instanceof IOException) {
                        this.scheduleRebuild(indexId, cause);
                        break block14;
                    }
                    throw e;
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <K, V> boolean getFilesWithKey(ID<K, V> indexId, Set<K> dataKeys, Processor<VirtualFile> processor, GlobalSearchScope filter) {
        try {
            Project project = filter.getProject();
            this.ensureUpToDate(indexId, project, filter);
            UpdatableIndex<K, V, FileContent> index = this.getIndex(indexId);
            if (index == null) {
                return true;
            }
            Lock readLock = index.getReadLock();
            try {
                int id;
                VirtualFile file;
                readLock.lock();
                ArrayList<TIntHashSet> locals = new ArrayList<TIntHashSet>();
                for (K dataKey : dataKeys) {
                    TIntHashSet local = new TIntHashSet();
                    locals.add(local);
                    ValueContainer container = index.getData(dataKey);
                    Iterator valueIt = container.getValueIterator();
                    while (valueIt.hasNext()) {
                        Object value = valueIt.next();
                        ValueContainer.IntIterator inputIdsIterator = container.getInputIdsIterator(value);
                        while (inputIdsIterator.hasNext()) {
                            int id2 = inputIdsIterator.next();
                            local.add(id2);
                        }
                    }
                }
                if (locals.size() == 0) {
                    boolean i$ = true;
                    return i$;
                }
                Collections.sort(locals, new Comparator<TIntHashSet>(){

                    @Override
                    public int compare(TIntHashSet o1, TIntHashSet o2) {
                        return o1.size() - o2.size();
                    }
                });
                PersistentFS fs = (PersistentFS)ManagingFS.getInstance();
                TIntIterator ids = FileBasedIndex.join(locals).iterator();
                do {
                    if (!ids.hasNext()) return true;
                } while ((file = IndexInfrastructure.findFileById(fs, id = ids.next())) == null || !filter.accept(file) || processor.process((Object)file));
                boolean bl = false;
                return bl;
            }
            finally {
                index.getReadLock().unlock();
            }
        }
        catch (StorageException e) {
            this.scheduleRebuild(indexId, e);
            return true;
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (!(cause instanceof StorageException)) {
                if (!(cause instanceof IOException)) throw e;
            }
            this.scheduleRebuild(indexId, cause);
            return true;
        }
    }

    private static TIntHashSet join(List<TIntHashSet> locals) {
        TIntHashSet result = locals.get(0);
        if (locals.size() > 1) {
            TIntIterator it = result.iterator();
            block0: while (it.hasNext()) {
                int id = it.next();
                for (int i = 1; i < locals.size(); ++i) {
                    if (locals.get(i).contains(id)) continue;
                    it.remove();
                    continue block0;
                }
            }
        }
        return result;
    }

    public <K> void scheduleRebuild(ID<K, ?> indexId, Throwable e) {
        LOG.info(e);
        FileBasedIndex.requestRebuild(indexId);
        this.checkRebuild(indexId, false);
    }

    private void checkRebuild(final ID<?, ?> indexId, final boolean cleanupOnly) {
        if (ourRebuildStatus.get(indexId).compareAndSet(2, 3)) {
            FileBasedIndex.cleanupProcessedFlag();
            final Runnable rebuildRunnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        FileBasedIndex.this.clearIndex(indexId);
                        if (!cleanupOnly) {
                            FileBasedIndex.this.scheduleIndexRebuild(false);
                        }
                    }
                    catch (StorageException e) {
                        FileBasedIndex.requestRebuild(indexId);
                        LOG.info((Throwable)e);
                    }
                    finally {
                        ((AtomicInteger)ourRebuildStatus.get(indexId)).compareAndSet(3, 1);
                    }
                }
            };
            if (cleanupOnly || this.myIsUnitTestMode) {
                rebuildRunnable.run();
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        new Task.Modal(null, "Updating index", false){

                            public void run(@NotNull ProgressIndicator indicator) {
                                if (indicator == null) {
                                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/indexing/FileBasedIndex$18$1.run must not be null");
                                }
                                indicator.setIndeterminate(true);
                                rebuildRunnable.run();
                            }
                        }.queue();
                    }
                });
            }
        }
        if (ourRebuildStatus.get(indexId).get() == 3) {
            throw new ProcessCanceledException();
        }
    }

    private void scheduleIndexRebuild(boolean forceDumbMode) {
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            Set<CacheUpdater> updatersToRun = Collections.singleton(new UnindexedFilesUpdater(project, this));
            DumbServiceImpl service = DumbServiceImpl.getInstance(project);
            if (forceDumbMode) {
                service.queueCacheUpdateInDumbMode(updatersToRun);
                continue;
            }
            service.queueCacheUpdate(updatersToRun);
        }
    }

    private void clearIndex(ID<?, ?> indexId) throws StorageException {
        UpdatableIndex<?, ?, FileContent> index = this.getIndex(indexId);
        assert (index != null);
        index.clear();
        try {
            IndexInfrastructure.rewriteVersion(IndexInfrastructure.getVersionFile(indexId), this.myIndexIdToVersionMap.get(indexId));
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    private Set<Document> getUnsavedOrTransactedDocuments() {
        HashSet<Document> docs = new HashSet<Document>(Arrays.asList(this.myFileDocumentManager.getUnsavedDocuments()));
        docs.addAll(this.myTransactionMap.keySet());
        return docs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void indexUnsavedDocuments(ID<?, ?> indexId, @Nullable Project project, GlobalSearchScope filter) throws StorageException {
        if (this.myUpToDateIndices.contains(indexId)) {
            return;
        }
        Set<Document> documents = this.getUnsavedOrTransactedDocuments();
        if (!documents.isEmpty()) {
            StorageGuard.Holder guard = this.setDataBufferingEnabled(true);
            try {
                boolean allDocsProcessed = true;
                Semaphore semaphore = this.myUnsavedDataIndexingSemaphores.get(indexId);
                semaphore.down();
                try {
                    for (Document document : documents) {
                        allDocsProcessed &= this.indexUnsavedDocument(document, indexId, project, filter);
                    }
                }
                finally {
                    semaphore.up();
                    while (!semaphore.waitFor(500L) && !Thread.holdsLock(PsiLock.LOCK)) {
                    }
                    if (allDocsProcessed) {
                        this.myUpToDateIndices.add(indexId);
                    }
                }
            }
            finally {
                guard.leave();
            }
        }
    }

    private boolean indexUnsavedDocument(final Document document, final ID<?, ?> requestedIndexId, final Project project, GlobalSearchScope filter) throws StorageException {
        final VirtualFile vFile = this.myFileDocumentManager.getFile(document);
        if (!(vFile instanceof VirtualFileWithId) || !vFile.isValid()) {
            return true;
        }
        if (filter != null && !filter.accept(vFile)) {
            return false;
        }
        final PsiFile dominantContentFile = this.findDominantPsiForDocument(document, project);
        final DocumentContent content = dominantContentFile != null && dominantContentFile.getModificationStamp() != document.getModificationStamp() ? new PsiContent(document, dominantContentFile) : new AuthenticContent(document);
        long currentDocStamp = content.getModificationStamp();
        if (currentDocStamp != this.myLastIndexedDocStamps.getAndSet(document, requestedIndexId, currentDocStamp)) {
            final Ref exRef = new Ref(null);
            ProgressManager.getInstance().executeNonCancelableSection(new Runnable(){

                @Override
                public void run() {
                    try {
                        FileContent newFc = new FileContent(vFile, content.getText(), vFile.getCharset());
                        if (dominantContentFile != null) {
                            dominantContentFile.putUserData(PsiFileImpl.BUILDING_STUB, (Object)true);
                            newFc.putUserData(PSI_FILE, dominantContentFile);
                        }
                        if (content instanceof AuthenticContent) {
                            newFc.putUserData(EDITOR_HIGHLIGHTER, document instanceof DocumentImpl ? ((DocumentImpl)document).getEditorHighlighterForCachesBuilding() : null);
                        }
                        if (FileBasedIndex.this.getInputFilter(requestedIndexId).acceptInput(vFile)) {
                            newFc.putUserData(PROJECT, project);
                            int inputId = Math.abs(FileBasedIndex.getFileId(vFile));
                            FileBasedIndex.this.getIndex(requestedIndexId).update(inputId, newFc);
                        }
                        if (dominantContentFile != null) {
                            dominantContentFile.putUserData(PsiFileImpl.BUILDING_STUB, null);
                        }
                    }
                    catch (StorageException e) {
                        exRef.set((Object)e);
                    }
                }
            });
            StorageException storageException = (StorageException)exRef.get();
            if (storageException != null) {
                throw storageException;
            }
        }
        return true;
    }

    @Nullable
    private PsiFile findDominantPsiForDocument(Document document, @Nullable Project project) {
        if (this.myTransactionMap.containsKey(document)) {
            return this.myTransactionMap.get(document);
        }
        return project == null ? null : FileBasedIndex.findLatestKnownPsiForUncomittedDocument(document, project);
    }

    private StorageGuard.Holder setDataBufferingEnabled(boolean enabled) {
        StorageGuard.Holder holder = this.myStorageLock.enter(enabled);
        for (ID<?, ?> indexId : this.myIndices.keySet()) {
            MapReduceIndex index = (MapReduceIndex)this.getIndex(indexId);
            assert (index != null);
            IndexStorage indexStorage = index.getStorage();
            ((MemoryIndexStorage)indexStorage).setBufferingEnabled(enabled);
        }
        return holder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupMemoryStorage() {
        PerIndexDocumentMap<Long> perIndexDocumentMap = this.myLastIndexedDocStamps;
        synchronized (perIndexDocumentMap) {
            this.myLastIndexedDocStamps.clear();
        }
        for (ID<?, ?> indexId : this.myIndices.keySet()) {
            MapReduceIndex index = (MapReduceIndex)this.getIndex(indexId);
            assert (index != null);
            MemoryIndexStorage memStorage = (MemoryIndexStorage)index.getStorage();
            index.getWriteLock().lock();
            try {
                memStorage.clearMemoryMap();
            }
            finally {
                index.getWriteLock().unlock();
            }
            memStorage.fireMemoryStorageCleared();
        }
    }

    private void dropUnregisteredIndices() {
        Set<String> indicesToDrop = FileBasedIndex.readRegistsredIndexNames();
        for (ID<?, ?> key : this.myIndices.keySet()) {
            indicesToDrop.remove(key.toString());
        }
        for (String s : indicesToDrop) {
            FileUtil.delete((File)IndexInfrastructure.getIndexRootDir(ID.create((String)s)));
        }
    }

    public static void requestRebuild(ID<?, ?> indexId) {
        FileBasedIndex.requestRebuild(indexId, new Throwable());
    }

    public static void requestRebuild(ID<?, ?> indexId, Throwable throwable) {
        FileBasedIndex.cleanupProcessedFlag();
        LOG.info("Rebuild requested for index " + indexId, throwable);
        ourRebuildStatus.get(indexId).set(2);
    }

    private <K, V> UpdatableIndex<K, V, FileContent> getIndex(ID<K, V> indexId) {
        Pair<UpdatableIndex<?, ?, FileContent>, InputFilter> pair = this.myIndices.get(indexId);
        return pair != null ? (UpdatableIndex)pair.getFirst() : null;
    }

    private InputFilter getInputFilter(ID<?, ?> indexId) {
        Pair<UpdatableIndex<?, ?, FileContent>, InputFilter> pair = this.myIndices.get(indexId);
        return pair != null ? (InputFilter)pair.getSecond() : null;
    }

    public int getNumberOfPendingInvalidations() {
        return this.myChangedFilesCollector.getNumberOfPendingInvalidations();
    }

    public Collection<VirtualFile> getFilesToUpdate(final Project project) {
        return ContainerUtil.findAll(this.myChangedFilesCollector.getAllFilesToUpdate(), (Condition)new Condition<VirtualFile>(){

            public boolean value(VirtualFile virtualFile) {
                for (IndexableFileSet set : FileBasedIndex.this.myIndexableSets) {
                    Project proj = (Project)FileBasedIndex.this.myIndexableSetToProjectMap.get(set);
                    if (proj != null && !proj.equals(project) || !set.isInSet(virtualFile)) continue;
                    return true;
                }
                return false;
            }
        });
    }

    public void processRefreshedFile(@NotNull Project project, com.intellij.ide.caches.FileContent fileContent) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/indexing/FileBasedIndex.processRefreshedFile must not be null");
        }
        this.myChangedFilesCollector.ensureAllInvalidateTasksCompleted();
        this.myChangedFilesCollector.processFileImpl(project, fileContent, false);
    }

    public void indexFileContent(@Nullable Project project, com.intellij.ide.caches.FileContent content) {
        this.myChangedFilesCollector.ensureAllInvalidateTasksCompleted();
        VirtualFile file = content.getVirtualFile();
        FileContent fc = null;
        PsiFile psiFile = null;
        for (ID<?, ?> indexId : this.myIndices.keySet()) {
            if (!this.shouldIndexFile(file, indexId)) continue;
            if (fc == null) {
                byte[] currentBytes;
                try {
                    currentBytes = content.getBytes();
                }
                catch (IOException e) {
                    currentBytes = ArrayUtil.EMPTY_BYTE_ARRAY;
                }
                fc = new FileContent(file, currentBytes);
                psiFile = (PsiFile)content.getUserData(PSI_FILE);
                if (psiFile != null) {
                    psiFile.putUserData(PsiFileImpl.BUILDING_STUB, (Object)true);
                    fc.putUserData(PSI_FILE, psiFile);
                }
                if (project == null) {
                    project = ProjectUtil.guessProjectForFile((VirtualFile)file);
                }
                fc.putUserData(PROJECT, project);
            }
            try {
                ProgressManager.checkCanceled();
                this.updateSingleIndex(indexId, file, fc);
            }
            catch (ProcessCanceledException e) {
                this.myChangedFilesCollector.scheduleForUpdate(file);
                throw e;
            }
            catch (StorageException e) {
                FileBasedIndex.requestRebuild(indexId);
                LOG.info((Throwable)e);
            }
        }
        if (psiFile != null) {
            psiFile.putUserData(PsiFileImpl.BUILDING_STUB, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSingleIndex(final ID<?, ?> indexId, final VirtualFile file, final FileContent currentFC) throws StorageException {
        if (ourRebuildStatus.get(indexId).get() == 2) {
            return;
        }
        ++this.myLocalModCount;
        StorageGuard.Holder lock = this.setDataBufferingEnabled(false);
        try {
            final int inputId = Math.abs(FileBasedIndex.getFileId(file));
            final UpdatableIndex<?, ?, FileContent> index = this.getIndex(indexId);
            assert (index != null);
            final Ref exRef = new Ref(null);
            ProgressManager.getInstance().executeNonCancelableSection(new Runnable(){

                @Override
                public void run() {
                    try {
                        index.update(inputId, currentFC);
                    }
                    catch (StorageException e) {
                        exRef.set((Object)e);
                    }
                }
            });
            StorageException storageException = (StorageException)exRef.get();
            if (storageException != null) {
                throw storageException;
            }
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    if (file.isValid()) {
                        if (currentFC != null) {
                            IndexingStamp.update(file, indexId, IndexInfrastructure.getIndexCreationStamp(indexId));
                        } else {
                            IndexingStamp.update(file, indexId, -1L);
                        }
                    }
                }
            });
        }
        finally {
            lock.leave();
        }
    }

    public static int getFileId(VirtualFile file) {
        if (file instanceof VirtualFileWithId) {
            return ((VirtualFileWithId)file).getId();
        }
        throw new IllegalArgumentException("Virtual file doesn't support id: " + file + ", implementation class: " + file.getClass().getName());
    }

    private boolean needsFileContentLoading(ID<?, ?> indexId) {
        return !this.myNotRequiringContentIndices.contains(indexId);
    }

    private boolean shouldUpdateIndex(VirtualFile file, ID<?, ?> indexId) {
        return this.getInputFilter(indexId).acceptInput(file) && (FileBasedIndex.isMock(file) || IndexingStamp.isFileIndexed(file, indexId, IndexInfrastructure.getIndexCreationStamp(indexId)));
    }

    private boolean shouldIndexFile(VirtualFile file, ID<?, ?> indexId) {
        return this.getInputFilter(indexId).acceptInput(file) && (FileBasedIndex.isMock(file) || !IndexingStamp.isFileIndexed(file, indexId, IndexInfrastructure.getIndexCreationStamp(indexId)));
    }

    private boolean isUnderConfigOrSystem(VirtualFile file) {
        String filePath = file.getPath();
        if (this.myConfigPath != null && FileUtil.startsWith((String)filePath, (String)this.myConfigPath)) {
            return true;
        }
        return this.mySystemPath != null && FileUtil.startsWith((String)filePath, (String)this.mySystemPath);
    }

    private static boolean isMock(VirtualFile file) {
        return !(file instanceof NewVirtualFile);
    }

    private boolean isTooLarge(VirtualFile file) {
        if (SingleRootFileViewProvider.isTooLarge(file)) {
            FileType type = FileTypeManager.getInstance().getFileTypeByFile(file);
            return !this.myNoLimitCheckTypes.contains(type);
        }
        return false;
    }

    public CollectingContentIterator createContentIterator() {
        return new UnindexedFilesFinder();
    }

    public void registerIndexableSet(IndexableFileSet set, @Nullable Project project) {
        this.myIndexableSets.add(set);
        this.myIndexableSetToProjectMap.put(set, project);
    }

    public void removeIndexableSet(IndexableFileSet set) {
        this.myChangedFilesCollector.forceUpdate(null, null, true);
        this.myIndexableSets.remove(set);
        this.myIndexableSetToProjectMap.remove(set);
    }

    @Nullable
    private static PsiFile findLatestKnownPsiForUncomittedDocument(Document doc, Project project) {
        return PsiDocumentManager.getInstance((Project)project).getCachedPsiFile(doc);
    }

    private static void cleanupProcessedFlag() {
        VirtualFile[] roots;
        for (VirtualFile root : roots = ManagingFS.getInstance().getRoots()) {
            FileBasedIndex.cleanProcessedFlag(root);
        }
    }

    private static void cleanProcessedFlag(VirtualFile file) {
        if (!(file instanceof NewVirtualFile)) {
            return;
        }
        NewVirtualFile nvf = (NewVirtualFile)file;
        if (file.isDirectory()) {
            for (VirtualFile child : nvf.getCachedChildren()) {
                FileBasedIndex.cleanProcessedFlag(child);
            }
        } else {
            nvf.setFlag(2, false);
        }
    }

    public static void iterateIndexableFiles(ContentIterator processor, Project project) {
        if (project.isDisposed()) {
            return;
        }
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        projectFileIndex.iterateContent(processor);
        if (project.isDisposed()) {
            return;
        }
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        com.intellij.util.containers.HashSet visitedRoots = new com.intellij.util.containers.HashSet();
        for (IndexedRootsProvider indexedRootsProvider : (IndexedRootsProvider[])Extensions.getExtensions(IndexedRootsProvider.EP_NAME)) {
            if (project.isDisposed()) {
                return;
            }
            Set<String> rootsToIndex = indexedRootsProvider.getRootsToIndex();
            for (String url : rootsToIndex) {
                VirtualFile root = VirtualFileManager.getInstance().findFileByUrl(url);
                if (!visitedRoots.add(root)) continue;
                FileBasedIndex.iterateRecursively(root, processor, indicator);
            }
        }
        if (project.isDisposed()) {
            return;
        }
        for (IndexedRootsProvider indexedRootsProvider : ModuleManager.getInstance((Project)project).getModules()) {
            OrderEntry[] orderEntries;
            if (indexedRootsProvider.isDisposed()) {
                return;
            }
            for (OrderEntry orderEntry : orderEntries = ModuleRootManager.getInstance((Module)indexedRootsProvider).getOrderEntries()) {
                if (!(orderEntry instanceof LibraryOrderEntry) && !(orderEntry instanceof JdkOrderEntry) || !orderEntry.isValid()) continue;
                VirtualFile[] libSources = orderEntry.getFiles(OrderRootType.SOURCES);
                VirtualFile[] libClasses = orderEntry.getFiles(OrderRootType.CLASSES);
                VirtualFile[][] arr$ = new VirtualFile[][]{libSources, libClasses};
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    VirtualFile[] roots;
                    for (VirtualFile root : roots = arr$[i$]) {
                        if (!visitedRoots.add(root)) continue;
                        FileBasedIndex.iterateRecursively(root, processor, indicator);
                    }
                }
            }
        }
    }

    private static void iterateRecursively(@Nullable VirtualFile root, ContentIterator processor, ProgressIndicator indicator) {
        if (root != null) {
            if (indicator != null) {
                indicator.setText2(root.getPresentableUrl());
            }
            if (root.isDirectory()) {
                for (VirtualFile file : root.getChildren()) {
                    if (file.isDirectory()) {
                        FileBasedIndex.iterateRecursively(file, processor, indicator);
                        continue;
                    }
                    processor.processFile(file);
                }
            } else {
                processor.processFile(root);
            }
        }
    }

    private static class StorageGuard {
        private int myHolds = 0;
        private final Holder myTrueHolder = new Holder(){

            @Override
            public void leave() {
                StorageGuard.this.leave(true);
            }
        };
        private final Holder myFalseHolder = new Holder(){

            @Override
            public void leave() {
                StorageGuard.this.leave(false);
            }
        };

        private StorageGuard() {
        }

        public synchronized Holder enter(boolean mode) {
            if (mode) {
                while (this.myHolds < 0) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ignored) {}
                }
                ++this.myHolds;
                return this.myTrueHolder;
            }
            while (this.myHolds > 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            --this.myHolds;
            return this.myFalseHolder;
        }

        private synchronized void leave(boolean mode) {
            this.myHolds += mode ? -1 : 1;
            if (this.myHolds == 0) {
                this.notifyAll();
            }
        }

        public static interface Holder {
            public void leave();
        }
    }

    private static class IndexableFilesFilter
    implements InputFilter {
        private final InputFilter myDelegate;

        private IndexableFilesFilter(InputFilter delegate) {
            this.myDelegate = delegate;
        }

        @Override
        public boolean acceptInput(VirtualFile file) {
            return file instanceof VirtualFileWithId && this.myDelegate.acceptInput(file);
        }
    }

    private class UnindexedFilesFinder
    implements CollectingContentIterator {
        private final List<VirtualFile> myFiles = new ArrayList<VirtualFile>();
        private final ProgressIndicator myProgressIndicator = ProgressManager.getInstance().getProgressIndicator();

        private UnindexedFilesFinder() {
        }

        public List<VirtualFile> getFiles() {
            return this.myFiles;
        }

        public boolean processFile(VirtualFile file) {
            if (!file.isDirectory()) {
                if (file instanceof NewVirtualFile && ((NewVirtualFile)file).getFlag(2)) {
                    return true;
                }
                if (file instanceof VirtualFileWithId) {
                    boolean oldStuff = true;
                    if (!FileBasedIndex.this.isTooLarge(file)) {
                        for (ID indexId : FileBasedIndex.this.myIndices.keySet()) {
                            try {
                                if (!FileBasedIndex.this.needsFileContentLoading(indexId) || !FileBasedIndex.this.shouldIndexFile(file, indexId)) continue;
                                this.myFiles.add(file);
                                oldStuff = false;
                                break;
                            }
                            catch (RuntimeException e) {
                                Throwable cause = e.getCause();
                                if (cause instanceof IOException || cause instanceof StorageException) {
                                    LOG.info((Throwable)e);
                                    FileBasedIndex.requestRebuild(indexId);
                                    continue;
                                }
                                throw e;
                            }
                        }
                    }
                    FileContent fileContent = null;
                    for (ID indexId : FileBasedIndex.this.myNotRequiringContentIndices) {
                        if (!FileBasedIndex.this.shouldIndexFile(file, indexId)) continue;
                        oldStuff = false;
                        try {
                            if (fileContent == null) {
                                fileContent = new FileContent(file);
                            }
                            FileBasedIndex.this.updateSingleIndex(indexId, file, fileContent);
                        }
                        catch (StorageException e) {
                            LOG.info((Throwable)e);
                            FileBasedIndex.requestRebuild(indexId);
                        }
                    }
                    IndexingStamp.flushCache();
                    if (oldStuff && file instanceof NewVirtualFile) {
                        ((NewVirtualFile)file).setFlag(2, true);
                    }
                }
            } else if (this.myProgressIndicator != null) {
                this.myProgressIndicator.setText("Scanning files to index");
                this.myProgressIndicator.setText2(file.getPresentableUrl());
            }
            return true;
        }
    }

    private final class ChangedFilesCollector
    extends VirtualFileAdapter {
        private final Set<VirtualFile> myFilesToUpdate = new LinkedHashSet<VirtualFile>();
        private final Queue<InvalidationTask> myFutureInvalidations = new LinkedList<InvalidationTask>();
        private final JBReentrantReadWriteLock myLock = LockFactory.createReadWriteLock();
        private final JBLock r = this.myLock.readLock();
        private final JBLock w = this.myLock.writeLock();
        private final ManagingFS myManagingFS = ManagingFS.getInstance();
        private final Semaphore myForceUpdateSemaphore = new Semaphore();

        private ChangedFilesCollector() {
        }

        public void fileCreated(VirtualFileEvent event) {
            this.markDirty(event);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fileDeleted(VirtualFileEvent event) {
            this.w.lock();
            try {
                this.myFilesToUpdate.remove(event.getFile());
            }
            finally {
                this.w.unlock();
            }
        }

        public void fileCopied(VirtualFileCopyEvent event) {
            this.markDirty((VirtualFileEvent)event);
        }

        public void beforeFileDeletion(VirtualFileEvent event) {
            this.invalidateIndices(event.getFile(), false);
        }

        public void beforeContentsChange(VirtualFileEvent event) {
            this.invalidateIndices(event.getFile(), true);
        }

        public void contentsChanged(VirtualFileEvent event) {
            this.markDirty(event);
        }

        public void beforePropertyChange(VirtualFilePropertyEvent event) {
            VirtualFile file;
            if (event.getPropertyName().equals("name") && !(file = event.getFile()).isDirectory()) {
                this.invalidateIndices(file, false);
            }
        }

        public void propertyChanged(VirtualFilePropertyEvent event) {
            if (event.getPropertyName().equals("name") && !event.getFile().isDirectory()) {
                this.markDirty((VirtualFileEvent)event);
            }
        }

        private void markDirty(VirtualFileEvent event) {
            VirtualFile eventFile = event.getFile();
            FileBasedIndex.cleanProcessedFlag(eventFile);
            this.iterateIndexableFiles(eventFile, new Processor<VirtualFile>(){

                public boolean process(VirtualFile file) {
                    FileContent fileContent = null;
                    for (ID indexId : FileBasedIndex.this.myNotRequiringContentIndices) {
                        if (!FileBasedIndex.this.getInputFilter(indexId).acceptInput(file)) continue;
                        try {
                            if (fileContent == null) {
                                fileContent = new FileContent(file);
                            }
                            FileBasedIndex.this.updateSingleIndex(indexId, file, fileContent);
                        }
                        catch (StorageException e) {
                            LOG.info((Throwable)e);
                            FileBasedIndex.requestRebuild(indexId);
                        }
                    }
                    if (!FileBasedIndex.this.isTooLarge(file)) {
                        for (ID indexId : FileBasedIndex.this.myIndices.keySet()) {
                            if (!FileBasedIndex.this.needsFileContentLoading(indexId) || !FileBasedIndex.this.getInputFilter(indexId).acceptInput(file)) continue;
                            ChangedFilesCollector.this.scheduleForUpdate(file);
                            break;
                        }
                    }
                    return true;
                }
            });
            IndexingStamp.flushCache();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void scheduleForUpdate(VirtualFile file) {
            this.w.lock();
            try {
                this.myFilesToUpdate.add(file);
            }
            finally {
                this.w.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void invalidateIndices(final VirtualFile file, boolean markForReindex) {
            if (FileBasedIndex.this.isUnderConfigOrSystem(file)) {
                return;
            }
            if (file.isDirectory()) {
                if (FileBasedIndex.isMock(file) || this.myManagingFS.wereChildrenAccessed(file)) {
                    List<VirtualFile> children = file instanceof NewVirtualFile ? ((NewVirtualFile)file).getInDbChildren() : Arrays.asList(file.getChildren());
                    for (VirtualFile child : children) {
                        if (NullVirtualFile.INSTANCE == child) continue;
                        this.invalidateIndices(child, markForReindex);
                    }
                }
            } else {
                FileBasedIndex.cleanProcessedFlag(file);
                IndexingStamp.flushCache();
                final ArrayList<ID> affectedIndices = new ArrayList<ID>(FileBasedIndex.this.myIndices.size());
                boolean isTooLarge = FileBasedIndex.this.isTooLarge(file);
                for (ID indexId : FileBasedIndex.this.myIndices.keySet()) {
                    try {
                        if (FileBasedIndex.this.myNotRequiringContentIndices.contains(indexId)) {
                            if (!FileBasedIndex.this.shouldUpdateIndex(file, indexId)) continue;
                            FileBasedIndex.this.updateSingleIndex(indexId, file, null);
                            continue;
                        }
                        if (isTooLarge || !FileBasedIndex.this.shouldUpdateIndex(file, indexId)) continue;
                        affectedIndices.add(indexId);
                    }
                    catch (StorageException e) {
                        LOG.info((Throwable)e);
                        FileBasedIndex.requestRebuild(indexId);
                    }
                }
                if (affectedIndices.size() > 0) {
                    if (markForReindex) {
                        ApplicationManager.getApplication().runReadAction(new Runnable(){

                            @Override
                            public void run() {
                                for (ID indexId : affectedIndices) {
                                    IndexingStamp.update(file, indexId, -1L);
                                }
                            }
                        });
                        this.iterateIndexableFiles(file, new Processor<VirtualFile>(){

                            public boolean process(VirtualFile file) {
                                ChangedFilesCollector.this.scheduleForUpdate(file);
                                return true;
                            }
                        });
                    } else {
                        InvalidationTask invalidator = new InvalidationTask(file){

                            @Override
                            public void run() {
                                ChangedFilesCollector.this.removeFileDataFromIndices(affectedIndices, file);
                            }
                        };
                        this.w.lock();
                        try {
                            this.myFutureInvalidations.offer(invalidator);
                        }
                        finally {
                            this.w.unlock();
                        }
                    }
                }
                IndexingStamp.flushCache();
            }
        }

        private void removeFileDataFromIndices(List<ID<?, ?>> affectedIndices, VirtualFile file) {
            Throwable unexpectedError = null;
            for (ID<?, ?> indexId : affectedIndices) {
                try {
                    FileBasedIndex.this.updateSingleIndex(indexId, file, null);
                }
                catch (StorageException e) {
                    LOG.info((Throwable)e);
                    FileBasedIndex.requestRebuild(indexId);
                }
                catch (ProcessCanceledException ignored) {
                }
                catch (Throwable e) {
                    LOG.info(e);
                    if (unexpectedError != null) continue;
                    unexpectedError = e;
                }
            }
            IndexingStamp.flushCache();
            if (unexpectedError != null) {
                LOG.error(unexpectedError);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getNumberOfPendingInvalidations() {
            this.r.lock();
            try {
                int n = this.myFutureInvalidations.size();
                return n;
            }
            finally {
                this.r.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void ensureAllInvalidateTasksCompleted() {
            int size;
            this.r.lock();
            try {
                size = this.myFutureInvalidations.size();
                if (size == 0) {
                    return;
                }
            }
            finally {
                this.r.unlock();
            }
            ProgressIndicator current = ProgressManager.getInstance().getProgressIndicator();
            ProgressIndicator indicator = current != null ? current : new EmptyProgressIndicator();
            indicator.setText("");
            int count = 0;
            while (true) {
                InvalidationTask task;
                this.w.lock();
                try {
                    task = this.myFutureInvalidations.poll();
                }
                finally {
                    this.w.unlock();
                }
                if (task == null) break;
                indicator.setFraction((double)count++ / (double)size);
                indicator.setText2(task.getSubj().getPresentableUrl());
                task.run();
            }
        }

        private void iterateIndexableFiles(VirtualFile file, final Processor<VirtualFile> processor) {
            if (file.isDirectory()) {
                ContentIterator iterator = new ContentIterator(){

                    public boolean processFile(VirtualFile fileOrDir) {
                        if (!fileOrDir.isDirectory()) {
                            processor.process((Object)fileOrDir);
                        }
                        return true;
                    }
                };
                for (IndexableFileSet set : FileBasedIndex.this.myIndexableSets) {
                    set.iterateIndexableFilesIn(file, iterator);
                }
            } else {
                for (IndexableFileSet set : FileBasedIndex.this.myIndexableSets) {
                    if (!set.isInSet(file)) continue;
                    processor.process((Object)file);
                    break;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Collection<VirtualFile> getAllFilesToUpdate() {
            this.r.lock();
            try {
                if (this.myFilesToUpdate.isEmpty()) {
                    List<VirtualFile> list = Collections.emptyList();
                    return list;
                }
                ArrayList<VirtualFile> arrayList = new ArrayList<VirtualFile>(this.myFilesToUpdate);
                return arrayList;
            }
            finally {
                this.r.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void forceUpdate(@Nullable Project project, @Nullable GlobalSearchScope filter, boolean onlyRemoveOutdatedData) {
            FileBasedIndex.this.myChangedFilesCollector.ensureAllInvalidateTasksCompleted();
            for (VirtualFile file : this.getAllFilesToUpdate()) {
                if (filter != null && !filter.accept(file)) continue;
                try {
                    this.myForceUpdateSemaphore.down();
                    this.processFileImpl(project, new com.intellij.ide.caches.FileContent(file), onlyRemoveOutdatedData);
                }
                finally {
                    this.myForceUpdateSemaphore.up();
                }
            }
            while (!this.myForceUpdateSemaphore.waitFor(500L) && !Thread.holdsLock(PsiLock.LOCK)) {
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processFileImpl(Project project, com.intellij.ide.caches.FileContent fileContent, boolean onlyRemoveOutdatedData) {
            boolean reallyRemoved;
            VirtualFile file = fileContent.getVirtualFile();
            this.w.lock();
            try {
                reallyRemoved = this.myFilesToUpdate.remove(file);
            }
            finally {
                this.w.unlock();
            }
            if (reallyRemoved && file.isValid()) {
                if (onlyRemoveOutdatedData) {
                    ArrayList affected = new ArrayList();
                    for (ID indexId : FileBasedIndex.this.myIndices.keySet()) {
                        if (!FileBasedIndex.this.getInputFilter(indexId).acceptInput(file)) continue;
                        affected.add(indexId);
                    }
                    this.removeFileDataFromIndices(affected, file);
                } else {
                    FileBasedIndex.this.indexFileContent(project, fileContent);
                }
                IndexingStamp.flushCache();
            }
        }
    }

    private static abstract class InvalidationTask
    implements Runnable {
        private final VirtualFile mySubj;

        protected InvalidationTask(VirtualFile subj) {
            this.mySubj = subj;
        }

        public VirtualFile getSubj() {
            return this.mySubj;
        }
    }

    private static class PsiContent
    implements DocumentContent {
        private final Document myDocument;
        private final PsiFile myFile;

        private PsiContent(Document document, PsiFile file) {
            this.myDocument = document;
            this.myFile = file;
        }

        @Override
        public String getText() {
            if (this.myFile.getModificationStamp() != this.myDocument.getModificationStamp()) {
                ASTNode node = this.myFile.getNode();
                assert (node != null);
                return node.getText();
            }
            return this.myDocument.getText();
        }

        @Override
        public long getModificationStamp() {
            return this.myFile.getModificationStamp();
        }
    }

    private static class AuthenticContent
    implements DocumentContent {
        private final Document myDocument;

        private AuthenticContent(Document document) {
            this.myDocument = document;
        }

        @Override
        public String getText() {
            return this.myDocument.getText();
        }

        @Override
        public long getModificationStamp() {
            return this.myDocument.getModificationStamp();
        }
    }

    private static interface DocumentContent {
        public String getText();

        public long getModificationStamp();
    }

    public static interface ValueProcessor<V> {
        public boolean process(VirtualFile var1, V var2);
    }

    private static class FileBasedIndexHolder {
        private static final FileBasedIndex ourInstance = (FileBasedIndex)ApplicationManager.getApplication().getComponent(FileBasedIndex.class);

        private FileBasedIndexHolder() {
        }
    }

    public static interface InputFilter {
        public boolean acceptInput(VirtualFile var1);
    }
}

