/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.util.ArrayUtil;
import com.intellij.util.indexing.UpdatableValueContainer;
import com.intellij.util.indexing.ValueContainer;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

class ValueContainerImpl<Value>
extends UpdatableValueContainer<Value>
implements Cloneable {
    private HashMap<Value, Object> myInputIdMapping = new HashMap(16, 0.98f);
    public static final ValueContainer.IntIterator EMPTY_ITERATOR = new ValueContainer.IntIterator(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public int next() {
            return 0;
        }

        @Override
        public int size() {
            return 0;
        }
    };

    @Override
    public void addValue(int inputId, Value value) {
        Object input = this.myInputIdMapping.get(value);
        if (input == null) {
            this.myInputIdMapping.put(value, inputId);
        } else {
            TIntHashSet idSet;
            if (input instanceof Integer) {
                idSet = new IdSet(3, 0.98f);
                idSet.add(((Integer)input).intValue());
                this.myInputIdMapping.put(value, idSet);
            } else {
                idSet = (TIntHashSet)input;
            }
            idSet.add(inputId);
        }
    }

    @Override
    public int size() {
        return this.myInputIdMapping.size();
    }

    @Override
    public void removeAllValues(int inputId) {
        ArrayList<Value> toRemove = new ArrayList<Value>();
        Iterator<Value> valueIterator = this.getValueIterator();
        while (valueIterator.hasNext()) {
            Object value = valueIterator.next();
            if (!this.isAssociated(value, inputId)) continue;
            toRemove.add(value);
        }
        for (Object value : toRemove) {
            this.removeValue(inputId, (Value)value);
        }
    }

    @Override
    public boolean removeValue(int inputId, Value value) {
        Object input = this.myInputIdMapping.get(value);
        if (input == null) {
            return false;
        }
        if (input instanceof TIntHashSet) {
            TIntHashSet idSet = (TIntHashSet)input;
            boolean reallyRemoved = idSet.remove(inputId);
            if (reallyRemoved) {
                idSet.compact();
            }
            if (!idSet.isEmpty()) {
                return reallyRemoved;
            }
        } else if (input instanceof Integer && (Integer)input != inputId) {
            return false;
        }
        this.myInputIdMapping.remove(value);
        return true;
    }

    @Override
    public Iterator<Value> getValueIterator() {
        return Collections.unmodifiableSet(this.myInputIdMapping.keySet()).iterator();
    }

    @Override
    public List<Value> toValueList() {
        if (this.myInputIdMapping.isEmpty()) {
            return Collections.emptyList();
        }
        return new ArrayList<Value>(this.myInputIdMapping.keySet());
    }

    @Override
    public int[] getInputIds(Value value) {
        Object input = this.myInputIdMapping.get(value);
        int[] idSet = input instanceof TIntHashSet ? ((TIntHashSet)input).toArray() : (input instanceof Integer ? new int[]{(Integer)input} : ArrayUtil.EMPTY_INT_ARRAY);
        return idSet;
    }

    @Override
    public boolean isAssociated(Value value, int inputId) {
        Object input = this.myInputIdMapping.get(value);
        if (input instanceof TIntHashSet) {
            return ((TIntHashSet)input).contains(inputId);
        }
        if (input instanceof Integer) {
            return inputId == (Integer)input;
        }
        return false;
    }

    @Override
    public ValueContainer.IntIterator getInputIdsIterator(Value value) {
        Object input = this.myInputIdMapping.get(value);
        ValueContainer.IntIterator it = input instanceof TIntHashSet ? new IntSetIterator((TIntHashSet)input) : (input instanceof Integer ? new SingleValueIterator((Integer)input) : EMPTY_ITERATOR);
        return it;
    }

    public ValueContainerImpl<Value> clone() {
        try {
            ValueContainerImpl clone = (ValueContainerImpl)super.clone();
            clone.myInputIdMapping = this.mapCopy(this.myInputIdMapping);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    private HashMap<Value, Object> mapCopy(HashMap<Value, Object> map) {
        if (map == null) {
            return null;
        }
        HashMap cloned = (HashMap)map.clone();
        for (Object key : cloned.keySet()) {
            Object val = cloned.get(key);
            if (!(val instanceof TIntHashSet)) continue;
            cloned.put(key, ((TIntHashSet)val).clone());
        }
        return cloned;
    }

    private static class IdSet
    extends TIntHashSet {
        private IdSet(int initialCapacity, float loadFactor) {
            super(initialCapacity, loadFactor);
        }

        public void compact() {
            if ((int)((float)this.capacity() * this._loadFactor) / Math.max(1, this.size()) >= 3) {
                super.compact();
            }
        }
    }

    private static class IntSetIterator
    implements ValueContainer.IntIterator {
        private final TIntIterator mySetIterator;
        private final int mySize;

        public IntSetIterator(TIntHashSet set) {
            this.mySetIterator = set.iterator();
            this.mySize = set.size();
        }

        @Override
        public boolean hasNext() {
            return this.mySetIterator.hasNext();
        }

        @Override
        public int next() {
            return this.mySetIterator.next();
        }

        @Override
        public int size() {
            return this.mySize;
        }
    }

    private static class SingleValueIterator
    implements ValueContainer.IntIterator {
        private final int myValue;
        private boolean myValueRead = false;

        private SingleValueIterator(int value) {
            this.myValue = value;
        }

        @Override
        public boolean hasNext() {
            return !this.myValueRead;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int next() {
            try {
                int n = this.myValue;
                return n;
            }
            finally {
                this.myValueRead = true;
            }
        }

        @Override
        public int size() {
            return 1;
        }
    }
}

