/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.io.MappedBufferWrapper;
import com.intellij.util.io.RandomAccessDataInput;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ByteBufferRADataInput
implements RandomAccessDataInput {
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.util.io.ByteBufferRADataInput");
    private final MappedBufferWrapper myBuffer;

    public ByteBufferRADataInput(MappedBufferWrapper buffer) {
        this.myBuffer = buffer;
    }

    public void setPosition(int pos) {
        this.getBuffer().position(pos);
    }

    public int getPosition() {
        return this.getBuffer().position();
    }

    public void readFully(byte[] b) throws IOException {
        this.getBuffer().get(b);
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        this.getBuffer().get(b, off, len);
    }

    public int skipBytes(int n) throws IOException {
        int newPos = this.getPosition() + n;
        this.setPosition(newPos);
        return newPos;
    }

    public boolean readBoolean() throws IOException {
        return this.getBuffer().get() == 1;
    }

    public byte readByte() throws IOException {
        return this.getBuffer().get();
    }

    public int readUnsignedByte() throws IOException {
        return 0xFF & this.getBuffer().get();
    }

    public short readShort() throws IOException {
        return this.getBuffer().getShort();
    }

    public int readUnsignedShort() throws IOException {
        return 0xFFFF & this.getBuffer().getShort();
    }

    public char readChar() throws IOException {
        return this.getBuffer().getChar();
    }

    public int readInt() throws IOException {
        return this.getBuffer().getInt();
    }

    public long readLong() throws IOException {
        return this.getBuffer().getLong();
    }

    public float readFloat() throws IOException {
        return this.getBuffer().getFloat();
    }

    public double readDouble() throws IOException {
        return this.getBuffer().getDouble();
    }

    public String readLine() throws IOException {
        LOG.error("Not implemented");
        return null;
    }

    public String readUTF() throws IOException {
        return DataInputStream.readUTF((DataInput)((Object)this));
    }

    public ByteBuffer getBuffer() {
        return this.myBuffer.buf();
    }
}

