/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.ReflectionCache;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.xml.Attribute;
import com.intellij.util.xml.CustomChildren;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomNameStrategy;
import com.intellij.util.xml.DomReflectionUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.JavaMethod;
import com.intellij.util.xml.JavaMethodSignature;
import com.intellij.util.xml.NameValue;
import com.intellij.util.xml.PropertyAccessor;
import com.intellij.util.xml.SubTag;
import com.intellij.util.xml.SubTagList;
import com.intellij.util.xml.SubTagsList;
import com.intellij.util.xml.XmlName;
import com.intellij.util.xml.impl.AttributeChildDescriptionImpl;
import com.intellij.util.xml.impl.CollectionChildDescriptionImpl;
import com.intellij.util.xml.impl.DomImplUtil;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.util.xml.impl.FixedChildDescriptionImpl;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TIntObjectHashMap;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StaticGenericInfoBuilder {
    private static final Set ADDER_PARAMETER_TYPES = new THashSet(Arrays.asList(Class.class, Integer.TYPE));
    private final Class myClass;
    private final Type myType;
    private final MultiValuesMap<XmlName, JavaMethod> myCollectionGetters = new MultiValuesMap();
    private final MultiValuesMap<XmlName, JavaMethod> myCollectionAdders = new MultiValuesMap();
    private final MultiValuesMap<XmlName, JavaMethod> myCollectionClassAdders = new MultiValuesMap();
    private final MultiValuesMap<XmlName, JavaMethod> myCollectionIndexAdders = new MultiValuesMap();
    private final MultiValuesMap<XmlName, JavaMethod> myCollectionIndexClassAdders = new MultiValuesMap();
    private final MultiValuesMap<XmlName, JavaMethod> myCollectionClassIndexAdders = new MultiValuesMap();
    private final Map<XmlName, Type> myCollectionChildrenTypes = new THashMap();
    private final Map<JavaMethodSignature, String[]> myCompositeCollectionGetters = new THashMap();
    private final Map<JavaMethodSignature, Pair<String, String[]>> myCompositeCollectionAdders = new THashMap();
    private final FactoryMap<XmlName, TIntObjectHashMap<Collection<JavaMethod>>> myFixedChildrenGetters = new FactoryMap<XmlName, TIntObjectHashMap<Collection<JavaMethod>>>(){

        protected TIntObjectHashMap<Collection<JavaMethod>> create(XmlName key) {
            return new TIntObjectHashMap();
        }
    };
    private final Map<JavaMethodSignature, AttributeChildDescriptionImpl> myAttributes = new THashMap();
    private boolean myValueElement;
    private JavaMethod myNameValueGetter;
    private JavaMethod myCustomChildrenGetter;

    public StaticGenericInfoBuilder(DomManagerImpl domManager, Class aClass, Type type) {
        Class<? extends DomElement> implClass;
        this.myClass = aClass;
        this.myType = type;
        THashSet methods = new THashSet();
        for (Method method : ReflectionCache.getMethods((Class)this.myClass)) {
            methods.add(JavaMethod.getMethod((Class)this.myClass, (Method)method));
        }
        for (JavaMethod method : methods) {
            if (!DomImplUtil.isGetter(method) || method.getAnnotation(NameValue.class) == null) continue;
            this.myNameValueGetter = method;
            break;
        }
        if ((implClass = domManager.getImplementation(this.myClass)) != null) {
            for (Method method : ReflectionCache.getMethods(implClass)) {
                JavaMethodSignature signature;
                int modifiers = method.getModifiers();
                if (Modifier.isAbstract(modifiers) || Modifier.isVolatile(modifiers) || (signature = JavaMethodSignature.getSignature((Method)method)).findMethod(this.myClass) == null) continue;
                methods.remove(JavaMethod.getMethod((Class)this.myClass, (JavaMethodSignature)signature));
            }
        }
        Iterator iterator = methods.iterator();
        while (iterator.hasNext()) {
            JavaMethod method = (JavaMethod)iterator.next();
            if (!StaticGenericInfoBuilder.isCoreMethod(method) && !DomImplUtil.isTagValueSetter(method) && method.getAnnotation(PropertyAccessor.class) == null) continue;
            iterator.remove();
        }
        iterator = methods.iterator();
        while (iterator.hasNext()) {
            JavaMethod method = (JavaMethod)iterator.next();
            if (!DomImplUtil.isGetter(method) || !this.processGetterMethod(method)) continue;
            iterator.remove();
        }
        iterator = methods.iterator();
        while (iterator.hasNext()) {
            MultiValuesMap<XmlName, JavaMethod> adders;
            XmlName xmlName;
            JavaMethod method = (JavaMethod)iterator.next();
            SubTagsList subTagsList = (SubTagsList)method.getAnnotation(SubTagsList.class);
            if (subTagsList != null && method.getName().startsWith("add")) {
                String localName = subTagsList.tagName();
                assert (StringUtil.isNotEmpty((String)localName));
                String[] set = subTagsList.value();
                assert (Arrays.asList(set).contains(localName));
                this.myCompositeCollectionAdders.put(method.getSignature(), (Pair<String, String[]>)Pair.create((Object)localName, (Object)set));
                iterator.remove();
                continue;
            }
            if (!this.isAddMethod(method) || !this.myCollectionGetters.containsKey((Object)(xmlName = this.extractTagName(method, "add"))) || (adders = this.getAddersMap(method)) == null) continue;
            adders.put((Object)xmlName, (Object)method);
            iterator.remove();
        }
    }

    @Nullable
    private MultiValuesMap<XmlName, JavaMethod> getAddersMap(JavaMethod method) {
        Class[] parameterTypes = method.getParameterTypes();
        switch (parameterTypes.length) {
            case 0: {
                return this.myCollectionAdders;
            }
            case 1: {
                if (Class.class.equals((Object)parameterTypes[0])) {
                    return this.myCollectionClassAdders;
                }
                if (!StaticGenericInfoBuilder.isInt(parameterTypes[0])) break;
                return this.myCollectionIndexAdders;
            }
            case 2: {
                if (StaticGenericInfoBuilder.isIndexClassAdder(parameterTypes[0], parameterTypes[1])) {
                    return this.myCollectionIndexClassAdders;
                }
                if (!StaticGenericInfoBuilder.isIndexClassAdder(parameterTypes[1], parameterTypes[0])) break;
                return this.myCollectionClassIndexAdders;
            }
        }
        return null;
    }

    private static boolean isIndexClassAdder(Class<?> first, Class<?> second) {
        return StaticGenericInfoBuilder.isInt(first) && second.equals(Class.class);
    }

    private static boolean isInt(Class<?> aClass) {
        return aClass.equals(Integer.TYPE) || aClass.equals(Integer.class);
    }

    private static Set<XmlName> getXmlNames(SubTagsList subTagsList) {
        return ContainerUtil.map2Set((Object[])subTagsList.value(), (Function)new Function<String, XmlName>(){

            public XmlName fun(String s) {
                return new XmlName(s);
            }
        });
    }

    private boolean isAddMethod(JavaMethod method) {
        XmlName tagName = this.extractTagName(method, "add");
        if (tagName == null) {
            return false;
        }
        Type type = this.myCollectionChildrenTypes.get(tagName);
        if (type == null || !ReflectionUtil.getRawType((Type)type).isAssignableFrom(method.getReturnType())) {
            return false;
        }
        return ADDER_PARAMETER_TYPES.containsAll(Arrays.asList(method.getParameterTypes()));
    }

    @Nullable
    private XmlName extractTagName(JavaMethod method, @NonNls String prefix) {
        String name = method.getName();
        if (!name.startsWith(prefix)) {
            return null;
        }
        SubTagList subTagAnnotation = (SubTagList)method.getAnnotation(SubTagList.class);
        if (subTagAnnotation != null && !StringUtil.isEmpty((String)subTagAnnotation.value())) {
            return DomImplUtil.createXmlName(subTagAnnotation.value(), method);
        }
        String tagName = this.getNameStrategy(false).convertName(name.substring(prefix.length()));
        return StringUtil.isEmpty((String)tagName) ? null : DomImplUtil.createXmlName(tagName, method);
    }

    private static boolean isDomElement(Type type) {
        return type != null && DomElement.class.isAssignableFrom(ReflectionUtil.getRawType((Type)type));
    }

    private boolean processGetterMethod(JavaMethod method) {
        String qname;
        boolean isAttributeMethod;
        if (DomImplUtil.isTagValueGetter(method)) {
            this.myValueElement = true;
            return true;
        }
        Class returnType = method.getReturnType();
        boolean isAttributeValueMethod = GenericAttributeValue.class.isAssignableFrom(returnType);
        JavaMethodSignature signature = method.getSignature();
        Attribute annotation = (Attribute)signature.findAnnotation(Attribute.class, this.myClass);
        boolean bl = isAttributeMethod = annotation != null || isAttributeValueMethod;
        if (annotation != null) assert (isAttributeValueMethod || GenericAttributeValue.class.isAssignableFrom(returnType)) : method + " should return GenericAttributeValue";
        if (isAttributeMethod) {
            String attributeName;
            String s = annotation == null ? null : annotation.value();
            String string = attributeName = StringUtil.isEmpty((String)s) ? this.getNameFromMethod(signature, true) : s;
            assert (attributeName != null && StringUtil.isNotEmpty((String)attributeName)) : "Can't guess attribute name from method name: " + method.getName();
            XmlName attrName = DomImplUtil.createXmlName(attributeName, method);
            this.myAttributes.put(signature, new AttributeChildDescriptionImpl(attrName, method));
            return true;
        }
        if (StaticGenericInfoBuilder.isDomElement(returnType) && (qname = this.getSubTagName(signature)) != null) {
            TIntObjectHashMap map;
            Collection methods;
            XmlName xmlName = DomImplUtil.createXmlName(qname, method);
            assert (!this.myCollectionChildrenTypes.containsKey(xmlName)) : "Collection and fixed children cannot intersect: " + qname;
            int index = 0;
            SubTag subTagAnnotation = (SubTag)signature.findAnnotation(SubTag.class, this.myClass);
            if (subTagAnnotation != null && subTagAnnotation.index() != 0) {
                index = subTagAnnotation.index();
            }
            if ((methods = (Collection)(map = (TIntObjectHashMap)this.myFixedChildrenGetters.get((Object)xmlName)).get(index)) == null) {
                methods = new SmartList();
                map.put(index, (Object)methods);
            }
            methods.add(method);
            return true;
        }
        Type type = DomReflectionUtil.extractCollectionElementType((Type)method.getGenericReturnType());
        if (StaticGenericInfoBuilder.isDomElement(type)) {
            CustomChildren customChildren = (CustomChildren)method.getAnnotation(CustomChildren.class);
            if (customChildren != null) {
                this.myCustomChildrenGetter = method;
                return true;
            }
            SubTagsList subTagsList = (SubTagsList)method.getAnnotation(SubTagsList.class);
            if (subTagsList != null) {
                this.myCompositeCollectionGetters.put(signature, subTagsList.value());
                return true;
            }
            String qname2 = this.getSubTagNameForCollection(signature);
            if (qname2 != null) {
                XmlName xmlName = DomImplUtil.createXmlName(qname2, type, method);
                assert (!this.myFixedChildrenGetters.containsKey((Object)xmlName)) : "Collection and fixed children cannot intersect: " + qname2;
                this.myCollectionChildrenTypes.put(xmlName, type);
                this.myCollectionGetters.put((Object)xmlName, (Object)method);
                return true;
            }
        }
        return false;
    }

    private static boolean isCoreMethod(JavaMethod method) {
        if (method.getSignature().findMethod(DomElement.class) != null) {
            return true;
        }
        Class aClass = method.getDeclaringClass();
        return aClass.equals(GenericAttributeValue.class) || aClass.equals(GenericDomValue.class) && "getConverter".equals(method.getName());
    }

    @Nullable
    private String getSubTagName(JavaMethodSignature method) {
        SubTag subTagAnnotation = (SubTag)method.findAnnotation(SubTag.class, this.myClass);
        if (subTagAnnotation == null || StringUtil.isEmpty((String)subTagAnnotation.value())) {
            return this.getNameFromMethod(method, false);
        }
        return subTagAnnotation.value();
    }

    @Nullable
    private String getSubTagNameForCollection(JavaMethodSignature method) {
        SubTagList subTagList = (SubTagList)method.findAnnotation(SubTagList.class, this.myClass);
        if (subTagList == null || StringUtil.isEmpty((String)subTagList.value())) {
            String propertyName = StaticGenericInfoBuilder.getPropertyName(method);
            if (propertyName != null) {
                String singular = StringUtil.unpluralize((String)propertyName);
                assert (singular != null) : "Can't unpluralize: " + propertyName;
                return this.getNameStrategy(false).convertName(singular);
            }
            return null;
        }
        return subTagList.value();
    }

    @Nullable
    private String getNameFromMethod(JavaMethodSignature method, boolean isAttribute) {
        String propertyName = StaticGenericInfoBuilder.getPropertyName(method);
        return propertyName == null ? null : this.getNameStrategy(isAttribute).convertName(propertyName);
    }

    @Nullable
    private static String getPropertyName(JavaMethodSignature method) {
        return StringUtil.getPropertyName((String)method.getMethodName());
    }

    @NotNull
    private DomNameStrategy getNameStrategy(boolean isAttribute) {
        DomNameStrategy strategy = DomImplUtil.getDomNameStrategy(ReflectionUtil.getRawType((Type)this.myClass), isAttribute);
        DomNameStrategy domNameStrategy = strategy != null ? strategy : DomNameStrategy.HYPHEN_STRATEGY;
        if (domNameStrategy == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/impl/StaticGenericInfoBuilder.getNameStrategy must not return null");
        }
        return domNameStrategy;
    }

    final JavaMethod getCustomChildrenGetter() {
        return this.myCustomChildrenGetter;
    }

    final Map<JavaMethodSignature, AttributeChildDescriptionImpl> getAttributes() {
        return this.myAttributes;
    }

    final Map<JavaMethodSignature, Pair<FixedChildDescriptionImpl, Integer>> getFixedGetters() {
        THashMap map = new THashMap();
        Set names = this.myFixedChildrenGetters.keySet();
        for (XmlName name : names) {
            int[] ints;
            TIntObjectHashMap map1 = (TIntObjectHashMap)this.myFixedChildrenGetters.get((Object)name);
            int max = 0;
            for (int i : ints = map1.keys()) {
                max = Math.max(max, i);
            }
            int count = max + 1;
            Collection[] getters = new Collection[count];
            for (int i : ints) {
                getters[i] = (Collection)map1.get(i);
            }
            FixedChildDescriptionImpl description = new FixedChildDescriptionImpl(name, ((JavaMethod)((Collection)map1.get(0)).iterator().next()).getGenericReturnType(), count, getters);
            for (int i = 0; i < getters.length; ++i) {
                Collection collection = getters[i];
                for (JavaMethod method : collection) {
                    map.put(method.getSignature(), Pair.create((Object)description, (Object)i));
                }
            }
        }
        return map;
    }

    final Map<JavaMethodSignature, CollectionChildDescriptionImpl> getCollectionGetters() {
        THashMap getters = new THashMap();
        for (XmlName xmlName : this.myCollectionGetters.keySet()) {
            Collection collGetters = this.myCollectionGetters.get((Object)xmlName);
            JavaMethod method = (JavaMethod)collGetters.iterator().next();
            CollectionChildDescriptionImpl description = new CollectionChildDescriptionImpl(xmlName, DomReflectionUtil.extractCollectionElementType((Type)method.getGenericReturnType()), this.myCollectionAdders.get((Object)xmlName), this.myCollectionClassAdders.get((Object)xmlName), collGetters, this.myCollectionIndexAdders.get((Object)xmlName), this.myCollectionIndexClassAdders.get((Object)xmlName), this.myCollectionClassIndexAdders.get((Object)xmlName));
            for (JavaMethod getter : collGetters) {
                getters.put(getter.getSignature(), description);
            }
        }
        return getters;
    }

    final Map<JavaMethodSignature, Pair<String, String[]>> getCompositeCollectionAdders() {
        return this.myCompositeCollectionAdders;
    }

    final Map<JavaMethodSignature, String[]> getCompositeCollectionGetters() {
        return this.myCompositeCollectionGetters;
    }

    public JavaMethod getNameValueGetter() {
        return this.myNameValueGetter;
    }

    public boolean isValueElement() {
        return this.myValueElement;
    }
}

