/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.actions;

import com.intellij.execution.actions.ChooseDebugConfigurationAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.AbstractDebuggerSession;
import com.intellij.xdebugger.impl.DebuggerSupport;
import com.intellij.xdebugger.impl.actions.DebuggerActionHandler;
import com.intellij.xdebugger.impl.actions.XDebuggerActionBase;
import org.jetbrains.annotations.NotNull;

public class ResumeAction
extends XDebuggerActionBase {
    @Override
    protected boolean isEnabled(AnActionEvent e) {
        Project project = (Project)e.getData(PlatformDataKeys.PROJECT);
        if (project == null) {
            return false;
        }
        boolean haveCurrentSession = false;
        for (DebuggerSupport support : DebuggerSupport.getDebuggerSupports()) {
            AbstractDebuggerSession session = support.getCurrentSession(project);
            if (session == null || session.isStopped()) continue;
            haveCurrentSession = true;
            if (!session.isPaused()) continue;
            return true;
        }
        return !"DebuggerToolbar".equals(e.getPlace()) && !haveCurrentSession;
    }

    @Override
    public void actionPerformed(AnActionEvent e) {
        if (!this.performWithHandler(e)) {
            new ChooseDebugConfigurationAction().actionPerformed(e);
        }
    }

    @Override
    @NotNull
    protected DebuggerActionHandler getHandler(@NotNull DebuggerSupport debuggerSupport) {
        if (debuggerSupport == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/actions/ResumeAction.getHandler must not be null");
        }
        DebuggerActionHandler debuggerActionHandler = debuggerSupport.getResumeActionHandler();
        if (debuggerActionHandler == null) {
            throw new IllegalStateException("@NotNull method com/intellij/xdebugger/impl/actions/ResumeAction.getHandler must not return null");
        }
        return debuggerActionHandler;
    }
}

