/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints.ui.actions;

import com.intellij.pom.Navigatable;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.impl.breakpoints.ui.XBreakpointPanelAction;
import com.intellij.xdebugger.impl.breakpoints.ui.XBreakpointsPanel;
import java.util.Collection;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class GoToBreakpointAction<B extends XBreakpoint<?>>
extends XBreakpointPanelAction<B> {
    private final boolean myCloseDialog;

    public GoToBreakpointAction(@NotNull XBreakpointsPanel<B> panel, String name, boolean closeDialog) {
        if (panel == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/breakpoints/ui/actions/GoToBreakpointAction.<init> must not be null");
        }
        super(panel, name);
        this.myCloseDialog = closeDialog;
    }

    @Override
    public boolean isEnabled(@NotNull Collection<? extends B> breakpoints) {
        if (breakpoints == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/breakpoints/ui/actions/GoToBreakpointAction.isEnabled must not be null");
        }
        if (breakpoints.size() != 1) {
            return false;
        }
        XBreakpoint b = (XBreakpoint)breakpoints.iterator().next();
        Navigatable navigatable = b.getNavigatable();
        return navigatable != null && navigatable.canNavigateToSource();
    }

    @Override
    public void perform(@NotNull Collection<? extends B> breakpoints, JComponent parentComponent) {
        if (breakpoints == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/breakpoints/ui/actions/GoToBreakpointAction.perform must not be null");
        }
        XBreakpoint b = (XBreakpoint)breakpoints.iterator().next();
        Navigatable navigatable = b.getNavigatable();
        if (navigatable != null) {
            navigatable.navigate(true);
        }
        if (this.myCloseDialog) {
            this.myBreakpointsPanel.getParentDialog().close(0);
        }
    }
}

