/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui;

import com.intellij.diagnostic.logging.AdditionalTabComponent;
import com.intellij.diagnostic.logging.DebuggerLogConsoleManager;
import com.intellij.diagnostic.logging.DefaultLogFilterModel;
import com.intellij.diagnostic.logging.LogConsole;
import com.intellij.diagnostic.logging.LogConsoleBase;
import com.intellij.diagnostic.logging.LogConsoleImpl;
import com.intellij.diagnostic.logging.LogFilesManager;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithActions;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Ref;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import java.io.File;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DebuggerLogConsoleManagerBase
implements DebuggerLogConsoleManager,
Disposable {
    private final Map<AdditionalTabComponent, Content> myAdditionalContent = new HashMap<AdditionalTabComponent, Content>();
    private final Map<AdditionalTabComponent, ContentManagerListener> myContentListeners = new HashMap<AdditionalTabComponent, ContentManagerListener>();
    private final Project myProject;
    private final LogFilesManager myManager;
    protected ExecutionEnvironment myEnvironment;
    private final Icon DEFAULT_TAB_COMPONENT_ICON = IconLoader.getIcon((String)"/fileTypes/text.png");

    public DebuggerLogConsoleManagerBase(Project project) {
        this.myProject = project;
        this.myManager = new LogFilesManager(project, this, this);
    }

    public abstract RunContentDescriptor getRunContentDescriptor();

    public abstract RunnerLayoutUi getUi();

    protected void registerFileMatcher(RunProfile runConfiguration) {
        if (runConfiguration instanceof RunConfigurationBase) {
            this.myManager.registerFileMatcher((RunConfigurationBase)runConfiguration);
        }
    }

    protected void initLogConsoles(RunProfile runConfiguration, ProcessHandler processHandler) {
        if (runConfiguration instanceof RunConfigurationBase && ((RunConfigurationBase)runConfiguration).needAdditionalConsole()) {
            this.myManager.initLogConsoles((RunConfigurationBase)runConfiguration, processHandler);
        }
    }

    public void setEnvironment(@NotNull ExecutionEnvironment env) {
        if (env == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/ui/DebuggerLogConsoleManagerBase.setEnvironment must not be null");
        }
        this.myEnvironment = env;
    }

    @NotNull
    public LogConsoleBase addLogConsole(String name, Reader reader, long skippedContent, Icon icon) {
        final Ref content = new Ref();
        LogConsoleBase console = new LogConsoleBase(this.myProject, reader, skippedContent, name, false, new DefaultLogFilterModel(this.myProject)){

            @Override
            public boolean isActive() {
                Content logContent = (Content)content.get();
                return logContent != null && logContent.isSelected();
            }
        };
        this.addLogConsole(console, icon, (Ref<Content>)content);
        LogConsoleBase logConsoleBase = console;
        if (logConsoleBase == null) {
            throw new IllegalStateException("@NotNull method com/intellij/xdebugger/impl/ui/DebuggerLogConsoleManagerBase.addLogConsole must not return null");
        }
        return logConsoleBase;
    }

    public void addLogConsole(String name, String path, long skippedContent, Icon icon) {
        final Ref content = new Ref();
        this.addLogConsole(new LogConsoleImpl(this.myProject, new File(path), skippedContent, name, false){

            @Override
            public boolean isActive() {
                Content logContent = (Content)content.get();
                return logContent != null && logContent.isSelected();
            }
        }, icon, (Ref<Content>)content);
    }

    private void addLogConsole(final LogConsoleBase logConsole, Icon icon, Ref<Content> content) {
        logConsole.attachStopLogConsoleTrackingListener(this.getRunContentDescriptor().getProcessHandler());
        if (this.myEnvironment != null && this.myEnvironment.getRunProfile() instanceof RunConfigurationBase) {
            ((RunConfigurationBase)this.myEnvironment.getRunProfile()).customizeLogConsole((LogConsole)logConsole);
        }
        content.set((Object)this.addLogComponent((AdditionalTabComponent)logConsole, icon));
        ContentManagerAdapter l = new ContentManagerAdapter(){

            public void selectionChanged(ContentManagerEvent event) {
                logConsole.activate();
            }
        };
        this.myContentListeners.put(logConsole, (ContentManagerListener)l);
        this.getUi().addListener((ContentManagerListener)l, (Disposable)this);
    }

    @Override
    public void addLogConsole(String name, String path, long skippedContent) {
        this.addLogConsole(name, path, skippedContent, this.DEFAULT_TAB_COMPONENT_ICON);
    }

    @Nullable
    public static String getLogContentId(@NotNull String tabTitle) {
        if (tabTitle == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/ui/DebuggerLogConsoleManagerBase.getLogContentId must not be null");
        }
        return "Log-" + tabTitle;
    }

    @Override
    public void removeLogConsole(String path) {
        LogConsoleImpl componentToRemove = null;
        for (AdditionalTabComponent tabComponent : this.myAdditionalContent.keySet()) {
            LogConsoleImpl console;
            if (!(tabComponent instanceof LogConsoleImpl) || !Comparing.strEqual((String)(console = (LogConsoleImpl)tabComponent).getPath(), (String)path)) continue;
            componentToRemove = console;
            break;
        }
        if (componentToRemove != null) {
            this.getUi().removeListener(this.myContentListeners.remove((Object)componentToRemove));
            this.removeAdditionalTabComponent(componentToRemove);
        }
    }

    public void addAdditionalTabComponent(AdditionalTabComponent tabComponent, String id, Icon icon) {
        this.addLogComponent(tabComponent, id, icon);
    }

    public void addAdditionalTabComponent(AdditionalTabComponent tabComponent, String id) {
        this.addLogComponent(tabComponent, id);
    }

    private void addLogComponent(AdditionalTabComponent component, String id) {
        this.addLogComponent(component, id, this.DEFAULT_TAB_COMPONENT_ICON);
    }

    private Content addLogComponent(AdditionalTabComponent tabComponent, Icon icon) {
        String id = DebuggerLogConsoleManagerBase.getLogContentId(tabComponent.getTabTitle());
        return this.addLogComponent(tabComponent, id, icon);
    }

    private Content addLogComponent(final AdditionalTabComponent tabComponent, String id, Icon icon) {
        Content logContent = this.getUi().createContent(id, (ComponentWithActions)tabComponent, tabComponent.getTabTitle(), icon, tabComponent.getPreferredFocusableComponent());
        logContent.setCloseable(false);
        logContent.setDescription(tabComponent.getTooltip());
        this.myAdditionalContent.put(tabComponent, logContent);
        this.getUi().addContent(logContent);
        Disposer.register((Disposable)this, (Disposable)new Disposable(){

            public void dispose() {
                DebuggerLogConsoleManagerBase.this.removeAdditionalTabComponent(tabComponent);
            }
        });
        return logContent;
    }

    public void removeAdditionalTabComponent(AdditionalTabComponent component) {
        component.dispose();
        Content content = this.myAdditionalContent.remove(component);
        this.getUi().removeContent(content, true);
    }

    protected Project getProject() {
        return this.myProject;
    }

    public void dispose() {
    }
}

