/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.index;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class XmlIndex<V>
extends FileBasedIndexExtension<String, V> {
    protected static final EnumeratorStringDescriptor KEY_DESCRIPTOR = new EnumeratorStringDescriptor();
    private static final FileBasedIndex.InputFilter INPUT_FILTER = new FileBasedIndex.InputFilter(){

        @Override
        public boolean acceptInput(VirtualFile file) {
            String extension = file.getExtension();
            return extension != null && extension.equals("xsd");
        }
    };

    protected static GlobalSearchScope createFilter(Project project) {
        final GlobalSearchScope projectScope = GlobalSearchScope.allScope((Project)project);
        return new GlobalSearchScope(project){

            public int compare(VirtualFile file1, VirtualFile file2) {
                return projectScope.compare(file1, file2);
            }

            public boolean isSearchInModuleContent(@NotNull Module aModule) {
                if (aModule == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xml/index/XmlIndex$2.isSearchInModuleContent must not be null");
                }
                return true;
            }

            public boolean contains(VirtualFile file) {
                VirtualFile parent = file.getParent();
                assert (parent != null);
                return parent.getName().equals("standardSchemas") || projectScope.contains(file);
            }

            public boolean isSearchInLibraries() {
                return true;
            }
        };
    }

    protected static VirtualFileFilter createFilter(final @NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xml/index/XmlIndex.createFilter must not be null");
        }
        final ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)module.getProject()).getFileIndex();
        return new VirtualFileFilter(){

            public boolean accept(VirtualFile file) {
                Module moduleForFile = fileIndex.getModuleForFile(file);
                if (moduleForFile != null) {
                    return module.equals(moduleForFile);
                }
                if (fileIndex.isInLibraryClasses(file)) {
                    List orderEntries = fileIndex.getOrderEntriesForFile(file);
                    if (orderEntries.isEmpty()) {
                        return false;
                    }
                    for (OrderEntry orderEntry : orderEntries) {
                        Module ownerModule = orderEntry.getOwnerModule();
                        if (ownerModule == null || !ownerModule.equals(module)) continue;
                        return true;
                    }
                }
                VirtualFile parent = file.getParent();
                assert (parent != null);
                return parent.getName().equals("standardSchemas");
            }
        };
    }

    @Override
    public KeyDescriptor<String> getKeyDescriptor() {
        return KEY_DESCRIPTOR;
    }

    @Override
    public FileBasedIndex.InputFilter getInputFilter() {
        return INPUT_FILTER;
    }

    @Override
    public boolean dependsOnFileContent() {
        return true;
    }

    @Override
    public int getVersion() {
        return 0;
    }
}

