/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.codeInsight.lookup.DeferredUserLookupValue;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.codeInsight.lookup.LookupValueWithPriority;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlToken;
import com.intellij.ui.ColorChooser;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.util.ColorSampleLookupValue;
import java.awt.Color;
import java.awt.Component;

public class UserColorLookup
implements DeferredUserLookupValue,
LookupValueWithPriority {
    private static final String COLOR_STRING = XmlBundle.message((String)"choose.color.in.color.lookup", (Object[])new Object[0]);

    @Override
    public String getPresentation() {
        return COLOR_STRING;
    }

    public boolean handleUserSelection(LookupItem item, Project project) {
        Color color;
        Color myColorAtCaret = null;
        Editor selectedTextEditor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
        PsiElement element = PsiDocumentManager.getInstance((Project)project).getPsiFile(selectedTextEditor.getDocument()).findElementAt(selectedTextEditor.getCaretModel().getOffset());
        if (element instanceof XmlToken) {
            myColorAtCaret = UserColorLookup.getColorFromElement(element);
        }
        if ((color = ColorChooser.chooseColor((Component)WindowManager.getInstance().suggestParentWindow(project), (String)XmlBundle.message((String)"choose.color.dialog.title", (Object[])new Object[0]), (Color)myColorAtCaret)) != null) {
            String s = Integer.toHexString(color.getRGB() & 0xFFFFFF);
            if (s.length() != 6) {
                StringBuffer buf = new StringBuffer(s);
                for (int i = 6 - buf.length(); i > 0; --i) {
                    buf.insert(0, '0');
                }
                s = buf.toString();
            }
            item.setLookupString("#" + s);
        }
        return color != null;
    }

    public static Color getColorFromElement(PsiElement element) {
        Color myColorAtCaret = null;
        if (!(element instanceof XmlToken)) {
            return null;
        }
        String text = element.getText();
        if (text.length() > 0 && text.charAt(0) == '#') {
            myColorAtCaret = UserColorLookup.decodeColor(text);
        } else {
            String hexCodeForColorName = ColorSampleLookupValue.getHexCodeForColorName(text);
            if (hexCodeForColorName != null) {
                myColorAtCaret = UserColorLookup.decodeColor(hexCodeForColorName);
            }
        }
        return myColorAtCaret;
    }

    private static Color decodeColor(String text) {
        Color myColorAtCaret = null;
        try {
            String s = text.substring(1);
            if (s.length() == 3) {
                StringBuilder buf = new StringBuilder(6);
                buf.append(s.charAt(0)).append(s.charAt(0));
                buf.append(s.charAt(1)).append(s.charAt(1));
                buf.append(s.charAt(2)).append(s.charAt(2));
                s = buf.toString();
            }
            myColorAtCaret = Color.decode("0x" + s);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return myColorAtCaret;
    }

    @Override
    public int getPriority() {
        return 2;
    }
}

