/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp;

import com.intellij.extapi.psi.ASTWrapperPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import org.intellij.lang.regexp.RegExpElementTypes;
import org.intellij.lang.regexp.RegExpFile;
import org.intellij.lang.regexp.RegExpLanguage;
import org.intellij.lang.regexp.RegExpLexer;
import org.intellij.lang.regexp.RegExpParser;
import org.intellij.lang.regexp.RegExpTT;
import org.intellij.lang.regexp.psi.impl.RegExpBackrefImpl;
import org.intellij.lang.regexp.psi.impl.RegExpBoundaryImpl;
import org.intellij.lang.regexp.psi.impl.RegExpBranchImpl;
import org.intellij.lang.regexp.psi.impl.RegExpCharImpl;
import org.intellij.lang.regexp.psi.impl.RegExpCharRangeImpl;
import org.intellij.lang.regexp.psi.impl.RegExpClassImpl;
import org.intellij.lang.regexp.psi.impl.RegExpClosureImpl;
import org.intellij.lang.regexp.psi.impl.RegExpGroupImpl;
import org.intellij.lang.regexp.psi.impl.RegExpIntersectionImpl;
import org.intellij.lang.regexp.psi.impl.RegExpOptionsImpl;
import org.intellij.lang.regexp.psi.impl.RegExpPatternImpl;
import org.intellij.lang.regexp.psi.impl.RegExpPropertyImpl;
import org.intellij.lang.regexp.psi.impl.RegExpPyCondRefImpl;
import org.intellij.lang.regexp.psi.impl.RegExpPyNamedGroupRefImpl;
import org.intellij.lang.regexp.psi.impl.RegExpQuantifierImpl;
import org.intellij.lang.regexp.psi.impl.RegExpSetOptionsImpl;
import org.intellij.lang.regexp.psi.impl.RegExpSimpleClassImpl;
import org.jetbrains.annotations.NotNull;

public class RegExpParserDefinition
implements ParserDefinition {
    private static final TokenSet COMMENT_TOKENS = TokenSet.create((IElementType[])new IElementType[]{RegExpTT.COMMENT});

    @NotNull
    public Lexer createLexer(Project project) {
        RegExpLexer regExpLexer = new RegExpLexer(false, false);
        if (regExpLexer == null) {
            throw new IllegalStateException("@NotNull method org/intellij/lang/regexp/RegExpParserDefinition.createLexer must not return null");
        }
        return regExpLexer;
    }

    public PsiParser createParser(Project project) {
        return new RegExpParser();
    }

    public IFileElementType getFileNodeType() {
        return RegExpElementTypes.REGEXP_FILE;
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        TokenSet tokenSet = TokenSet.create((IElementType[])new IElementType[]{RegExpTT.QUOTE_BEGIN, RegExpTT.QUOTE_END, TokenType.WHITE_SPACE});
        if (tokenSet == null) {
            throw new IllegalStateException("@NotNull method org/intellij/lang/regexp/RegExpParserDefinition.getWhitespaceTokens must not return null");
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        TokenSet tokenSet = TokenSet.EMPTY;
        if (tokenSet == null) {
            throw new IllegalStateException("@NotNull method org/intellij/lang/regexp/RegExpParserDefinition.getStringLiteralElements must not return null");
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        TokenSet tokenSet = COMMENT_TOKENS;
        if (tokenSet == null) {
            throw new IllegalStateException("@NotNull method org/intellij/lang/regexp/RegExpParserDefinition.getCommentTokens must not return null");
        }
        return tokenSet;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public PsiElement createElement(ASTNode node) {
        ASTWrapperPsiElement aSTWrapperPsiElement;
        IElementType type = node.getElementType();
        if (type == RegExpElementTypes.PATTERN) {
            aSTWrapperPsiElement = new RegExpPatternImpl(node);
            if (aSTWrapperPsiElement == null) throw new IllegalStateException("@NotNull method org/intellij/lang/regexp/RegExpParserDefinition.createElement must not return null");
            return aSTWrapperPsiElement;
        }
        if (type == RegExpElementTypes.BRANCH) {
            aSTWrapperPsiElement = new RegExpBranchImpl(node);
            if (aSTWrapperPsiElement == null) throw new IllegalStateException("@NotNull method org/intellij/lang/regexp/RegExpParserDefinition.createElement must not return null");
            return aSTWrapperPsiElement;
        }
        if (type == RegExpElementTypes.SIMPLE_CLASS) {
            aSTWrapperPsiElement = new RegExpSimpleClassImpl(node);
            if (aSTWrapperPsiElement == null) throw new IllegalStateException("@NotNull method org/intellij/lang/regexp/RegExpParserDefinition.createElement must not return null");
            return aSTWrapperPsiElement;
        }
        if (type == RegExpElementTypes.CLASS) {
            aSTWrapperPsiElement = new RegExpClassImpl(node);
            if (aSTWrapperPsiElement == null) throw new IllegalStateException("@NotNull method org/intellij/lang/regexp/RegExpParserDefinition.createElement must not return null");
            return aSTWrapperPsiElement;
        }
        if (type == RegExpElementTypes.CHAR_RANGE) {
            aSTWrapperPsiElement = new RegExpCharRangeImpl(node);
            if (aSTWrapperPsiElement == null) throw new IllegalStateException("@NotNull method org/intellij/lang/regexp/RegExpParserDefinition.createElement must not return null");
            return aSTWrapperPsiElement;
        }
        if (type == RegExpElementTypes.CHAR) {
            aSTWrapperPsiElement = new RegExpCharImpl(node);
            if (aSTWrapperPsiElement == null) throw new IllegalStateException("@NotNull method org/intellij/lang/regexp/RegExpParserDefinition.createElement must not return null");
            return aSTWrapperPsiElement;
        }
        if (type == RegExpElementTypes.GROUP) {
            aSTWrapperPsiElement = new RegExpGroupImpl(node);
            if (aSTWrapperPsiElement == null) throw new IllegalStateException("@NotNull method org/intellij/lang/regexp/RegExpParserDefinition.createElement must not return null");
            return aSTWrapperPsiElement;
        }
        if (type == RegExpElementTypes.PROPERTY) {
            aSTWrapperPsiElement = new RegExpPropertyImpl(node);
            if (aSTWrapperPsiElement == null) throw new IllegalStateException("@NotNull method org/intellij/lang/regexp/RegExpParserDefinition.createElement must not return null");
            return aSTWrapperPsiElement;
        }
        if (type == RegExpElementTypes.SET_OPTIONS) {
            aSTWrapperPsiElement = new RegExpSetOptionsImpl(node);
            if (aSTWrapperPsiElement == null) throw new IllegalStateException("@NotNull method org/intellij/lang/regexp/RegExpParserDefinition.createElement must not return null");
            return aSTWrapperPsiElement;
        }
        if (type == RegExpElementTypes.OPTIONS) {
            aSTWrapperPsiElement = new RegExpOptionsImpl(node);
            if (aSTWrapperPsiElement == null) throw new IllegalStateException("@NotNull method org/intellij/lang/regexp/RegExpParserDefinition.createElement must not return null");
            return aSTWrapperPsiElement;
        }
        if (type == RegExpElementTypes.BACKREF) {
            aSTWrapperPsiElement = new RegExpBackrefImpl(node);
            if (aSTWrapperPsiElement == null) throw new IllegalStateException("@NotNull method org/intellij/lang/regexp/RegExpParserDefinition.createElement must not return null");
            return aSTWrapperPsiElement;
        }
        if (type == RegExpElementTypes.CLOSURE) {
            aSTWrapperPsiElement = new RegExpClosureImpl(node);
            if (aSTWrapperPsiElement == null) throw new IllegalStateException("@NotNull method org/intellij/lang/regexp/RegExpParserDefinition.createElement must not return null");
            return aSTWrapperPsiElement;
        }
        if (type == RegExpElementTypes.QUANTIFIER) {
            aSTWrapperPsiElement = new RegExpQuantifierImpl(node);
            if (aSTWrapperPsiElement == null) throw new IllegalStateException("@NotNull method org/intellij/lang/regexp/RegExpParserDefinition.createElement must not return null");
            return aSTWrapperPsiElement;
        }
        if (type == RegExpElementTypes.BOUNDARY) {
            aSTWrapperPsiElement = new RegExpBoundaryImpl(node);
            if (aSTWrapperPsiElement == null) throw new IllegalStateException("@NotNull method org/intellij/lang/regexp/RegExpParserDefinition.createElement must not return null");
            return aSTWrapperPsiElement;
        }
        if (type == RegExpElementTypes.INTERSECTION) {
            aSTWrapperPsiElement = new RegExpIntersectionImpl(node);
            if (aSTWrapperPsiElement == null) throw new IllegalStateException("@NotNull method org/intellij/lang/regexp/RegExpParserDefinition.createElement must not return null");
            return aSTWrapperPsiElement;
        }
        if (type == RegExpElementTypes.PY_NAMED_GROUP_REF) {
            aSTWrapperPsiElement = new RegExpPyNamedGroupRefImpl(node);
            if (aSTWrapperPsiElement == null) throw new IllegalStateException("@NotNull method org/intellij/lang/regexp/RegExpParserDefinition.createElement must not return null");
            return aSTWrapperPsiElement;
        }
        if (type == RegExpElementTypes.PY_COND_REF) {
            aSTWrapperPsiElement = new RegExpPyCondRefImpl(node);
            if (aSTWrapperPsiElement == null) throw new IllegalStateException("@NotNull method org/intellij/lang/regexp/RegExpParserDefinition.createElement must not return null");
            return aSTWrapperPsiElement;
        }
        aSTWrapperPsiElement = new ASTWrapperPsiElement(node);
        if (aSTWrapperPsiElement != null) return aSTWrapperPsiElement;
        throw new IllegalStateException("@NotNull method org/intellij/lang/regexp/RegExpParserDefinition.createElement must not return null");
    }

    public PsiFile createFile(FileViewProvider viewProvider) {
        return new RegExpFile(viewProvider, RegExpLanguage.INSTANCE);
    }

    public ParserDefinition.SpaceRequirements spaceExistanceTypeBetweenTokens(ASTNode left, ASTNode right) {
        return ParserDefinition.SpaceRequirements.MUST_NOT;
    }
}

