/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.impl.artifacts;

import com.intellij.lang.ant.config.AntBuildTarget;
import com.intellij.lang.ant.config.AntConfiguration;
import com.intellij.lang.ant.config.impl.TargetChooserDialog;
import com.intellij.lang.ant.config.impl.artifacts.AntArtifactProperties;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.ui.ArtifactPropertiesEditor;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class AntArtifactPropertiesEditor
extends ArtifactPropertiesEditor {
    private final AntArtifactProperties myProperties;
    private final Project myProject;
    private JPanel myMainPanel;
    private JCheckBox myRunTargetCheckBox;
    private FixedSizeButton mySelectTargetButton;
    private AntBuildTarget myTarget;
    private boolean myPostProcessing;

    public AntArtifactPropertiesEditor(AntArtifactProperties properties, Project project, boolean postProcessing) {
        this.myProperties = properties;
        this.myProject = project;
        this.myPostProcessing = postProcessing;
        this.$$$setupUI$$$();
        this.mySelectTargetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AntArtifactPropertiesEditor.this.selectTarget();
            }
        });
        this.myRunTargetCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AntArtifactPropertiesEditor.this.mySelectTargetButton.setEnabled(AntArtifactPropertiesEditor.this.myRunTargetCheckBox.isSelected());
                if (AntArtifactPropertiesEditor.this.myRunTargetCheckBox.isSelected() && AntArtifactPropertiesEditor.this.myTarget == null) {
                    AntArtifactPropertiesEditor.this.selectTarget();
                }
            }
        });
    }

    private void selectTarget() {
        TargetChooserDialog dialog = new TargetChooserDialog(this.myProject, this.myTarget);
        dialog.show();
        if (dialog.isOK()) {
            this.myTarget = dialog.getSelectedTarget();
            this.updateLabel();
        }
    }

    private void updateLabel() {
        if (this.myTarget != null) {
            this.myRunTargetCheckBox.setText("Run Ant target '" + this.myTarget.getName() + "'");
        } else {
            this.myRunTargetCheckBox.setText("Run Ant target <none>");
        }
    }

    public String getTabName() {
        return this.myPostProcessing ? "Post-processing" : "Pre-processing";
    }

    public void apply() {
        VirtualFile file;
        this.myProperties.setEnabled(this.myRunTargetCheckBox.isSelected());
        if (this.myTarget != null && (file = this.myTarget.getModel().getBuildFile().getVirtualFile()) != null) {
            this.myProperties.setFileUrl(file.getUrl());
            this.myProperties.setTargetName(this.myTarget.getName());
            return;
        }
        this.myProperties.setFileUrl(null);
        this.myProperties.setTargetName(null);
    }

    public JComponent createComponent() {
        return this.myMainPanel;
    }

    public boolean isModified() {
        if (this.myProperties.isEnabled() != this.myRunTargetCheckBox.isSelected()) {
            return true;
        }
        if (this.myTarget == null) {
            return this.myProperties.getFileUrl() != null;
        }
        if (!Comparing.equal((String)this.myTarget.getName(), (String)this.myProperties.getTargetName())) {
            return true;
        }
        VirtualFile file = this.myTarget.getModel().getBuildFile().getVirtualFile();
        return file != null && !Comparing.equal((String)file.getUrl(), (String)this.myProperties.getFileUrl());
    }

    public void reset() {
        this.myRunTargetCheckBox.setSelected(this.myProperties.isEnabled());
        this.myTarget = this.myProperties.findTarget(AntConfiguration.getInstance(this.myProject));
        this.updateLabel();
    }

    public void disposeUIResources() {
    }

    private /* synthetic */ void $$$setupUI$$$() {
        FixedSizeButton fixedSizeButton;
        JCheckBox jCheckBox;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myRunTargetCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("run");
        jPanel2.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.mySelectTargetButton = fixedSizeButton = new FixedSizeButton();
        jPanel2.add((Component)fixedSizeButton, new GridConstraints(0, 1, 1, 1, 0, 0, 3, 3, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

