/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.psi.impl.reference.providers;

import com.intellij.lang.ant.AntBundle;
import com.intellij.lang.ant.misc.PsiReferenceListSpinAllocator;
import com.intellij.lang.ant.psi.AntElement;
import com.intellij.lang.ant.psi.AntFile;
import com.intellij.lang.ant.psi.AntStructuredElement;
import com.intellij.lang.ant.psi.impl.reference.AntPropertyReference;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ProcessingContext;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class AntPropertyReferenceProvider
extends PsiReferenceProvider {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        PsiReference[] psiReferenceArray;
        block13: {
            if (element == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/ant/psi/impl/reference/providers/AntPropertyReferenceProvider.getReferencesByElement must not be null");
            }
            if (context == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/lang/ant/psi/impl/reference/providers/AntPropertyReferenceProvider.getReferencesByElement must not be null");
            }
            AntStructuredElement antElement = (AntStructuredElement)element;
            XmlTag sourceElement = antElement.getSourceElement();
            XmlAttribute[] attributes = sourceElement.getAttributes();
            if (attributes.length > 0) {
                List<PsiReference> refs = PsiReferenceListSpinAllocator.alloc();
                boolean isSet = "isset".equals(sourceElement.getName());
                for (XmlAttribute attr : attributes) {
                    String attName = attr.getName();
                    if ("if".equals(attName) || "unless".equals(attName)) {
                        AntPropertyReferenceProvider.getAttributeReference(antElement, attr, refs);
                        continue;
                    }
                    if (isSet && "property".equals(attName)) {
                        AntPropertyReferenceProvider.getAttributeReference(antElement, attr, refs);
                        continue;
                    }
                    AntPropertyReferenceProvider.getAttributeReferences(antElement, attr, refs);
                }
                if (refs.size() <= 0) break block13;
                PsiReference[] psiReferenceArray2 = refs.toArray(new PsiReference[refs.size()]);
                psiReferenceArray = psiReferenceArray2;
                if (psiReferenceArray2 == null) throw new IllegalStateException("@NotNull method com/intellij/lang/ant/psi/impl/reference/providers/AntPropertyReferenceProvider.getReferencesByElement must not return null");
                return psiReferenceArray;
                finally {
                    PsiReferenceListSpinAllocator.dispose(refs);
                }
            }
        }
        psiReferenceArray = PsiReference.EMPTY_ARRAY;
        if (PsiReference.EMPTY_ARRAY != null) return psiReferenceArray;
        throw new IllegalStateException("@NotNull method com/intellij/lang/ant/psi/impl/reference/providers/AntPropertyReferenceProvider.getReferencesByElement must not return null");
    }

    private static void getAttributeReferences(AntElement element, XmlAttribute attr, List<PsiReference> refs) {
        AntFile antFile = element.getAntFile();
        String value = attr.getValue();
        XmlAttributeValue xmlAttributeValue = attr.getValueElement();
        if (xmlAttributeValue != null && value.indexOf("@{") < 0) {
            int startIndex;
            int offsetInPosition = xmlAttributeValue.getTextRange().getStartOffset() - element.getTextRange().getStartOffset() + 1;
            int endIndex = -1;
            while ((startIndex = value.indexOf("${", endIndex + 1)) > endIndex) {
                if (startIndex > 0 && value.charAt(startIndex - 1) == '$') {
                    endIndex = startIndex + 1;
                    continue;
                }
                int nestedBrackets = 0;
                for (endIndex = startIndex += 2; value.length() > endIndex; ++endIndex) {
                    char ch = value.charAt(endIndex);
                    if (ch == '}') {
                        if (nestedBrackets == 0) break;
                        --nestedBrackets;
                        continue;
                    }
                    if (ch != '{') continue;
                    ++nestedBrackets;
                }
                if (nestedBrackets > 0 || endIndex > value.length()) {
                    return;
                }
                if (endIndex >= startIndex) {
                    String propName = value.substring(startIndex, endIndex);
                    if (antFile.isEnvironmentProperty(propName) && antFile.getProperty(propName) == null) continue;
                    refs.add((PsiReference)new AntPropertyReference(element, propName, new TextRange(offsetInPosition + startIndex, offsetInPosition + endIndex), attr));
                }
                endIndex = startIndex;
            }
        }
    }

    private static void getAttributeReference(AntElement element, XmlAttribute attr, List<PsiReference> refs) {
        AntFile antFile = element.getAntFile();
        String value = attr.getValue();
        if (value == null) {
            return;
        }
        if (antFile.isEnvironmentProperty(value) && antFile.getProperty(value) == null) {
            return;
        }
        XmlAttributeValue xmlAttributeValue = attr.getValueElement();
        if (xmlAttributeValue != null) {
            int offsetInPosition = xmlAttributeValue.getTextRange().getStartOffset() - element.getTextRange().getStartOffset() + 1;
            refs.add((PsiReference)new AntPropertyReference(element, value, new TextRange(offsetInPosition, offsetInPosition + value.length()), attr){

                @Override
                public boolean shouldBeSkippedByAnnotator() {
                    return this.getCanonicalText().length() > 0;
                }

                @Override
                public String getUnresolvedMessagePattern() {
                    return AntBundle.message("please.specify.a.property", new Object[0]);
                }
            });
        }
    }
}

