/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.IndentOptionsEditor;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;

public class SmartIndentOptionsEditor
extends IndentOptionsEditor {
    private JCheckBox myCbSmartTabs;
    private JTextField myContinuationIndentField;
    private JLabel myContinuationIndentLabel;

    @Override
    protected void addTabOptions() {
        super.addTabOptions();
        this.myCbSmartTabs = new JCheckBox(ApplicationBundle.message("checkbox.indent.smart.tabs", new Object[0]));
        this.add((JComponent)this.myCbSmartTabs, true);
    }

    @Override
    protected void addComponents() {
        super.addComponents();
        this.myContinuationIndentField = new JTextField(4);
        this.myContinuationIndentField.setMinimumSize(this.myContinuationIndentField.getPreferredSize());
        this.myContinuationIndentLabel = new JLabel(ApplicationBundle.message("editbox.indent.continuation.indent", new Object[0]));
        this.add((JComponent)this.myContinuationIndentLabel, this.myContinuationIndentField);
    }

    @Override
    public boolean isModified(CodeStyleSettings settings, CodeStyleSettings.IndentOptions options) {
        boolean isModified = super.isModified(settings, options);
        isModified |= SmartIndentOptionsEditor.isFieldModified(this.myCbSmartTabs, options.SMART_TABS);
        return isModified |= SmartIndentOptionsEditor.isFieldModified(this.myContinuationIndentField, options.CONTINUATION_INDENT_SIZE);
    }

    @Override
    public void apply(CodeStyleSettings settings, CodeStyleSettings.IndentOptions options) {
        super.apply(settings, options);
        try {
            options.CONTINUATION_INDENT_SIZE = Math.max(Integer.parseInt(this.myContinuationIndentField.getText()), 0);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        options.SMART_TABS = SmartIndentOptionsEditor.isSmartTabValid(options.INDENT_SIZE, options.TAB_SIZE) && this.myCbSmartTabs.isSelected();
    }

    @Override
    public void reset(@NotNull CodeStyleSettings settings, @NotNull CodeStyleSettings.IndentOptions options) {
        if (settings == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/application/options/SmartIndentOptionsEditor.reset must not be null");
        }
        if (options == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/application/options/SmartIndentOptionsEditor.reset must not be null");
        }
        super.reset(settings, options);
        this.myContinuationIndentField.setText(String.valueOf(options.CONTINUATION_INDENT_SIZE));
        this.myCbSmartTabs.setSelected(options.SMART_TABS);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        boolean smartTabsChecked = enabled && this.myCbUseTab.isSelected();
        boolean smartTabsValid = smartTabsChecked && SmartIndentOptionsEditor.isSmartTabValid(this.getUIIndent(), this.getUITabSize());
        this.myCbSmartTabs.setEnabled(smartTabsValid);
        this.myCbSmartTabs.setToolTipText(smartTabsChecked && !smartTabsValid ? ApplicationBundle.message("tooltip.indent.must.be.multiple.of.tab.size.for.smart.tabs.to.operate", new Object[0]) : null);
        this.myContinuationIndentField.setEnabled(enabled);
        this.myContinuationIndentLabel.setEnabled(enabled);
    }

    private static boolean isSmartTabValid(int indent, int tabSize) {
        return indent / tabSize * tabSize == indent;
    }
}

