/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.util;

import com.intellij.CommonBundle;
import com.intellij.execution.util.EnvironmentVariable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.table.TableView;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class EnvVariablesTable
extends Observable {
    private final List<EnvironmentVariable> myVariables = new ArrayList<EnvironmentVariable>();
    private final JPanel myPanel = new JPanel(new BorderLayout());
    private final ColumnInfo NAME = new ColumnInfo<EnvironmentVariable, String>("Name"){

        public String valueOf(EnvironmentVariable environmentVariable) {
            return environmentVariable.getName();
        }

        public Class getColumnClass() {
            return String.class;
        }

        public boolean isCellEditable(EnvironmentVariable environmentVariable) {
            return environmentVariable.getNameIsWriteable();
        }

        public void setValue(EnvironmentVariable environmentVariable, String s) {
            if (s.equals(this.valueOf(environmentVariable))) {
                return;
            }
            environmentVariable.setName(s);
            EnvVariablesTable.this.setModified();
        }
    };
    private final ColumnInfo VALUE = new ColumnInfo<EnvironmentVariable, String>("Value"){

        public String valueOf(EnvironmentVariable environmentVariable) {
            return environmentVariable.getValue();
        }

        public Class getColumnClass() {
            return String.class;
        }

        public boolean isCellEditable(EnvironmentVariable environmentVariable) {
            return !environmentVariable.getIsPredefined();
        }

        public void setValue(EnvironmentVariable environmentVariable, String s) {
            if (s.equals(this.valueOf(environmentVariable))) {
                return;
            }
            environmentVariable.setValue(s);
            EnvVariablesTable.this.setModified();
        }
    };
    private final TableView myTableVeiw = new TableView(new ListTableModel(new ColumnInfo[]{this.NAME, this.VALUE}));
    private boolean myIsEnabled = true;

    public EnvVariablesTable() {
        this.myTableVeiw.getTableViewModel().setSortable(false);
        this.myPanel.add((Component)ScrollPaneFactory.createScrollPane(this.myTableVeiw.getComponent()), "Center");
        JComponent toolbarComponent = this.createToolbar();
        this.myPanel.add((Component)toolbarComponent, "North");
        this.myTableVeiw.getComponent().setSelectionMode(0);
    }

    private void setModified() {
        this.setChanged();
        this.notifyObservers();
    }

    private JComponent createToolbar() {
        DefaultActionGroup actions = new DefaultActionGroup();
        actions.add(new AddAction());
        actions.add(new DeleteAction());
        JComponent toolbarComponent = ActionManager.getInstance().createActionToolbar("unknown", actions, true).getComponent();
        return toolbarComponent;
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    public void setEnabled() {
        this.myTableVeiw.getComponent().setEnabled(true);
        this.myIsEnabled = true;
    }

    public void setDisabled() {
        this.myTableVeiw.getComponent().setEnabled(false);
        this.myIsEnabled = false;
    }

    public void setValues(List<EnvironmentVariable> envVariables) {
        this.myVariables.clear();
        for (EnvironmentVariable envVariable : envVariables) {
            this.myVariables.add(envVariable.clone());
        }
        this.myTableVeiw.getTableViewModel().setItems(this.myVariables);
    }

    public List<EnvironmentVariable> getEnvironmentVariables() {
        return this.myVariables;
    }

    public void stopEditing() {
        this.myTableVeiw.stopEditing();
    }

    public void refreshValues() {
        this.myTableVeiw.getComponent().repaint();
    }

    private EnvironmentVariable getSelection() {
        int selIndex = this.myTableVeiw.getComponent().getSelectionModel().getMinSelectionIndex();
        if (selIndex < 0) {
            return null;
        }
        return this.myVariables.get(selIndex);
    }

    private final class AddAction
    extends AnAction {
        public AddAction() {
            super(CommonBundle.message((String)"button.add", (Object[])new Object[0]), null, IconLoader.getIcon((String)"/general/add.png"));
        }

        @Override
        public void update(AnActionEvent e) {
            Presentation presentation = e.getPresentation();
            presentation.setEnabled(EnvVariablesTable.this.myIsEnabled);
        }

        @Override
        public void actionPerformed(AnActionEvent e) {
            EnvVariablesTable.this.myTableVeiw.stopEditing();
            EnvVariablesTable.this.setModified();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    EnvVariablesTable.this.myVariables.add(new EnvironmentVariable("", "", false));
                    EnvVariablesTable.this.myTableVeiw.getTableViewModel().setItems(EnvVariablesTable.this.myVariables);
                    EnvVariablesTable.this.myTableVeiw.getComponent().editCellAt(EnvVariablesTable.this.myVariables.size() - 1, 0);
                }
            });
        }
    }

    private final class DeleteAction
    extends AnAction {
        public DeleteAction() {
            super(CommonBundle.message((String)"button.delete", (Object[])new Object[0]), null, IconLoader.getIcon((String)"/general/remove.png"));
        }

        @Override
        public void update(AnActionEvent e) {
            EnvironmentVariable selection = EnvVariablesTable.this.getSelection();
            Presentation presentation = e.getPresentation();
            presentation.setEnabled(selection != null && EnvVariablesTable.this.myIsEnabled && !selection.getIsPredefined());
        }

        @Override
        public void actionPerformed(AnActionEvent e) {
            EnvVariablesTable.this.myTableVeiw.stopEditing();
            EnvVariablesTable.this.setModified();
            EnvironmentVariable selected = EnvVariablesTable.this.getSelection();
            if (selected != null) {
                int selectedIndex = EnvVariablesTable.this.myVariables.indexOf(selected);
                EnvVariablesTable.this.myVariables.remove(selected);
                EnvVariablesTable.this.myTableVeiw.getTableViewModel().setItems(EnvVariablesTable.this.myVariables);
                int prev = selectedIndex - 1;
                if (prev >= 0) {
                    EnvVariablesTable.this.myTableVeiw.getComponent().getSelectionModel().setSelectionInterval(prev, prev);
                } else if (selectedIndex < EnvVariablesTable.this.myVariables.size()) {
                    EnvVariablesTable.this.myTableVeiw.getComponent().getSelectionModel().setSelectionInterval(selectedIndex, selectedIndex);
                }
            }
        }
    }
}

