/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.DiffContentUtil;
import com.intellij.openapi.diff.DocumentContent;
import com.intellij.openapi.diff.DocumentsSynchonizer;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;

public class FragmentContent
extends DiffContent {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.diff.FragmentContent");
    private final DiffContent myOriginal;
    private final FileType myType;
    private final MyDocumentsSynchonizer mySynchonizer;
    public static final Key<Document> ORIGINAL_DOCUMENT = new Key("ORIGINAL_DOCUMENT");

    public FragmentContent(DiffContent original, TextRange range, Project project, VirtualFile file) {
        this(original, range, project, file != null ? DiffContentUtil.getContentType(file) : null);
    }

    public FragmentContent(DiffContent original, TextRange range, Project project, FileType type) {
        this(original.getDocument().createRangeMarker(range.getStartOffset(), range.getEndOffset(), true), original, type, project);
    }

    private FragmentContent(RangeMarker rangeMarker, DiffContent original, FileType fileType, Project project) {
        this.mySynchonizer = new MyDocumentsSynchonizer(project, rangeMarker);
        this.myOriginal = original;
        this.myType = fileType;
    }

    public FragmentContent(DiffContent original, TextRange range, Project project) {
        this(original, range, project, (FileType)null);
    }

    private String subText(Document document, int startOffset, int length) {
        return ((Object)document.getCharsSequence().subSequence(startOffset, startOffset + length)).toString();
    }

    @Override
    public void onAssigned(boolean isAssigned) {
        this.myOriginal.onAssigned(isAssigned);
        this.mySynchonizer.listenDocuments(isAssigned);
        super.onAssigned(isAssigned);
    }

    @Override
    public Document getDocument() {
        return this.mySynchonizer.getCopy();
    }

    @Override
    public OpenFileDescriptor getOpenFileDescriptor(int offset) {
        return this.myOriginal.getOpenFileDescriptor(offset + this.mySynchonizer.getStartOffset());
    }

    @Override
    public VirtualFile getFile() {
        return null;
    }

    @Override
    public FileType getContentType() {
        return this.myType != null ? this.myType : this.myOriginal.getContentType();
    }

    @Override
    public byte[] getBytes() throws IOException {
        return this.getDocument().getText().getBytes();
    }

    public static FragmentContent fromRangeMarker(RangeMarker rangeMarker, Project project) {
        Document document = rangeMarker.getDocument();
        VirtualFile file = FileDocumentManager.getInstance().getFile(document);
        FileType type = FileTypeManager.getInstance().getFileTypeByFile(file);
        return new FragmentContent((DiffContent)new DocumentContent(project, document), new TextRange(rangeMarker.getStartOffset(), rangeMarker.getEndOffset()), project, type);
    }

    private class MyDocumentsSynchonizer
    extends DocumentsSynchonizer {
        private final RangeMarker myRangeMarker;

        public MyDocumentsSynchonizer(Project project, RangeMarker originalRange) {
            super(project);
            this.myRangeMarker = originalRange;
        }

        public int getStartOffset() {
            return this.myRangeMarker.getStartOffset();
        }

        @Override
        protected void onOriginalChanged(DocumentEvent event, Document copy) {
            if (!this.myRangeMarker.isValid()) {
                FragmentContent.this.fireContentInvalid();
                return;
            }
            this.replaceString(copy, 0, copy.getTextLength(), FragmentContent.this.subText(event.getDocument(), this.myRangeMarker.getStartOffset(), this.getLength()));
        }

        @Override
        protected void beforeListenersAttached(Document original, Document copy) {
            boolean writable = copy.isWritable();
            Document copyEx = copy;
            if (!writable) {
                copyEx.setReadOnly(false);
            }
            this.replaceString(copy, 0, copy.getTextLength(), FragmentContent.this.subText(original, this.myRangeMarker.getStartOffset(), this.getLength()));
            copyEx.setReadOnly(!writable);
        }

        private int getLength() {
            return this.myRangeMarker.getEndOffset() - this.myRangeMarker.getStartOffset();
        }

        @Override
        protected Document createOriginal() {
            return this.myRangeMarker.getDocument();
        }

        @Override
        protected Document createCopy() {
            Document originalDocument = this.myRangeMarker.getDocument();
            String textInRange = ((Object)originalDocument.getCharsSequence().subSequence(this.myRangeMarker.getStartOffset(), this.myRangeMarker.getEndOffset())).toString();
            Document result = EditorFactory.getInstance().createDocument(textInRange);
            result.setReadOnly(!originalDocument.isWritable());
            result.putUserData(ORIGINAL_DOCUMENT, originalDocument);
            return result;
        }

        @Override
        protected void onCopyChanged(DocumentEvent event, Document original) {
            int originalOffset = event.getOffset() + this.myRangeMarker.getStartOffset();
            LOG.assertTrue(originalOffset >= 0);
            if (!original.isWritable()) {
                return;
            }
            String newText = FragmentContent.this.subText(event.getDocument(), event.getOffset(), event.getNewLength());
            int originalEnd = originalOffset + event.getOldLength();
            this.replaceString(original, originalOffset, originalEnd, newText);
        }
    }
}

