/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes;

import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.util.PatternUtil;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class WildcardFileNameMatcher
implements FileNameMatcher {
    private final String myPattern;
    private final MaskMatcher myMatcher;

    public WildcardFileNameMatcher(@NotNull @NonNls String pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileTypes/WildcardFileNameMatcher.<init> must not be null");
        }
        this.myPattern = pattern;
        this.myMatcher = WildcardFileNameMatcher.createMatcher(pattern);
    }

    private static MaskMatcher createMatcher(String pattern) {
        if (pattern.length() > 1 && pattern.charAt(0) == '*' && pattern.indexOf(42, 1) < 0 && pattern.indexOf(63) < 0) {
            return new SuffixMatcher(pattern.substring(1));
        }
        return new RegexpMatcher(pattern);
    }

    @Override
    public boolean accept(@NotNull String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileTypes/WildcardFileNameMatcher.accept must not be null");
        }
        return this.myMatcher.matches(fileName);
    }

    @Override
    @NonNls
    @NotNull
    public String getPresentableString() {
        String string = this.myPattern;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileTypes/WildcardFileNameMatcher.getPresentableString must not return null");
        }
        return string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WildcardFileNameMatcher that = (WildcardFileNameMatcher)o;
        return this.myPattern.equals(that.myPattern);
    }

    public int hashCode() {
        return this.myPattern.hashCode();
    }

    public String getPattern() {
        return this.myPattern;
    }

    private static final class SuffixMatcher
    implements MaskMatcher {
        private final String mySuffix;

        private SuffixMatcher(String suffix) {
            this.mySuffix = suffix;
        }

        @Override
        public boolean matches(String filename) {
            return filename.endsWith(this.mySuffix);
        }
    }

    private static final class RegexpMatcher
    implements MaskMatcher {
        private final Matcher myMatcher;

        private RegexpMatcher(String pattern) {
            this.myMatcher = PatternUtil.fromMask((String)pattern).matcher("");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean matches(String filename) {
            Matcher matcher = this.myMatcher;
            synchronized (matcher) {
                this.myMatcher.reset(filename);
                return this.myMatcher.matches();
            }
        }
    }

    private static interface MaskMatcher {
        public boolean matches(String var1);
    }
}

