/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.Nullable;

public class ProjectUtil {
    private ProjectUtil() {
    }

    public static String calcRelativeToProjectPath(VirtualFile file, Project project) {
        Module module;
        String projectHomeUrl;
        String url = file.getPresentableUrl();
        if (project == null) {
            return url;
        }
        VirtualFile baseDir = project.getBaseDir();
        if (baseDir != null && url.startsWith(projectHomeUrl = baseDir.getPresentableUrl())) {
            url = "..." + url.substring(projectHomeUrl.length());
        }
        if ((module = ModuleUtil.findModuleForFile(file, project)) == null) {
            return url;
        }
        return new StringBuffer().append("[").append(module.getName()).append("] - ").append(url).toString();
    }

    @Nullable
    public static Project guessProjectForFile(VirtualFile file) {
        return ProjectLocator.getInstance().guessProjectForFile(file);
    }
}

