/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots;

import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public class FileIndexUtil {
    private FileIndexUtil() {
    }

    public static boolean isJavaSourceFile(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/FileIndexUtil.isJavaSourceFile must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/roots/FileIndexUtil.isJavaSourceFile must not be null");
        }
        FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        if (file.isDirectory()) {
            return false;
        }
        if (fileTypeManager.getFileTypeByFile(file) != StdFileTypes.JAVA) {
            return false;
        }
        if (fileTypeManager.isFileIgnored(file.getName())) {
            return false;
        }
        return ProjectRootManager.getInstance(project).getFileIndex().isInSource(file);
    }
}

