/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.openapi.vcs.SelectionManipulation;
import com.intellij.openapi.vcs.SelectionResult;
import com.intellij.openapi.vcs.SelectionState;
import java.util.HashSet;
import java.util.Set;

public class QuantitySelection<T>
implements SelectionManipulation<T>,
SelectionState<T> {
    private final Group<T> mySelected = new Group();
    private final Group<T> myUnselected = new Group();

    public QuantitySelection(boolean startFromSelectAll) {
        if (startFromSelectAll) {
            this.mySelected.setAll();
        } else {
            this.myUnselected.setAll();
        }
    }

    @Override
    public void add(T t) {
        if (this.mySelected.isAll()) {
            this.myUnselected.remove(t);
        } else {
            this.mySelected.add(t);
        }
    }

    @Override
    public void remove(T t) {
        if (this.mySelected.isAll()) {
            this.myUnselected.add(t);
        } else {
            this.mySelected.remove(t);
        }
    }

    @Override
    public void clearAll() {
        this.mySelected.clearAll();
        this.myUnselected.setAll();
    }

    @Override
    public void setAll() {
        this.myUnselected.clearAll();
        this.mySelected.setAll();
    }

    @Override
    public SelectionResult<T> getSelected() {
        return this.mySelected;
    }

    @Override
    public SelectionResult<T> getUnselected() {
        return this.myUnselected;
    }

    @Override
    public boolean isSelected(T t) {
        return this.mySelected.isAll() && !this.myUnselected.hasPoint(t) || this.myUnselected.isAll() && this.mySelected.hasPoint(t);
    }

    public static class Group<T>
    implements SelectionManipulation<T>,
    SelectionResult<T> {
        private boolean myAll;
        private final Set<T> myMarked = new HashSet<T>();

        private Group() {
        }

        @Override
        public void add(T t) {
            this.myMarked.add(t);
        }

        @Override
        public void remove(T t) {
            this.myAll = false;
            this.myMarked.remove(t);
        }

        @Override
        public void clearAll() {
            this.myAll = false;
            this.myMarked.clear();
        }

        @Override
        public void setAll() {
            this.myAll = true;
            this.myMarked.clear();
        }

        @Override
        public Set<T> getMarked() {
            return this.myMarked;
        }

        @Override
        public boolean isAll() {
            return this.myAll;
        }

        public boolean hasPoint(T t) {
            return this.myMarked.contains(t);
        }

        public boolean isIncluded(T t) {
            return this.myAll || this.myMarked.contains(t);
        }
    }
}

