/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.VcsInvalidated;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VcsDirtyScopeManager {
    public static VcsDirtyScopeManager getInstance(Project project) {
        return project.getComponent(VcsDirtyScopeManager.class);
    }

    public static VcsDirtyScopeManager getInstanceChecked(final Project project) {
        return ApplicationManager.getApplication().runReadAction(new Computable<VcsDirtyScopeManager>(){

            public VcsDirtyScopeManager compute() {
                if (project.isDisposed()) {
                    throw new ProcessCanceledException();
                }
                return project.getComponent(VcsDirtyScopeManager.class);
            }
        });
    }

    public abstract void markEverythingDirty();

    public abstract void fileDirty(VirtualFile var1);

    public abstract void fileDirty(FilePath var1);

    public abstract void dirDirtyRecursively(VirtualFile var1, boolean var2);

    public abstract void dirDirtyRecursively(VirtualFile var1);

    public abstract void dirDirtyRecursively(FilePath var1);

    public abstract VcsInvalidated retrieveScopes();

    @NotNull
    public abstract Collection<FilePath> whatFilesDirty(@NotNull Collection<FilePath> var1);

    public abstract boolean filePathsDirty(@Nullable Collection<FilePath> var1, @Nullable Collection<FilePath> var2);

    public abstract boolean filesDirty(@Nullable Collection<VirtualFile> var1, @Nullable Collection<VirtualFile> var2);
}

