/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.vfs.LocalFileOperationsHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.util.Processor;
import com.intellij.util.io.fs.IFile;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LocalFileSystem
extends NewVirtualFileSystem {
    @NonNls
    public static final String PROTOCOL = "file";
    @NonNls
    public static final String PROTOCOL_PREFIX = "file://";

    public static LocalFileSystem getInstance() {
        return LocalFileSystemHolder.ourInstance;
    }

    @Nullable
    public abstract VirtualFile findFileByIoFile(File var1);

    @Nullable
    public abstract VirtualFile findFileByIoFile(IFile var1);

    @Nullable
    public abstract VirtualFile refreshAndFindFileByIoFile(@NotNull File var1);

    @Nullable
    public abstract VirtualFile refreshAndFindFileByIoFile(IFile var1);

    public abstract void refreshIoFiles(Iterable<File> var1);

    public abstract void refreshFiles(Iterable<VirtualFile> var1);

    public abstract byte[] physicalContentsToByteArray(VirtualFile var1) throws IOException;

    public abstract long physicalLength(VirtualFile var1) throws IOException;

    @Nullable
    public abstract WatchRequest addRootToWatch(@NotNull String var1, boolean var2);

    @NotNull
    public abstract Set<WatchRequest> addRootsToWatch(@NotNull Collection<String> var1, boolean var2);

    public abstract void removeWatchedRoots(@NotNull Collection<WatchRequest> var1);

    public abstract void removeWatchedRoot(@NotNull WatchRequest var1);

    public abstract void registerAuxiliaryFileOperationsHandler(LocalFileOperationsHandler var1);

    public abstract void unregisterAuxiliaryFileOperationsHandler(LocalFileOperationsHandler var1);

    public abstract boolean processCachedFilesInSubtree(VirtualFile var1, Processor<VirtualFile> var2);

    public static interface WatchRequest {
        @NotNull
        public String getRootPath();

        @NotNull
        public String getFileSystemRootPath();

        public boolean isToWatchRecursively();

        public boolean dominates(WatchRequest var1);
    }

    private static class LocalFileSystemHolder {
        private static final LocalFileSystem ourInstance = ApplicationManager.getApplication().getComponent(LocalFileSystem.class);

        private LocalFileSystemHolder() {
        }
    }
}

