/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.events;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import org.jetbrains.annotations.NonNls;

public class VFileCreateEvent
extends VFileEvent {
    private final VirtualFile myParent;
    private final boolean myDirectory;
    private final String myChildName;

    public VFileCreateEvent(Object requestor, VirtualFile parent, String childName, boolean isDirectory, boolean isFromRefresh) {
        super(requestor, isFromRefresh);
        this.myChildName = childName;
        this.myParent = parent;
        this.myDirectory = isDirectory;
    }

    public String getChildName() {
        return this.myChildName;
    }

    public boolean isDirectory() {
        return this.myDirectory;
    }

    public VirtualFile getParent() {
        return this.myParent;
    }

    @NonNls
    public String toString() {
        return "VfsEvent[create " + (this.isDirectory() ? "dir " : "file ") + this.myChildName + " in " + this.myParent.getUrl() + "]";
    }

    @Override
    public String getPath() {
        return this.myParent.getPath() + "/" + this.myChildName;
    }

    @Override
    public VirtualFileSystem getFileSystem() {
        return this.myParent.getFileSystem();
    }

    @Override
    public boolean isValid() {
        return this.myParent.isValid() && this.myParent.findChild(this.myChildName) == null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VFileCreateEvent event = (VFileCreateEvent)o;
        if (this.myDirectory != event.myDirectory) {
            return false;
        }
        if (!this.myChildName.equals(event.myChildName)) {
            return false;
        }
        return this.myParent.equals(event.myParent);
    }

    @Override
    public int hashCode() {
        int result = this.myParent.hashCode();
        result = 31 * result + (this.myDirectory ? 1 : 0);
        result = 31 * result + this.myChildName.hashCode();
        return result;
    }
}

