/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.patterns;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.PsiMemberPattern;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.searches.SuperMethodsSearch;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PsiMethodPattern
extends PsiMemberPattern<PsiMethod, PsiMethodPattern> {
    public PsiMethodPattern() {
        super(PsiMethod.class);
    }

    public PsiMethodPattern withParameterCount(final @NonNls int paramCount) {
        return (PsiMethodPattern)this.with(new PatternCondition<PsiMethod>("withParameterCount"){

            @Override
            public boolean accepts(@NotNull PsiMethod method, ProcessingContext context) {
                if (method == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/PsiMethodPattern$1.accepts must not be null");
                }
                return method.getParameterList().getParametersCount() == paramCount;
            }
        });
    }

    public PsiMethodPattern withParameters(final String ... types) {
        return (PsiMethodPattern)this.with(new PatternCondition<PsiMethod>("withParameters"){

            @Override
            public boolean accepts(@NotNull PsiMethod psiMethod, ProcessingContext context) {
                if (psiMethod == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/PsiMethodPattern$2.accepts must not be null");
                }
                PsiParameterList parameterList = psiMethod.getParameterList();
                int dotsIndex = -1;
                while (++dotsIndex < types.length && !Comparing.equal((String)"..", (String)types[dotsIndex])) {
                }
                if (dotsIndex == types.length && parameterList.getParametersCount() != dotsIndex || dotsIndex < types.length && parameterList.getParametersCount() < dotsIndex) {
                    return false;
                }
                if (dotsIndex > 0) {
                    PsiParameter[] psiParameters = parameterList.getParameters();
                    for (int i = 0; i < dotsIndex; ++i) {
                        if (Comparing.equal((String)"?", (String)types[i]) || this.typeEquivalent(psiParameters[i].getType(), types[i])) continue;
                        return false;
                    }
                }
                return true;
            }

            private boolean typeEquivalent(PsiType type, String expectedText) {
                PsiType erasure = TypeConversionUtil.erasure(type);
                String text = erasure instanceof PsiEllipsisType && expectedText.endsWith("[]") ? ((PsiEllipsisType)erasure).getComponentType().getCanonicalText() + "[]" : (erasure instanceof PsiArrayType && expectedText.endsWith("...") ? ((PsiArrayType)erasure).getComponentType().getCanonicalText() + "..." : erasure.getCanonicalText());
                return expectedText.equals(text);
            }
        });
    }

    public PsiMethodPattern definedInClass(@NonNls String qname) {
        return this.definedInClass(PsiJavaPatterns.psiClass().withQualifiedName(qname));
    }

    public PsiMethodPattern definedInClass(final ElementPattern<? extends PsiClass> pattern) {
        return (PsiMethodPattern)this.with(new PatternCondition<PsiMethod>("definedInClass"){

            @Override
            public boolean accepts(@NotNull PsiMethod psiMethod, ProcessingContext context) {
                if (psiMethod == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/PsiMethodPattern$3.accepts must not be null");
                }
                if (pattern.accepts(psiMethod.getContainingClass(), context)) {
                    return true;
                }
                final Ref ref = new Ref((Object)Boolean.FALSE);
                SuperMethodsSearch.search(psiMethod, null, true, false).forEach((Processor)new Processor<MethodSignatureBackedByPsiMethod>(){

                    public boolean process(MethodSignatureBackedByPsiMethod methodSignatureBackedByPsiMethod) {
                        if (pattern.accepts(methodSignatureBackedByPsiMethod.getMethod().getContainingClass())) {
                            ref.set((Object)Boolean.TRUE);
                            return false;
                        }
                        return true;
                    }
                });
                return (Boolean)ref.get();
            }
        });
    }

    public PsiMethodPattern constructor(final boolean isConstructor) {
        return (PsiMethodPattern)this.with(new PatternCondition<PsiMethod>("constructor"){

            @Override
            public boolean accepts(@NotNull PsiMethod method, ProcessingContext context) {
                if (method == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/PsiMethodPattern$4.accepts must not be null");
                }
                return method.isConstructor() == isConstructor;
            }
        });
    }

    public PsiMethodPattern withThrowsList(final ElementPattern<?> pattern) {
        return (PsiMethodPattern)this.with(new PatternCondition<PsiMethod>("withThrowsList"){

            @Override
            public boolean accepts(@NotNull PsiMethod method, ProcessingContext context) {
                if (method == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/PsiMethodPattern$5.accepts must not be null");
                }
                return pattern.accepts(method.getThrowsList());
            }
        });
    }
}

