/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.patterns;

import com.intellij.patterns.CaseInsensitiveValuePatternCondition;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.InitialPatternCondition;
import com.intellij.patterns.ObjectPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.util.ProcessingContext;
import java.util.Collection;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringPattern
extends ObjectPattern<String, StringPattern> {
    private static final InitialPatternCondition<String> CONDITION = new InitialPatternCondition<String>(String.class){

        @Override
        public boolean accepts(@Nullable Object o, ProcessingContext context) {
            return o instanceof String;
        }

        @Override
        public void append(@NonNls StringBuilder builder, String indent) {
            builder.append("string()");
        }
    };

    protected StringPattern() {
        super(CONDITION);
    }

    @NotNull
    public StringPattern startsWith(final @NonNls @NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/StringPattern.startsWith must not be null");
        }
        StringPattern stringPattern = (StringPattern)this.with(new PatternCondition<String>("startsWith"){

            @Override
            public boolean accepts(@NotNull String str, ProcessingContext context) {
                if (str == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/StringPattern$2.accepts must not be null");
                }
                return str.startsWith(s);
            }
        });
        if (stringPattern == null) {
            throw new IllegalStateException("@NotNull method com/intellij/patterns/StringPattern.startsWith must not return null");
        }
        return stringPattern;
    }

    @NotNull
    public StringPattern endsWith(final @NonNls @NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/StringPattern.endsWith must not be null");
        }
        StringPattern stringPattern = (StringPattern)this.with(new PatternCondition<String>("endsWith"){

            @Override
            public boolean accepts(@NotNull String str, ProcessingContext context) {
                if (str == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/StringPattern$3.accepts must not be null");
                }
                return str.endsWith(s);
            }
        });
        if (stringPattern == null) {
            throw new IllegalStateException("@NotNull method com/intellij/patterns/StringPattern.endsWith must not return null");
        }
        return stringPattern;
    }

    @NotNull
    public StringPattern contains(final @NonNls @NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/StringPattern.contains must not be null");
        }
        StringPattern stringPattern = (StringPattern)this.with(new PatternCondition<String>("contains"){

            @Override
            public boolean accepts(@NotNull String str, ProcessingContext context) {
                if (str == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/StringPattern$4.accepts must not be null");
                }
                return str.contains(s);
            }
        });
        if (stringPattern == null) {
            throw new IllegalStateException("@NotNull method com/intellij/patterns/StringPattern.contains must not return null");
        }
        return stringPattern;
    }

    @NotNull
    public StringPattern matches(@NonNls @NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/StringPattern.matches must not be null");
        }
        final Pattern pattern = Pattern.compile(s);
        StringPattern stringPattern = (StringPattern)this.with(new PatternCondition<String>("matches"){

            @Override
            public boolean accepts(@NotNull String str, ProcessingContext context) {
                if (str == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/StringPattern$5.accepts must not be null");
                }
                return pattern.matcher(str).matches();
            }
        });
        if (stringPattern == null) {
            throw new IllegalStateException("@NotNull method com/intellij/patterns/StringPattern.matches must not return null");
        }
        return stringPattern;
    }

    @NotNull
    public StringPattern contains(final @NonNls @NotNull ElementPattern<Character> pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/StringPattern.contains must not be null");
        }
        StringPattern stringPattern = (StringPattern)this.with(new PatternCondition<String>("contains"){

            @Override
            public boolean accepts(@NotNull String str, ProcessingContext context) {
                if (str == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/StringPattern$6.accepts must not be null");
                }
                for (int i = 0; i < str.length(); ++i) {
                    if (!pattern.accepts(Character.valueOf(str.charAt(i)))) continue;
                    return true;
                }
                return false;
            }
        });
        if (stringPattern == null) {
            throw new IllegalStateException("@NotNull method com/intellij/patterns/StringPattern.contains must not return null");
        }
        return stringPattern;
    }

    public StringPattern longerThan(final int minLength) {
        return (StringPattern)this.with(new PatternCondition<String>("longerThan"){

            @Override
            public boolean accepts(@NotNull String s, ProcessingContext context) {
                if (s == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/patterns/StringPattern$7.accepts must not be null");
                }
                return s.length() > minLength;
            }
        });
    }

    @NotNull
    public StringPattern oneOf(String ... values) {
        StringPattern stringPattern = (StringPattern)super.oneOf(values);
        if (stringPattern == null) {
            throw new IllegalStateException("@NotNull method com/intellij/patterns/StringPattern.oneOf must not return null");
        }
        return stringPattern;
    }

    @NotNull
    public StringPattern oneOfIgnoreCase(String ... values) {
        StringPattern stringPattern = (StringPattern)this.with(new CaseInsensitiveValuePatternCondition("oneOfIgnoreCase", values));
        if (stringPattern == null) {
            throw new IllegalStateException("@NotNull method com/intellij/patterns/StringPattern.oneOfIgnoreCase must not return null");
        }
        return stringPattern;
    }

    @Override
    @NotNull
    public StringPattern oneOf(@NonNls Collection<String> set) {
        StringPattern stringPattern = (StringPattern)super.oneOf(set);
        if (stringPattern == null) {
            throw new IllegalStateException("@NotNull method com/intellij/patterns/StringPattern.oneOf must not return null");
        }
        return stringPattern;
    }
}

