/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.pom.references;

import com.intellij.openapi.util.TextRange;
import com.intellij.pom.PomTarget;
import com.intellij.pom.references.PomReference;
import com.intellij.psi.DelegatePsiTarget;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.meta.PsiMetaDataTarget;
import com.intellij.psi.meta.PsiMetaOwner;
import org.jetbrains.annotations.NotNull;

public class PomReferenceUtil {
    public static String getReferenceText(PomReference reference) {
        return reference.getRangeInElement().substring(reference.getElement().getText());
    }

    public static TextRange getDefaultRangeInElement(PsiElement element) {
        ElementManipulator<PsiElement> manipulator = ElementManipulators.getManipulator(element);
        assert (manipulator != null) : "Cannot find manipulator for " + element;
        return manipulator.getRangeInElement(element);
    }

    public static void changeContent(PomReference reference, String newContent) {
        ElementManipulator<PsiElement> manipulator = ElementManipulators.getManipulator(reference.getElement());
        assert (manipulator != null) : "Cannot find manipulator for " + reference.getElement();
        manipulator.handleContentChange(reference.getElement(), reference.getRangeInElement(), newContent);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static PomTarget convertPsi2Target(@NotNull PsiElement element) {
        PomTarget pomTarget;
        PsiMetaOwner metaOwner;
        PsiMetaData psiMetaData;
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/pom/references/PomReferenceUtil.convertPsi2Target must not be null");
        }
        if (element instanceof PsiMetaOwner && (psiMetaData = (metaOwner = (PsiMetaOwner)((Object)element)).getMetaData()) != null) {
            pomTarget = new PsiMetaDataTarget(psiMetaData);
            if (pomTarget == null) throw new IllegalStateException("@NotNull method com/intellij/pom/references/PomReferenceUtil.convertPsi2Target must not return null");
            return pomTarget;
        }
        if (element instanceof PomTarget) {
            pomTarget = (PomTarget)((Object)element);
            if (pomTarget == null) throw new IllegalStateException("@NotNull method com/intellij/pom/references/PomReferenceUtil.convertPsi2Target must not return null");
            return pomTarget;
        }
        pomTarget = new DelegatePsiTarget(element);
        if (pomTarget != null) return pomTarget;
        throw new IllegalStateException("@NotNull method com/intellij/pom/references/PomReferenceUtil.convertPsi2Target must not return null");
    }
}

