/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile;

import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.components.StateSplitter;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.profile.ApplicationProfileManager;
import com.intellij.profile.Profile;
import com.intellij.profile.ProfileChangeAdapter;
import com.intellij.profile.ProjectProfileManager;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.util.ArrayUtil;
import com.intellij.util.text.UniqueNameGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class DefaultProjectProfileManager
extends ProjectProfileManager {
    protected static final Logger LOG = Logger.getInstance((String)"#com.intellij.profile.DefaultProjectProfileManager");
    @NonNls
    protected static final String PROFILES = "profiles";
    @NonNls
    public static final String SCOPES = "scopes";
    @NonNls
    protected static final String SCOPE = "scope";
    @NonNls
    public static final String PROFILE = "profile";
    @NonNls
    protected static final String NAME = "name";
    private static final String VERSION = "1.0";
    protected final Project myProject;
    private final String myProfileType;
    public String PROJECT_PROFILE;
    public boolean USE_PROJECT_PROFILE = !DefaultProjectProfileManager.isPlatform();
    private ApplicationProfileManager myApplicationProfileManager;
    private Map<String, Profile> myProfiles = new HashMap<String, Profile>();
    private final DependencyValidationManager myHolder;
    private List<ProfileChangeAdapter> myProfilesListener = new ArrayList<ProfileChangeAdapter>();
    @NonNls
    private static final String PROJECT_DEFAULT_PROFILE_NAME = "Project Default";

    public DefaultProjectProfileManager(Project project, String profileType, DependencyValidationManager holder) {
        this.myProject = project;
        this.myProfileType = profileType;
        this.myHolder = holder;
        this.myApplicationProfileManager = ApplicationProfileManager.getProfileManager(profileType);
        LOG.assertTrue(this.myApplicationProfileManager != null);
    }

    @Override
    public Profile getProfile(@NotNull String name, boolean returnRootProfileIfNamedIsAbsent) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/profile/DefaultProjectProfileManager.getProfile must not be null");
        }
        return this.myProfiles.containsKey(name) ? this.myProfiles.get(name) : this.myApplicationProfileManager.getProfile(name, returnRootProfileIfNamedIsAbsent);
    }

    @Override
    public void updateProfile(Profile profile) {
        this.myProfiles.put(profile.getName(), profile);
        for (ProfileChangeAdapter profileChangeAdapter : this.myProfilesListener) {
            profileChangeAdapter.profileChanged(profile);
        }
    }

    public void readExternal(Element element) throws InvalidDataException {
        this.myProfiles.clear();
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
        Element profilesElement = element.getChild(PROFILES);
        if (profilesElement != null) {
            for (Object o : profilesElement.getChildren(PROFILE)) {
                Profile profile = this.myApplicationProfileManager.createProfile();
                profile.setProfileManager(this);
                profile.readExternal((Element)o);
                String name = profile.getName();
                if (this.myApplicationProfileManager.getProfile(name) != null) {
                    // empty if block
                }
                this.myProfiles.put(name, profile);
            }
        }
        if (element.getChild("version") == null || !Comparing.strEqual((String)element.getChild("version").getAttributeValue("value"), (String)VERSION)) {
            boolean toConvert = true;
            for (Object o : element.getChildren("option")) {
                if (!Comparing.strEqual((String)((Element)o).getAttributeValue(NAME), (String)"USE_PROJECT_LEVEL_SETTINGS")) continue;
                toConvert = Boolean.parseBoolean(((Element)o).getAttributeValue("value"));
                break;
            }
            if (toConvert) {
                this.convert(element);
            }
        }
    }

    protected void convert(Element element) throws InvalidDataException {
    }

    public void writeExternal(Element element) throws WriteExternalException {
        ArrayList<String> sortedProfiles = new ArrayList<String>(this.myProfiles.keySet());
        Element profiles = null;
        Collections.sort(sortedProfiles);
        for (String profile : sortedProfiles) {
            boolean hasSmthToSave;
            Profile projectProfile = this.myProfiles.get(profile);
            if (projectProfile == null) continue;
            Element profileElement = new Element(PROFILE);
            projectProfile.writeExternal(profileElement);
            boolean bl = hasSmthToSave = sortedProfiles.size() > 1 || !Comparing.strEqual((String)this.PROJECT_PROFILE, (String)PROJECT_DEFAULT_PROFILE_NAME);
            if (!hasSmthToSave) {
                for (Object child : profileElement.getChildren()) {
                    if (((Element)child).getName().equals("option")) continue;
                    hasSmthToSave = true;
                    break;
                }
            }
            if (!hasSmthToSave) continue;
            if (profiles == null) {
                profiles = new Element(PROFILES);
                element.addContent(profiles);
            }
            profiles.addContent(profileElement);
        }
        if (profiles != null) {
            DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
            Element version = new Element("version");
            version.setAttribute("value", VERSION);
            element.addContent(version);
        }
    }

    @Override
    public NamedScopesHolder getScopesManager() {
        return this.myHolder;
    }

    @Override
    public String getProfileType() {
        return this.myProfileType;
    }

    @Override
    public Collection<Profile> getProfiles() {
        this.getProjectProfileImpl();
        return this.myProfiles.values();
    }

    @Override
    public String[] getAvailableProfileNames() {
        return ArrayUtil.toStringArray(this.myProfiles.keySet());
    }

    @Override
    public void deleteProfile(String name) {
        this.myProfiles.remove(name);
    }

    @Override
    public String getProjectProfile() {
        return this.PROJECT_PROFILE;
    }

    @Override
    public void setProjectProfile(String projectProfile) {
        String profileName = this.PROJECT_PROFILE;
        this.PROJECT_PROFILE = projectProfile;
        this.USE_PROJECT_PROFILE = projectProfile != null;
        for (ProfileChangeAdapter adapter : this.myProfilesListener) {
            adapter.profileActivated(profileName != null ? this.getProfile(profileName) : null, projectProfile != null ? this.getProfile(projectProfile) : null);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Profile getProjectProfileImpl() {
        Profile profile;
        if (DefaultProjectProfileManager.isPlatform() || !this.USE_PROJECT_PROFILE) {
            profile = this.myApplicationProfileManager.getRootProfile();
            if (profile == null) throw new IllegalStateException("@NotNull method com/intellij/profile/DefaultProjectProfileManager.getProjectProfileImpl must not return null");
            return profile;
        }
        if (this.PROJECT_PROFILE == null || this.myProfiles.isEmpty()) {
            this.setProjectProfile(PROJECT_DEFAULT_PROFILE_NAME);
            Profile projectProfile = this.myApplicationProfileManager.createProfile();
            projectProfile.copyFrom(this.myApplicationProfileManager.getRootProfile());
            projectProfile.setLocal(false);
            projectProfile.setName(PROJECT_DEFAULT_PROFILE_NAME);
            this.myProfiles.put(PROJECT_DEFAULT_PROFILE_NAME, projectProfile);
        } else if (!this.myProfiles.containsKey(this.PROJECT_PROFILE)) {
            String projectProfileAttempt = this.myProfiles.keySet().iterator().next();
            this.setProjectProfile(projectProfileAttempt);
        }
        Profile profile2 = this.myProfiles.get(this.PROJECT_PROFILE);
        profile2.setProfileManager(this);
        profile = profile2;
        if (profile != null) return profile;
        throw new IllegalStateException("@NotNull method com/intellij/profile/DefaultProjectProfileManager.getProjectProfileImpl must not return null");
    }

    private static boolean isPlatform() {
        return !ApplicationNamesInfo.getInstance().getLowercaseProductName().equals("Idea");
    }

    public void addProfilesListener(ProfileChangeAdapter profilesListener) {
        this.myProfilesListener.add(profilesListener);
    }

    public void removeProfilesListener(ProfileChangeAdapter profilesListener) {
        this.myProfilesListener.remove(profilesListener);
    }

    public static class ProfileStateSplitter
    implements StateSplitter {
        @Override
        public List<Pair<Element, String>> splitState(Element e) {
            Element[] elements;
            UniqueNameGenerator generator = new UniqueNameGenerator();
            ArrayList<Pair<Element, String>> result = new ArrayList<Pair<Element, String>>();
            for (Element element : elements = JDOMUtil.getElements((Element)e)) {
                Element[] profiles;
                if (!element.getName().equals(DefaultProjectProfileManager.PROFILES)) continue;
                element.detach();
                for (Element profile : profiles = JDOMUtil.getElements((Element)element)) {
                    Element[] options;
                    String profileName = null;
                    for (Element option : options = JDOMUtil.getElements((Element)profile)) {
                        if (!option.getName().equals("option") || !option.getAttributeValue(DefaultProjectProfileManager.NAME).equals("myName")) continue;
                        profileName = option.getAttributeValue("value");
                    }
                    assert (profileName != null);
                    String name = generator.generateUniqueName(FileUtil.sanitizeFileName(profileName)) + ".xml";
                    result.add((Pair<Element, String>)new Pair((Object)profile, (Object)name));
                }
            }
            if (!e.getContent().isEmpty()) {
                result.add((Pair<Element, String>)new Pair((Object)e, (Object)(generator.generateUniqueName("profiles_settings") + ".xml")));
            }
            return result;
        }

        @Override
        public void mergeStatesInto(Element target, Element[] elements) {
            Element profiles = new Element(DefaultProjectProfileManager.PROFILES);
            target.addContent(profiles);
            for (Element element : elements) {
                Element[] states;
                if (element.getName().equals(DefaultProjectProfileManager.PROFILE)) {
                    element.detach();
                    profiles.addContent(element);
                    continue;
                }
                for (Element state : states = JDOMUtil.getElements((Element)element)) {
                    state.detach();
                    target.addContent(state);
                }
            }
        }
    }
}

