/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;

public class NonClasspathDirectoryScope
extends GlobalSearchScope {
    private final VirtualFile myRoot;

    public NonClasspathDirectoryScope(@NotNull VirtualFile root) {
        if (root == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/NonClasspathDirectoryScope.<init> must not be null");
        }
        this.myRoot = root;
    }

    @Override
    public boolean contains(VirtualFile file) {
        return VfsUtil.isAncestor(this.myRoot, file, false);
    }

    @Override
    public int compare(VirtualFile file1, VirtualFile file2) {
        return 0;
    }

    @Override
    public boolean isSearchInModuleContent(@NotNull Module aModule) {
        if (aModule == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/NonClasspathDirectoryScope.isSearchInModuleContent must not be null");
        }
        return false;
    }

    @Override
    public boolean isSearchInLibraries() {
        return false;
    }
}

