/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.search.EverythingGlobalScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectAndLibrariesScope;
import org.jetbrains.annotations.NotNull;

public class ProjectScope {
    private static final Key<GlobalSearchScope> ALL_SCOPE_KEY = new Key("ALL_SCOPE_KEY");
    private static final Key<GlobalSearchScope> PROJECT_SCOPE_KEY = new Key("PROJECT_SCOPE_KEY");

    private ProjectScope() {
    }

    public static GlobalSearchScope getAllScope(Project project) {
        GlobalSearchScope allScope = (GlobalSearchScope)project.getUserData(ALL_SCOPE_KEY);
        if (allScope == null) {
            ProjectRootManager projectRootManager = ProjectRootManager.getInstance(project);
            allScope = projectRootManager == null ? new EverythingGlobalScope(project) : new ProjectAndLibrariesScope(project);
            allScope = (GlobalSearchScope)((UserDataHolderEx)project).putUserDataIfAbsent(ALL_SCOPE_KEY, (Object)allScope);
        }
        return allScope;
    }

    public static GlobalSearchScope getProjectScope(Project project) {
        GlobalSearchScope projectScope = (GlobalSearchScope)project.getUserData(PROJECT_SCOPE_KEY);
        if (projectScope == null) {
            final ProjectRootManager projectRootManager = ProjectRootManager.getInstance(project);
            projectScope = projectRootManager == null ? new EverythingGlobalScope(project){

                @Override
                public boolean isSearchInLibraries() {
                    return false;
                }
            } : new GlobalSearchScope(project){
                private final ProjectFileIndex myFileIndex;
                {
                    super(x0);
                    this.myFileIndex = projectRootManager.getFileIndex();
                }

                @Override
                public boolean contains(VirtualFile file) {
                    if (file instanceof VirtualFileWindow) {
                        return true;
                    }
                    if (this.myFileIndex.isInLibraryClasses(file) && !this.myFileIndex.isInSourceContent(file)) {
                        return false;
                    }
                    return this.myFileIndex.isInContent(file);
                }

                @Override
                public int compare(VirtualFile file1, VirtualFile file2) {
                    return 0;
                }

                @Override
                public boolean isSearchInModuleContent(@NotNull Module aModule) {
                    if (aModule == null) {
                        throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/ProjectScope$2.isSearchInModuleContent must not be null");
                    }
                    return true;
                }

                @Override
                public boolean isSearchInLibraries() {
                    return false;
                }

                @Override
                public String getDisplayName() {
                    return PsiBundle.message("psi.search.scope.project", new Object[0]);
                }

                public String toString() {
                    return this.getDisplayName();
                }

                @Override
                public GlobalSearchScope uniteWith(@NotNull GlobalSearchScope scope) {
                    if (scope == null) {
                        throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/ProjectScope$2.uniteWith must not be null");
                    }
                    if (scope == this || !scope.isSearchInLibraries()) {
                        return this;
                    }
                    return super.uniteWith(scope);
                }

                /*
                 * Enabled aggressive block sorting
                 */
                @Override
                @NotNull
                public GlobalSearchScope intersectWith(@NotNull GlobalSearchScope scope) {
                    GlobalSearchScope globalSearchScope;
                    if (scope == null) {
                        throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/ProjectScope$2.intersectWith must not be null");
                    }
                    if (scope == this) {
                        globalSearchScope = this;
                        if (globalSearchScope == null) throw new IllegalStateException("@NotNull method com/intellij/psi/search/ProjectScope$2.intersectWith must not return null");
                        return globalSearchScope;
                    }
                    if (!scope.isSearchInLibraries()) {
                        globalSearchScope = scope;
                        if (globalSearchScope == null) throw new IllegalStateException("@NotNull method com/intellij/psi/search/ProjectScope$2.intersectWith must not return null");
                        return globalSearchScope;
                    }
                    globalSearchScope = super.intersectWith(scope);
                    if (globalSearchScope != null) return globalSearchScope;
                    throw new IllegalStateException("@NotNull method com/intellij/psi/search/ProjectScope$2.intersectWith must not return null");
                }
            };
            projectScope = (GlobalSearchScope)((UserDataHolderEx)project).putUserDataIfAbsent(PROJECT_SCOPE_KEY, (Object)projectScope);
        }
        return projectScope;
    }
}

