/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.scope.packageSet;

import com.intellij.psi.PsiFile;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import org.jetbrains.annotations.NotNull;

public class UnionPackageSet
implements PackageSet {
    private final PackageSet myFirstSet;
    private final PackageSet mySecondSet;

    public UnionPackageSet(@NotNull PackageSet set1, @NotNull PackageSet set2) {
        if (set1 == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/search/scope/packageSet/UnionPackageSet.<init> must not be null");
        }
        if (set2 == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/search/scope/packageSet/UnionPackageSet.<init> must not be null");
        }
        this.myFirstSet = set1;
        this.mySecondSet = set2;
    }

    @Override
    public boolean contains(PsiFile file, NamedScopesHolder holder) {
        return this.myFirstSet.contains(file, holder) || this.mySecondSet.contains(file, holder);
    }

    @Override
    public PackageSet createCopy() {
        return new UnionPackageSet(this.myFirstSet.createCopy(), this.mySecondSet.createCopy());
    }

    @Override
    public int getNodePriority() {
        return 3;
    }

    @Override
    public String getText() {
        return this.myFirstSet.getText() + "||" + this.mySecondSet.getText();
    }
}

