/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.statistics;

import com.intellij.psi.statistics.StatisticsManager;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class StatisticsInfo
implements Comparable<StatisticsInfo> {
    public static final StatisticsInfo EMPTY = new StatisticsInfo("empty", "empty");
    private static final StatisticsManager ourManager = StatisticsManager.getInstance();
    private final String myContext;
    private final String myValue;

    public StatisticsInfo(@NonNls @NotNull String context, @NonNls @NotNull String value) {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/statistics/StatisticsInfo.<init> must not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/statistics/StatisticsInfo.<init> must not be null");
        }
        this.myContext = context;
        this.myValue = value;
    }

    @NotNull
    public String getContext() {
        String string = this.myContext;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/statistics/StatisticsInfo.getContext must not return null");
        }
        return string;
    }

    @NotNull
    public String getValue() {
        String string = this.myValue;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/statistics/StatisticsInfo.getValue must not return null");
        }
        return string;
    }

    @Override
    public int compareTo(StatisticsInfo o) {
        return this.getUseCount() - o.getUseCount();
    }

    public void incUseCount() {
        ourManager.incUseCount(this);
    }

    public int getUseCount() {
        return ourManager.getUseCount(this);
    }

    public String toString() {
        return this.myContext + "::::" + this.myValue;
    }
}

