/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveState;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiUtilBase {
    public static final PsiElement NULL_PSI_ELEMENT = new PsiElement(){

        @Override
        @NotNull
        public Project getProject() {
            throw new PsiInvalidElementAccessException(this);
        }

        @Override
        @NotNull
        public Language getLanguage() {
            throw new IllegalAccessError();
        }

        @Override
        public PsiManager getManager() {
            return null;
        }

        @Override
        @NotNull
        public PsiElement[] getChildren() {
            PsiElement[] psiElementArray = new PsiElement[]{};
            if (psiElementArray == null) {
                throw new IllegalStateException("@NotNull method com/intellij/psi/util/PsiUtilBase$1.getChildren must not return null");
            }
            return psiElementArray;
        }

        @Override
        public PsiElement getParent() {
            return null;
        }

        @Override
        @Nullable
        public PsiElement getFirstChild() {
            return null;
        }

        @Override
        @Nullable
        public PsiElement getLastChild() {
            return null;
        }

        @Override
        @Nullable
        public PsiElement getNextSibling() {
            return null;
        }

        @Override
        @Nullable
        public PsiElement getPrevSibling() {
            return null;
        }

        @Override
        public PsiFile getContainingFile() {
            throw new PsiInvalidElementAccessException(this);
        }

        @Override
        public TextRange getTextRange() {
            return null;
        }

        @Override
        public int getStartOffsetInParent() {
            return 0;
        }

        @Override
        public int getTextLength() {
            return 0;
        }

        @Override
        public PsiElement findElementAt(int offset) {
            return null;
        }

        @Override
        @Nullable
        public PsiReference findReferenceAt(int offset) {
            return null;
        }

        @Override
        public int getTextOffset() {
            return 0;
        }

        @Override
        public String getText() {
            return null;
        }

        @Override
        @NotNull
        public char[] textToCharArray() {
            char[] cArray = new char[]{};
            if (cArray == null) {
                throw new IllegalStateException("@NotNull method com/intellij/psi/util/PsiUtilBase$1.textToCharArray must not return null");
            }
            return cArray;
        }

        @Override
        public PsiElement getNavigationElement() {
            return null;
        }

        @Override
        public PsiElement getOriginalElement() {
            return null;
        }

        @Override
        public boolean textMatches(@NotNull CharSequence text) {
            if (text == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiUtilBase$1.textMatches must not be null");
            }
            return false;
        }

        @Override
        public boolean textMatches(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiUtilBase$1.textMatches must not be null");
            }
            return false;
        }

        @Override
        public boolean textContains(char c) {
            return false;
        }

        @Override
        public void accept(@NotNull PsiElementVisitor visitor) {
            if (visitor == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiUtilBase$1.accept must not be null");
            }
        }

        @Override
        public void acceptChildren(@NotNull PsiElementVisitor visitor) {
            if (visitor == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiUtilBase$1.acceptChildren must not be null");
            }
        }

        @Override
        public PsiElement copy() {
            return null;
        }

        @Override
        public PsiElement add(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiUtilBase$1.add must not be null");
            }
            return null;
        }

        @Override
        public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) {
            if (element == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiUtilBase$1.addBefore must not be null");
            }
            return null;
        }

        @Override
        public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor) {
            if (element == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiUtilBase$1.addAfter must not be null");
            }
            return null;
        }

        @Override
        public void checkAdd(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiUtilBase$1.checkAdd must not be null");
            }
        }

        @Override
        public PsiElement addRange(PsiElement first, PsiElement last) {
            return null;
        }

        @Override
        public PsiElement addRangeBefore(@NotNull PsiElement first, @NotNull PsiElement last, PsiElement anchor) {
            if (first == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiUtilBase$1.addRangeBefore must not be null");
            }
            if (last == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/util/PsiUtilBase$1.addRangeBefore must not be null");
            }
            return null;
        }

        @Override
        public PsiElement addRangeAfter(PsiElement first, PsiElement last, PsiElement anchor) {
            return null;
        }

        @Override
        public void delete() {
        }

        @Override
        public void checkDelete() {
        }

        @Override
        public void deleteChildRange(PsiElement first, PsiElement last) {
        }

        @Override
        public PsiElement replace(@NotNull PsiElement newElement) {
            if (newElement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiUtilBase$1.replace must not be null");
            }
            return null;
        }

        @Override
        public boolean isValid() {
            return false;
        }

        @Override
        public boolean isWritable() {
            return false;
        }

        @Override
        @Nullable
        public PsiReference getReference() {
            return null;
        }

        @Override
        @NotNull
        public PsiReference[] getReferences() {
            PsiReference[] psiReferenceArray = new PsiReference[]{};
            if (psiReferenceArray == null) {
                throw new IllegalStateException("@NotNull method com/intellij/psi/util/PsiUtilBase$1.getReferences must not return null");
            }
            return psiReferenceArray;
        }

        @Override
        public <T> T getCopyableUserData(Key<T> key) {
            return null;
        }

        @Override
        public <T> void putCopyableUserData(Key<T> key, T value) {
        }

        @Override
        public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
            if (processor == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiUtilBase$1.processDeclarations must not be null");
            }
            if (state == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/util/PsiUtilBase$1.processDeclarations must not be null");
            }
            if (place == null) {
                throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/util/PsiUtilBase$1.processDeclarations must not be null");
            }
            return false;
        }

        @Override
        public PsiElement getContext() {
            return null;
        }

        @Override
        public boolean isPhysical() {
            return false;
        }

        @Override
        @NotNull
        public GlobalSearchScope getResolveScope() {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.EMPTY_SCOPE;
            if (globalSearchScope == null) {
                throw new IllegalStateException("@NotNull method com/intellij/psi/util/PsiUtilBase$1.getResolveScope must not return null");
            }
            return globalSearchScope;
        }

        @Override
        @NotNull
        public SearchScope getUseScope() {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.EMPTY_SCOPE;
            if (globalSearchScope == null) {
                throw new IllegalStateException("@NotNull method com/intellij/psi/util/PsiUtilBase$1.getUseScope must not return null");
            }
            return globalSearchScope;
        }

        @Override
        public ASTNode getNode() {
            return null;
        }

        public <T> T getUserData(@NotNull Key<T> key) {
            if (key == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiUtilBase$1.getUserData must not be null");
            }
            return null;
        }

        public <T> void putUserData(@NotNull Key<T> key, T value) {
            if (key == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiUtilBase$1.putUserData must not be null");
            }
        }

        @Override
        public Icon getIcon(int flags) {
            return null;
        }

        @Override
        public boolean isEquivalentTo(PsiElement another) {
            return this == another;
        }
    };
    public static final PsiParser NULL_PARSER = new PsiParser(){

        @Override
        @NotNull
        public ASTNode parse(IElementType root, PsiBuilder builder) {
            throw new IllegalAccessError();
        }
    };

    public static int getRootIndex(PsiElement root) {
        ASTNode node;
        for (node = root.getNode(); node != null && node.getTreeParent() != null; node = node.getTreeParent()) {
        }
        if (node != null) {
            root = node.getPsi();
        }
        PsiFile containingFile = root.getContainingFile();
        PsiFile[] psiRoots = containingFile.getPsiRoots();
        for (int i = 0; i < psiRoots.length; ++i) {
            if (root != psiRoots[i]) continue;
            return i;
        }
        throw new RuntimeException("invalid element");
    }

    @Nullable
    public static VirtualFile getVirtualFile(@Nullable PsiElement element) {
        if (element == null || !element.isValid()) {
            return null;
        }
        if (element instanceof PsiFileSystemItem) {
            return ((PsiFileSystemItem)element).getVirtualFile();
        }
        PsiFile containingFile = element.getContainingFile();
        if (containingFile == null) {
            return null;
        }
        return containingFile.getVirtualFile();
    }

    public static int compareElementsByPosition(PsiElement element1, PsiElement element2) {
        if (element1 != null && element2 != null) {
            PsiFile psiFile2;
            PsiFile psiFile1 = element1.getContainingFile();
            if (Comparing.equal((Object)psiFile1, (Object)(psiFile2 = element2.getContainingFile()))) {
                TextRange textRange1 = element1.getTextRange();
                TextRange textRange2 = element2.getTextRange();
                if (textRange1 != null && textRange2 != null) {
                    return textRange1.getStartOffset() - textRange2.getStartOffset();
                }
            } else if (psiFile1 != null && psiFile2 != null) {
                String name1 = psiFile1.getName();
                String name2 = psiFile2.getName();
                return name1.compareToIgnoreCase(name2);
            }
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static Language getLanguageAtOffset(@NotNull PsiFile file, int offset) {
        int decremented;
        Language language;
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiUtilBase.getLanguageAtOffset must not be null");
        }
        PsiElement elt = file.findElementAt(offset);
        if (elt == null) {
            language = file.getLanguage();
            if (language == null) throw new IllegalStateException("@NotNull method com/intellij/psi/util/PsiUtilBase.getLanguageAtOffset must not return null");
            return language;
        }
        if (elt instanceof PsiWhiteSpace && (decremented = elt.getTextRange().getStartOffset() - 1) >= 0) {
            language = PsiUtilBase.getLanguageAtOffset(file, decremented);
            if (language == null) throw new IllegalStateException("@NotNull method com/intellij/psi/util/PsiUtilBase.getLanguageAtOffset must not return null");
            return language;
        }
        language = PsiUtilBase.findLanguageFromElement(elt);
        if (language != null) return language;
        throw new IllegalStateException("@NotNull method com/intellij/psi/util/PsiUtilBase.getLanguageAtOffset must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static Language findLanguageFromElement(PsiElement elt) {
        Language language;
        PsiElement parent;
        if (elt.getFirstChild() == null && (parent = elt.getParent()) != null) {
            language = parent.getLanguage();
            if (language == null) throw new IllegalStateException("@NotNull method com/intellij/psi/util/PsiUtilBase.findLanguageFromElement must not return null");
            return language;
        }
        language = elt.getLanguage();
        if (language != null) return language;
        throw new IllegalStateException("@NotNull method com/intellij/psi/util/PsiUtilBase.findLanguageFromElement must not return null");
    }

    @Nullable
    public static PsiFile getTemplateLanguageFile(PsiElement element) {
        if (element == null) {
            return null;
        }
        PsiFile containingFile = element.getContainingFile();
        if (containingFile == null) {
            return null;
        }
        FileViewProvider viewProvider = containingFile.getViewProvider();
        return viewProvider.getPsi(viewProvider.getBaseLanguage());
    }

    @Nullable
    public static String getName(PsiElement element) {
        PsiMetaData data;
        String name = null;
        if (element instanceof PsiMetaOwner && (data = ((PsiMetaOwner)((Object)element)).getMetaData()) != null) {
            name = data.getName(element);
        }
        if (name == null && element instanceof PsiNamedElement) {
            name = ((PsiNamedElement)element).getName();
        }
        return name;
    }

    public static boolean isUnderPsiRoot(PsiFile root, PsiElement element) {
        PsiFile containingFile = element.getContainingFile();
        if (containingFile == root) {
            return true;
        }
        for (PsiFile psiRoot : root.getPsiRoots()) {
            if (containingFile != psiRoot) continue;
            return true;
        }
        PsiLanguageInjectionHost host = InjectedLanguageManager.getInstance(root.getProject()).getInjectionHost(element);
        return host != null && PsiUtilBase.isUnderPsiRoot(root, host);
    }

    @Nullable
    public static <T extends PsiElement> T getOriginalElement(@NotNull T psiElement, Class<? extends T> elementClass) {
        T parent;
        if (psiElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiUtilBase.getOriginalElement must not be null");
        }
        PsiFile psiFile = psiElement.getContainingFile();
        PsiFile originalFile = psiFile.getOriginalFile();
        if (originalFile == psiFile) {
            return psiElement;
        }
        TextRange range = psiElement.getTextRange();
        PsiElement element = originalFile.findElementAt(range.getStartOffset());
        int maxLength = range.getLength();
        T next = parent = PsiTreeUtil.getParentOfType(element, elementClass, false);
        while (next != null && next.getTextLength() <= maxLength) {
            parent = next;
            next = PsiTreeUtil.getParentOfType(next, elementClass, true);
        }
        return parent;
    }

    @Nullable
    public static Language getLanguageInEditor(@NotNull Editor editor, @NotNull Project project) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiUtilBase.getLanguageInEditor must not be null");
        }
        if (project == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/util/PsiUtilBase.getLanguageInEditor must not be null");
        }
        PsiFile file = PsiDocumentManager.getInstance(project).getPsiFile(editor.getDocument());
        if (file == null) {
            return null;
        }
        SelectionModel selectionModel = editor.getSelectionModel();
        int caretOffset = editor.getCaretModel().getOffset();
        int mostProbablyCorrectLanguageOffset = caretOffset == selectionModel.getSelectionStart() || caretOffset == selectionModel.getSelectionEnd() ? selectionModel.getSelectionStart() : caretOffset;
        PsiElement elt = PsiUtilBase.getElementAtOffset(file, mostProbablyCorrectLanguageOffset);
        Language lang = PsiUtilBase.findLanguageFromElement(elt);
        if (selectionModel.hasSelection()) {
            Language rangeLanguage = PsiUtilBase.evaluateLanguageInRange(selectionModel.getSelectionStart(), selectionModel.getSelectionEnd(), file);
            if (rangeLanguage == null) {
                return file.getLanguage();
            }
            lang = rangeLanguage;
        }
        return PsiUtilBase.narrowLanguage(lang, file.getLanguage());
    }

    public static Language getDialect(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiUtilBase.getDialect must not be null");
        }
        return PsiUtilBase.narrowLanguage(element.getLanguage(), element.getContainingFile().getLanguage());
    }

    private static Language narrowLanguage(Language language, Language candidate) {
        if (candidate.isKindOf(language)) {
            return candidate;
        }
        return language;
    }

    @Nullable
    public static PsiFile getPsiFileInEditor(Editor editor, Project project) {
        PsiFile file = PsiDocumentManager.getInstance(project).getPsiFile(editor.getDocument());
        if (file == null) {
            return null;
        }
        Language language = PsiUtilBase.getLanguageInEditor(editor, project);
        if (language == null) {
            return file;
        }
        if (language == file.getLanguage()) {
            return file;
        }
        SelectionModel selectionModel = editor.getSelectionModel();
        int caretOffset = editor.getCaretModel().getOffset();
        int mostProbablyCorrectLanguageOffset = caretOffset == selectionModel.getSelectionStart() || caretOffset == selectionModel.getSelectionEnd() ? selectionModel.getSelectionStart() : caretOffset;
        return PsiUtilBase.getPsiFileAtOffset(file, mostProbablyCorrectLanguageOffset);
    }

    public static PsiFile getPsiFileAtOffset(PsiFile file, int offset) {
        PsiElement elt = PsiUtilBase.getElementAtOffset(file, offset);
        assert (elt.isValid()) : elt + "; file: " + file + "; isvalid: " + file.isValid();
        return elt.getContainingFile();
    }

    @Nullable
    public static Language reallyEvaluateLanguageInRange(int start, int end, PsiFile file) {
        PsiElement elt;
        int endOffset;
        Language lang = null;
        int curOffset = start;
        do {
            if ((elt = PsiUtilBase.getElementAtOffset(file, curOffset)) instanceof PsiWhiteSpace) continue;
            Language language = PsiUtilBase.findLanguageFromElement(elt);
            if (lang == null) {
                lang = language;
                continue;
            }
            if (lang == language) continue;
            return null;
        } while ((curOffset = (endOffset = elt.getTextRange().getEndOffset()) <= curOffset ? curOffset + 1 : endOffset) < end);
        return PsiUtilBase.narrowLanguage(lang, file.getLanguage());
    }

    @Nullable
    public static Language evaluateLanguageInRange(int start, int end, PsiFile file) {
        PsiElement elt = PsiUtilBase.getElementAtOffset(file, start);
        TextRange selectionRange = new TextRange(start, end);
        if (!(elt instanceof PsiFile)) {
            elt = elt.getParent();
            TextRange range = elt.getTextRange();
            assert (range != null) : "Range is null for " + elt + "; " + elt.getClass();
            while (!range.contains(selectionRange) && !(elt instanceof PsiFile) && (elt = elt.getParent()) != null) {
                range = elt.getTextRange();
                assert (range != null) : "Range is null for " + elt + "; " + elt.getClass();
            }
            if (elt != null) {
                return elt.getLanguage();
            }
        }
        return PsiUtilBase.reallyEvaluateLanguageInRange(start, end, file);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static PsiElement getElementAtOffset(@NotNull PsiFile file, int offset) {
        PsiElement psiElement;
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiUtilBase.getElementAtOffset must not be null");
        }
        PsiElement elt = file.findElementAt(offset);
        if (elt == null && offset > 0) {
            elt = file.findElementAt(offset - 1);
        }
        if (elt == null) {
            psiElement = file;
            if (psiElement == null) throw new IllegalStateException("@NotNull method com/intellij/psi/util/PsiUtilBase.getElementAtOffset must not return null");
            return psiElement;
        }
        psiElement = elt;
        if (psiElement != null) return psiElement;
        throw new IllegalStateException("@NotNull method com/intellij/psi/util/PsiUtilBase.getElementAtOffset must not return null");
    }

    public static <T extends PsiElement> T copyElementPreservingOriginalLinks(T element, final Key<PsiElement> originalKey) {
        PsiRecursiveElementWalkingVisitor originalVisitor = new PsiRecursiveElementWalkingVisitor(){

            @Override
            public void visitElement(PsiElement element) {
                element.putCopyableUserData(originalKey, element);
                super.visitElement(element);
            }
        };
        ((PsiElementVisitor)originalVisitor).visitElement(element);
        PsiElement fileCopy = element.copy();
        PsiRecursiveElementWalkingVisitor copyVisitor = new PsiRecursiveElementWalkingVisitor(){

            @Override
            public void visitElement(PsiElement element) {
                PsiElement originalElement = (PsiElement)element.getCopyableUserData(originalKey);
                if (originalElement != null) {
                    originalElement.putCopyableUserData(originalKey, null);
                    element.putCopyableUserData(originalKey, null);
                    element.putUserData(originalKey, originalElement);
                }
                super.visitElement(element);
            }
        };
        ((PsiElementVisitor)copyVisitor).visitElement(fileCopy);
        return (T)fileCopy;
    }

    public static boolean hasErrorElementChild(PsiElement element) {
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof PsiErrorElement)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static ASTNode getRoot(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiUtilBase.getRoot must not be null");
        }
        ASTNode child = node;
        while (true) {
            ASTNode parent;
            if ((parent = child.getTreeParent()) == null) {
                ASTNode aSTNode = child;
                if (aSTNode == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/psi/util/PsiUtilBase.getRoot must not return null");
                }
                return aSTNode;
            }
            child = parent;
        }
    }

    public static int findInjectedElementOffsetInRealDocument(final PsiElement element) {
        final PsiFile containingFile = element.getContainingFile();
        if (containingFile == null) {
            return -1;
        }
        Document document = PsiDocumentManager.getInstance(containingFile.getProject()).getDocument(containingFile);
        if (document instanceof DocumentWindow && !((DocumentWindow)document).isValid()) {
            return -1;
        }
        PsiElement context = containingFile.getContext();
        if (!(context instanceof PsiLanguageInjectionHost)) {
            return 0;
        }
        final int[] result = new int[1];
        ((PsiLanguageInjectionHost)context).processInjectedPsi(new PsiLanguageInjectionHost.InjectedPsiVisitor(){

            @Override
            public void visit(@NotNull PsiFile injectedPsi, @NotNull List<PsiLanguageInjectionHost.Shred> places) {
                int injectedStart;
                if (injectedPsi == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/util/PsiUtilBase$5.visit must not be null");
                }
                if (places == null) {
                    throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/util/PsiUtilBase$5.visit must not be null");
                }
                if (injectedPsi != containingFile) {
                    return;
                }
                PsiLanguageInjectionHost.Shred shred = places.get(0);
                TextRange textRange = element.getTextRange();
                if (shred.prefix != null && textRange.getEndOffset() < shred.prefix.length()) {
                    result[0] = -1;
                    return;
                }
                result[0] = injectedStart = shred.getRangeInsideHost().getStartOffset() + shred.host.getTextRange().getStartOffset() - (shred.prefix != null ? shred.prefix.length() : 0);
            }
        });
        return result[0];
    }

    public static Language getNotAnyLanguage(ASTNode node) {
        if (node == null) {
            return Language.ANY;
        }
        Language lang = node.getElementType().getLanguage();
        return lang == Language.ANY ? PsiUtilBase.getNotAnyLanguage(node.getTreeParent()) : lang;
    }
}

