/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.patterns.ElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.rename.RenameInputValidator;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenameInputValidatorRegistry {
    private static final RenameInputValidatorRegistry ourInstance = new RenameInputValidatorRegistry();
    private final List<Pair<ElementPattern<? extends PsiElement>, RenameInputValidator>> myValidators = new ArrayList<Pair<ElementPattern<? extends PsiElement>, RenameInputValidator>>();

    public static RenameInputValidatorRegistry getInstance() {
        return ourInstance;
    }

    private RenameInputValidatorRegistry() {
    }

    public void registerInputValidator(@NotNull ElementPattern<? extends PsiElement> pattern, @NotNull RenameInputValidator validator) {
        if (pattern == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/rename/RenameInputValidatorRegistry.registerInputValidator must not be null");
        }
        if (validator == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/refactoring/rename/RenameInputValidatorRegistry.registerInputValidator must not be null");
        }
        this.myValidators.add((Pair<ElementPattern<? extends PsiElement>, RenameInputValidator>)Pair.create(pattern, (Object)validator));
    }

    @Nullable
    public Condition<String> getInputValidator(final PsiElement element) {
        for (final Pair<ElementPattern<? extends PsiElement>, RenameInputValidator> pair : this.myValidators) {
            final ProcessingContext context = new ProcessingContext();
            if (!((ElementPattern)pair.first).accepts(element, context)) continue;
            return new Condition<String>(){

                public boolean value(String s) {
                    return ((RenameInputValidator)pair.getSecond()).isInputValid(s, element, context);
                }
            };
        }
        return null;
    }
}

