/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.UIBundle;

public abstract class AutoScrollFromSourceHandler
implements Disposable {
    protected final Project myProject;

    protected AutoScrollFromSourceHandler(Project project) {
        this(project, null);
    }

    protected AutoScrollFromSourceHandler(Project project, Disposable parentDisposable) {
        this.myProject = project;
        if (parentDisposable != null) {
            Disposer.register((Disposable)parentDisposable, (Disposable)this);
        }
    }

    protected abstract boolean isAutoScrollMode();

    protected abstract void setAutoScrollMode(boolean var1);

    public abstract void install();

    public ToggleAction createToggleAction() {
        return new AutoScrollFromSourceAction();
    }

    private class AutoScrollFromSourceAction
    extends ToggleAction
    implements DumbAware {
        public AutoScrollFromSourceAction() {
            super(UIBundle.message((String)"autoscroll.from.source.action.name", (Object[])new Object[0]), UIBundle.message((String)"autoscroll.from.source.action.description", (Object[])new Object[0]), IconLoader.getIcon((String)"/general/autoscrollFromSource.png"));
        }

        @Override
        public boolean isSelected(AnActionEvent event) {
            return AutoScrollFromSourceHandler.this.isAutoScrollMode();
        }

        @Override
        public void setSelected(AnActionEvent event, boolean flag) {
            AutoScrollFromSourceHandler.this.setAutoScrollMode(flag);
        }
    }
}

