/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.ui.LafManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.DocumentListener;

public class SearchTextField
extends JPanel {
    private int myHistorySize = 5;
    private final MyModel myModel = new MyModel();
    private final TextFieldWithProcessing myTextField = new TextFieldWithProcessing(){

        @Override
        public void processKeyEvent(KeyEvent e) {
            if (SearchTextField.this.preprocessEventForTextField(e)) {
                return;
            }
            super.processKeyEvent(e);
        }

        @Override
        public void setBackground(Color bg) {
            super.setBackground(bg);
            if (SearchTextField.this.myClearFieldLabel != null) {
                SearchTextField.this.myClearFieldLabel.setBackground(bg);
            }
            if (SearchTextField.this.myToggleHistoryLabel != null) {
                SearchTextField.this.myToggleHistoryLabel.setBackground(bg);
            }
        }
    };
    private JBPopup myPopup;
    private JLabel myClearFieldLabel;
    private JLabel myToggleHistoryLabel;
    private JPopupMenu myNativeSearchPopup;
    private KeyListener myListener = null;
    private JMenuItem myNoItems;

    public SearchTextField() {
        this(true);
    }

    public SearchTextField(boolean historyEnabled) {
        super(new BorderLayout());
        AnAction clearTextAction;
        ActionManager actionManager;
        this.myTextField.setColumns(15);
        this.add((Component)this.myTextField, "Center");
        if (SearchTextField.hasNativeLeopardSearchControl()) {
            this.myTextField.putClientProperty("JTextField.variant", "search");
            this.myNativeSearchPopup = new JPopupMenu();
            this.myNoItems = new JMenuItem("No recent searches");
            this.myNoItems.setEnabled(false);
            this.updateMenu();
            if (historyEnabled) {
                this.myTextField.putClientProperty("JTextField.Search.FindPopup", this.myNativeSearchPopup);
            }
        } else {
            this.myToggleHistoryLabel = new JLabel(IconLoader.getIcon((String)"/actions/search.png"));
            this.myToggleHistoryLabel.setOpaque(true);
            this.myToggleHistoryLabel.setBackground(this.myTextField.getBackground());
            this.myToggleHistoryLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    SearchTextField.this.togglePopup();
                }
            });
            if (historyEnabled) {
                this.add((Component)this.myToggleHistoryLabel, "West");
            }
            this.myClearFieldLabel = new JLabel(IconLoader.getIcon((String)"/actions/cleanLight.png"));
            this.myClearFieldLabel.setOpaque(true);
            this.myClearFieldLabel.setBackground(this.myTextField.getBackground());
            this.add((Component)this.myClearFieldLabel, "East");
            this.myClearFieldLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    SearchTextField.this.myTextField.setText("");
                }
            });
            Border originalBorder = SystemInfo.isMac ? BorderFactory.createLoweredBevelBorder() : this.myTextField.getBorder();
            this.setBorder(new CompoundBorder(IdeBorderFactory.createEmptyBorder(4, 0, 4, 0), originalBorder));
            this.myTextField.setOpaque(true);
            this.myTextField.setBorder(IdeBorderFactory.createEmptyBorder(0, 5, 0, 5));
        }
        if ((actionManager = ActionManager.getInstance()) != null && (clearTextAction = actionManager.getAction("TextComponent.ClearAction")).getShortcutSet().getShortcuts().length == 0) {
            clearTextAction.registerCustomShortcutSet(CommonShortcuts.ESCAPE, this);
        }
    }

    private void updateMenu() {
        if (this.myNativeSearchPopup != null) {
            this.myNativeSearchPopup.removeAll();
            int itemsCount = this.myModel.getSize();
            if (itemsCount == 0) {
                this.myNativeSearchPopup.add(this.myNoItems);
            } else {
                for (int i = 0; i < itemsCount; ++i) {
                    String item = (String)this.myModel.getElementAt(i);
                    this.addMenuItem(item);
                }
            }
        }
    }

    private static boolean hasNativeLeopardSearchControl() {
        return SystemInfo.isMacOSLeopard && LafManager.getInstance().isUnderAquaLookAndFeel();
    }

    public void addDocumentListener(DocumentListener listener) {
        this.getTextEditor().getDocument().addDocumentListener(listener);
    }

    public void removeDocumentListener(DocumentListener listener) {
        this.getTextEditor().getDocument().removeDocumentListener(listener);
    }

    public void addKeyboardListener(KeyListener listener) {
        this.getTextEditor().addKeyListener(listener);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.myToggleHistoryLabel != null) {
            Color bg = enabled ? UIUtil.getTextFieldBackground() : UIUtil.getPanelBackground();
            this.myToggleHistoryLabel.setBackground(bg);
            this.myClearFieldLabel.setBackground(bg);
        }
    }

    public void setHistorySize(int aHistorySize) {
        this.myHistorySize = aHistorySize;
    }

    public void setHistory(List<String> aHistory) {
        this.myModel.setItems(aHistory);
    }

    public List<String> getHistory() {
        int itemsCount = this.myModel.getSize();
        ArrayList<String> history = new ArrayList<String>(itemsCount);
        for (int i = 0; i < itemsCount; ++i) {
            history.add((String)this.myModel.getElementAt(i));
        }
        return history;
    }

    public void setText(String aText) {
        this.getTextEditor().setText(aText);
    }

    public String getText() {
        return this.getTextEditor().getText();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.hidePopup();
    }

    public void addCurrentTextToHistory() {
        String item = this.getText();
        this.myModel.addElement(item);
    }

    private void addMenuItem(final String item) {
        if (this.myNativeSearchPopup != null) {
            this.myNativeSearchPopup.remove(this.myNoItems);
            JMenuItem menuItem = new JMenuItem(item);
            this.myNativeSearchPopup.add(menuItem);
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SearchTextField.this.myTextField.setText(item);
                }
            });
        }
    }

    public void selectText() {
        this.getTextEditor().selectAll();
    }

    public JTextField getTextEditor() {
        return this.myTextField;
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.myTextField.requestFocusInWindow();
    }

    @Override
    public void requestFocus() {
        this.getTextEditor().requestFocus();
    }

    private void hidePopup() {
        if (this.myPopup != null) {
            this.myPopup.cancel();
            this.myPopup = null;
        }
    }

    private void showPopup() {
        if (this.myPopup == null) {
            final JList list = new JList(this.myModel);
            if (this.myListener != null) {
                this.removeKeyListener(this.myListener);
            }
            final Runnable chooseRunnable = new Runnable(){

                @Override
                public void run() {
                    String value = (String)list.getSelectedValue();
                    SearchTextField.this.getTextEditor().setText(value != null ? value : "");
                    if (SearchTextField.this.myPopup != null) {
                        SearchTextField.this.myPopup.cancel();
                        SearchTextField.this.myPopup = null;
                    }
                }
            };
            this.myListener = new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 40) {
                        if (list.getSelectedIndex() < list.getModel().getSize() - 1) {
                            list.setSelectedIndex(list.getSelectedIndex() + 1);
                        }
                    } else if (e.getKeyCode() == 38) {
                        if (list.getSelectedIndex() > 0) {
                            list.setSelectedIndex(list.getSelectedIndex() - 1);
                        }
                    } else if (e.getKeyCode() == 10 && list.getSelectedIndex() > -1) {
                        chooseRunnable.run();
                    }
                }
            };
            this.addKeyboardListener(this.myListener);
            this.myPopup = JBPopupFactory.getInstance().createListPopupBuilder(list).setMovable(false).setRequestFocus(false).setItemChoosenCallback(chooseRunnable).createPopup();
            if (this.isShowing()) {
                this.myPopup.showUnderneathOf(this);
            }
        }
    }

    private void togglePopup() {
        if (this.myPopup == null) {
            this.showPopup();
        } else {
            this.hidePopup();
        }
    }

    public void setSelectedItem(String s) {
        this.getTextEditor().setText(s);
    }

    public int getSelectedIndex() {
        return this.myModel.myFullList.indexOf(this.getText());
    }

    public final void keyEventToTextField(KeyEvent e) {
        this.myTextField.processKeyEvent(e);
    }

    protected boolean preprocessEventForTextField(KeyEvent e) {
        return false;
    }

    protected static class TextFieldWithProcessing
    extends JTextField {
        protected TextFieldWithProcessing() {
        }

        @Override
        public void processKeyEvent(KeyEvent e) {
            super.processKeyEvent(e);
        }
    }

    public class MyModel
    extends AbstractListModel {
        private List<String> myFullList = new ArrayList<String>();
        private Object mySelectedItem;

        @Override
        public Object getElementAt(int index) {
            return this.myFullList.get(index);
        }

        @Override
        public int getSize() {
            return Math.min(SearchTextField.this.myHistorySize, this.myFullList.size());
        }

        public void addElement(Object obj) {
            String newItem = ((String)obj).trim();
            if (0 == newItem.length()) {
                return;
            }
            if (!this.contains(newItem)) {
                this.insertElementAt(newItem, 0);
            }
        }

        public void insertElementAt(Object obj, int index) {
            this.myFullList.add(index, (String)obj);
            this.fireContentsChanged();
        }

        public Object getSelectedItem() {
            return this.mySelectedItem;
        }

        public void setSelectedItem(Object anItem) {
            this.mySelectedItem = anItem;
        }

        public void fireContentsChanged() {
            this.fireContentsChanged(this, -1, -1);
            SearchTextField.this.updateMenu();
        }

        public boolean contains(String aNewValue) {
            return this.myFullList.contains(aNewValue);
        }

        public void setItems(List<String> aList) {
            this.myFullList = new ArrayList<String>(aList);
            this.fireContentsChanged();
        }
    }
}

