/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.classFilter;

import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.UIBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

class ClassFilterEditorAddDialog
extends DialogWrapper {
    private final Project myProject;
    private TextFieldWithBrowseButton myClassName;

    public ClassFilterEditorAddDialog(Project project) {
        super(project, true);
        this.myProject = project;
        this.setTitle(UIBundle.message((String)"class.filter.editor.add.dialog.title", (Object[])new Object[0]));
        this.init();
    }

    @Override
    protected JComponent createCenterPanel() {
        Box box = Box.createVerticalBox();
        JPanel _panel = new JPanel(new BorderLayout());
        this.myClassName = new TextFieldWithBrowseButton();
        _panel.add((Component)new JLabel(UIBundle.message((String)"label.class.filter.editor.add.dialog.filter.pattern", (Object[])new Object[0])), "North");
        _panel.add((Component)this.myClassName, "Center");
        box.add(_panel);
        box.add(Box.createVerticalBox());
        JPanel panel = new JPanel(new BorderLayout());
        panel.setPreferredSize(new Dimension(310, -1));
        JLabel iconLabel = new JLabel(Messages.getQuestionIcon());
        panel.add((Component)iconLabel, "West");
        panel.add((Component)box, "Center");
        this.myClassName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PsiDirectory containingDirectory;
                PsiFile containingFile;
                PsiClass currentClass = ClassFilterEditorAddDialog.this.getSelectedClass();
                TreeClassChooser chooser = TreeClassChooserFactory.getInstance(ClassFilterEditorAddDialog.this.myProject).createNoInnerClassesScopeChooser(UIBundle.message((String)"class.filter.editor.choose.class.title", (Object[])new Object[0]), GlobalSearchScope.allScope(ClassFilterEditorAddDialog.this.myProject), null, null);
                if (currentClass != null && (containingFile = currentClass.getContainingFile()) != null && (containingDirectory = containingFile.getContainingDirectory()) != null) {
                    chooser.selectDirectory(containingDirectory);
                }
                chooser.showDialog();
                PsiClass selectedClass = chooser.getSelectedClass();
                if (selectedClass != null) {
                    ClassFilterEditorAddDialog.this.myClassName.setText(selectedClass.getQualifiedName());
                }
            }
        });
        this.myClassName.setEnabled(this.myProject != null);
        return panel;
    }

    private PsiClass getSelectedClass() {
        PsiManager psiManager = PsiManager.getInstance(this.myProject);
        String classQName = this.myClassName.getText();
        if ("".equals(classQName)) {
            return null;
        }
        return JavaPsiFacade.getInstance(psiManager.getProject()).findClass(classQName, GlobalSearchScope.allScope(this.myProject));
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        return this.myClassName.getTextField();
    }

    public String getPattern() {
        return this.myClassName.getText();
    }

    @Override
    protected String getDimensionServiceKey() {
        return "#com.intellij.debugger.ui.breakpoints.BreakpointsConfigurationDialogFactory.BreakpointsConfigurationDialog.AddFieldBreakpointDialog";
    }
}

