/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.treeStructure;

import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.impl.content.GraphicsConfig;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.EmptyTextHelper;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.Autoscroll;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.text.Position;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nullable;

public class Tree
extends JTree
implements Autoscroll,
Queryable {
    private EmptyTextHelper myEmptyTextHelper;
    private AsyncProcessIcon myBusyIcon;
    private boolean myBusy;
    private Rectangle myLastVisibleRec;
    private Dimension myHoldSize;
    private MySelectionModel mySelectionModel = new MySelectionModel();
    private static final int AUTOSCROLL_MARGIN = 10;

    public Tree() {
        this.initTree_();
    }

    public Tree(TreeModel treemodel) {
        super(treemodel);
        this.initTree_();
    }

    public Tree(TreeNode root) {
        super(root);
        this.initTree_();
    }

    private void initTree_() {
        this.myEmptyTextHelper = new EmptyTextHelper(this){

            @Override
            protected boolean isEmpty() {
                return Tree.this.isEmpty();
            }
        };
        this.addMouseListener(new MyMouseListener());
        this.addFocusListener(new MyFocusListener());
        this.setCellRenderer(new NodeRenderer());
        this.setSelectionModel(this.mySelectionModel);
    }

    public boolean isEmpty() {
        TreeModel model = this.getModel();
        if (model == null) {
            return true;
        }
        if (model.getRoot() == null) {
            return true;
        }
        return !this.isRootVisible() && model.getChildCount(model.getRoot()) == 0;
    }

    public String getEmptyText() {
        return this.myEmptyTextHelper.getEmptyText();
    }

    public void setEmptyText(String emptyText) {
        this.myEmptyTextHelper.setEmptyText(emptyText);
    }

    public void clearEmptyText() {
        this.myEmptyTextHelper.clearEmptyText();
    }

    public void appendEmptyText(String text, SimpleTextAttributes attrs) {
        this.myEmptyTextHelper.appendEmptyText(text, attrs);
    }

    public void appendEmptyText(String text, SimpleTextAttributes attrs, ActionListener listener) {
        this.myEmptyTextHelper.appendEmptyText(text, attrs, listener);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.updateBusy();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (this.myBusyIcon != null) {
            this.remove(this.myBusyIcon);
            Disposer.dispose((Disposable)this.myBusyIcon);
            this.myBusyIcon = null;
        }
    }

    @Override
    public void doLayout() {
        super.doLayout();
        this.updateBusyIconLocation();
    }

    private void updateBusyIconLocation() {
        if (this.myBusyIcon != null) {
            Rectangle rec = this.getVisibleRect();
            Dimension iconSize = this.myBusyIcon.getPreferredSize();
            Rectangle newBounds = new Rectangle(rec.x + rec.width - iconSize.width, rec.y, iconSize.width, iconSize.height);
            if (!newBounds.equals(this.myBusyIcon.getBounds())) {
                this.myBusyIcon.setBounds(newBounds);
                this.repaint();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g) {
        Rectangle clip = g.getClipBounds();
        Rectangle visible = this.getVisibleRect();
        if (!AbstractTreeBuilder.isToPaintSelection(this)) {
            this.mySelectionModel.holdSelection();
        }
        try {
            super.paint(g);
            if (!visible.equals(this.myLastVisibleRec)) {
                this.updateBusyIconLocation();
            }
            this.myLastVisibleRec = visible;
        }
        finally {
            this.mySelectionModel.unholdSelection();
        }
    }

    public void setPaintBusy(boolean paintBusy) {
        if (this.myBusy == paintBusy) {
            return;
        }
        this.myBusy = paintBusy;
        this.updateBusy();
    }

    private void updateBusy() {
        if (this.myBusy && this.myBusyIcon == null) {
            this.myBusyIcon = new AsyncProcessIcon(this.toString()).setUseMask(false);
            this.myBusyIcon.setOpaque(false);
            this.myBusyIcon.setPaintPassiveIcon(false);
            this.add(this.myBusyIcon);
            this.myBusyIcon.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (!UIUtil.isActionClick((MouseEvent)e)) {
                        return;
                    }
                    AbstractTreeBuilder builder = AbstractTreeBuilder.getBuilderFor(Tree.this);
                    if (builder != null) {
                        builder.cancelUpdate();
                    }
                }
            });
        }
        if (this.myBusyIcon != null) {
            if (this.myBusy) {
                this.myBusyIcon.resume();
                this.myBusyIcon.setToolTipText("Update is in progress. Click to cancel");
            } else {
                this.myBusyIcon.suspend();
                this.myBusyIcon.setToolTipText(null);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (Tree.this.myBusyIcon != null) {
                            Tree.this.repaint();
                        }
                    }
                });
            }
            this.updateBusyIconLocation();
        }
    }

    protected boolean paintNodes() {
        return false;
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.paintNodes()) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            this.paintNodeContent(g);
        }
        super.paintComponent(g);
        this.myEmptyTextHelper.paint(g);
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        if (SystemInfo.isMac && SwingUtilities.isLeftMouseButton(e) && e.isControlDown() && e.getID() == 501) {
            int modifiers = e.getModifiers() & 0xFFFFFFED | 4;
            e = new MouseEvent(e.getComponent(), e.getID(), e.getWhen(), modifiers, e.getX(), e.getY(), e.getClickCount(), true, 3);
        }
        super.processMouseEvent(e);
    }

    @Override
    public TreePath getNextMatch(String prefix, int startingRow, Position.Bias bias) {
        return null;
    }

    @Override
    public Insets getAutoscrollInsets() {
        return new Insets(this.getLocation().y + 10, 0, this.getParent().getHeight() - 10, this.getWidth() - 1);
    }

    @Override
    public void autoscroll(Point p) {
        int realrow = this.getClosestRowForLocation(p.x, p.y);
        if (this.getLocation().y + p.y <= 10) {
            if (realrow >= 1) {
                --realrow;
            }
        } else if (realrow < this.getRowCount() - 1) {
            ++realrow;
        }
        this.scrollRowToVisible(realrow);
    }

    protected boolean highlightSingleNode() {
        return true;
    }

    private void paintNodeContent(Graphics g) {
        if (!(this.getUI() instanceof BasicTreeUI)) {
            return;
        }
        AbstractTreeBuilder builder = AbstractTreeBuilder.getBuilderFor(this);
        if (builder == null || builder.isDisposed()) {
            return;
        }
        GraphicsConfig config = new GraphicsConfig(g);
        config.setAntialiasing(true);
        AbstractTreeStructure structure = builder.getTreeStructure();
        for (int eachRow = 0; eachRow < this.getRowCount(); ++eachRow) {
            Object[] kids;
            TreePath path = this.getPathForRow(eachRow);
            PresentableNodeDescriptor node = Tree.toPresentableNode(path.getLastPathComponent());
            if (node == null || !node.isContentHighlighted()) continue;
            if (this.highlightSingleNode()) {
                Rectangle rect;
                if (!node.isContentHighlighted()) continue;
                TreePath nodePath = this.getPath(node);
                Rectangle parentRect = this.getPathBounds(nodePath);
                if (this.isExpanded(nodePath)) {
                    int[] max = this.getMax(node, structure);
                    rect = new Rectangle(parentRect.x, parentRect.y, Math.max((int)parentRect.getMaxX(), max[1]) - parentRect.x - 1, Math.max((int)parentRect.getMaxY(), max[0]) - parentRect.y - 1);
                } else {
                    rect = parentRect;
                }
                if (rect == null) continue;
                Color highlightColor = node.getHighlightColor();
                g.setColor(highlightColor);
                g.fillRoundRect(rect.x, rect.y, rect.width, rect.height, 4, 4);
                g.setColor(highlightColor.darker());
                g.drawRoundRect(rect.x, rect.y, rect.width, rect.height, 4, 4);
                continue;
            }
            if (node.getParentDescriptor() == null || (kids = structure.getChildElements(node)).length == 0) continue;
            PresentableNodeDescriptor first = null;
            PresentableNodeDescriptor last = null;
            int lastIndex = -1;
            for (int i = 0; i < kids.length; ++i) {
                PresentableNodeDescriptor eachKid;
                Object kid = kids[i];
                if (!(kid instanceof PresentableNodeDescriptor) || !node.isHighlightableContentNode(eachKid = (PresentableNodeDescriptor)kid)) continue;
                if (first == null) {
                    first = eachKid;
                }
                last = eachKid;
                lastIndex = i;
            }
            if (first == null || last == null) continue;
            Rectangle firstBounds = this.getPathBounds(this.getPath(first));
            if (this.isExpanded(this.getPath(last))) {
                if (lastIndex + 1 < kids.length) {
                    Object child = kids[lastIndex + 1];
                    if (child instanceof PresentableNodeDescriptor) {
                        PresentableNodeDescriptor nextKid = (PresentableNodeDescriptor)child;
                        int nextRow = this.getRowForPath(this.getPath(nextKid));
                        last = Tree.toPresentableNode(this.getPathForRow(nextRow - 1).getLastPathComponent());
                    }
                } else {
                    NodeDescriptor parentNode = node.getParentDescriptor();
                    if (parentNode instanceof PresentableNodeDescriptor) {
                        PresentableNodeDescriptor ppd = (PresentableNodeDescriptor)parentNode;
                        int nodeIndex = node.getIndex();
                        if (nodeIndex + 1 < structure.getChildElements(ppd).length) {
                            PresentableNodeDescriptor nextChild = ppd.getChildToHighlightAt(nodeIndex + 1);
                            int nextRow = this.getRowForPath(this.getPath(nextChild));
                            TreePath prevPath = this.getPathForRow(nextRow - 1);
                            if (prevPath != null) {
                                last = Tree.toPresentableNode(prevPath.getLastPathComponent());
                            }
                        } else {
                            int lastRow = this.getRowForPath(this.getPath(last));
                            PresentableNodeDescriptor lastParent = last;
                            boolean lastWasFound = false;
                            for (int i = lastRow + 1; i < this.getRowCount(); ++i) {
                                PresentableNodeDescriptor eachNode = Tree.toPresentableNode(this.getPathForRow(i).getLastPathComponent());
                                if (!node.isParentOf(eachNode)) {
                                    last = lastParent;
                                    lastWasFound = true;
                                    break;
                                }
                                lastParent = eachNode;
                            }
                            if (!lastWasFound) {
                                last = Tree.toPresentableNode(this.getPathForRow(this.getRowCount() - 1).getLastPathComponent());
                            }
                        }
                    }
                }
            }
            if (last == null) continue;
            Rectangle lastBounds = this.getPathBounds(this.getPath(last));
            if (firstBounds == null || lastBounds == null) continue;
            Rectangle toPaint = new Rectangle(firstBounds.x, firstBounds.y, 0, (int)lastBounds.getMaxY() - firstBounds.y - 1);
            toPaint.width = this.getWidth() - toPaint.x - 4;
            Color highlightColor = first.getHighlightColor();
            g.setColor(highlightColor);
            g.fillRoundRect(toPaint.x, toPaint.y, toPaint.width, toPaint.height, 4, 4);
            g.setColor(highlightColor.darker());
            g.drawRoundRect(toPaint.x, toPaint.y, toPaint.width, toPaint.height, 4, 4);
        }
        config.restore();
    }

    private int[] getMax(PresentableNodeDescriptor node, AbstractTreeStructure structure) {
        Object[] children;
        int x = 0;
        int y = 0;
        for (Object child : children = structure.getChildElements(node)) {
            Rectangle r;
            TreePath childPath;
            if (!(child instanceof PresentableNodeDescriptor) || (childPath = this.getPath((PresentableNodeDescriptor)child)) == null) continue;
            if (this.isExpanded(childPath)) {
                int[] tmp = this.getMax((PresentableNodeDescriptor)child, structure);
                y = Math.max(y, tmp[0]);
                x = Math.max(x, tmp[1]);
            }
            if ((r = this.getPathBounds(childPath)) == null) continue;
            y = Math.max(y, (int)r.getMaxY());
            x = Math.max(x, (int)r.getMaxX());
        }
        return new int[]{y, x};
    }

    @Nullable
    private static PresentableNodeDescriptor toPresentableNode(Object pathComponent) {
        if (!(pathComponent instanceof DefaultMutableTreeNode)) {
            return null;
        }
        Object userObject = ((DefaultMutableTreeNode)pathComponent).getUserObject();
        if (!(userObject instanceof PresentableNodeDescriptor)) {
            return null;
        }
        return (PresentableNodeDescriptor)userObject;
    }

    public TreePath getPath(PresentableNodeDescriptor node) {
        AbstractTreeBuilder builder = AbstractTreeBuilder.getBuilderFor(this);
        DefaultMutableTreeNode treeNode = builder.getNodeForElement(node);
        return treeNode != null ? new TreePath(treeNode.getPath()) : new TreePath(node);
    }

    public final void setLineStyleAngled() {
        UIUtil.setLineStyleAngled((JTree)this);
    }

    public <T> T[] getSelectedNodes(Class<T> nodeType, @Nullable NodeFilter<T> filter) {
        TreePath[] paths = this.getSelectionPaths();
        if (paths == null) {
            return (Object[])Array.newInstance(nodeType, 0);
        }
        ArrayList<Object> nodes = new ArrayList<Object>();
        for (int i = 0; i < paths.length; ++i) {
            Object last = paths[i].getLastPathComponent();
            if (!nodeType.isAssignableFrom(last.getClass()) || filter != null && !filter.accept(last)) continue;
            nodes.add(last);
        }
        Object[] result = (Object[])Array.newInstance(nodeType, nodes.size());
        nodes.toArray(result);
        return result;
    }

    @Override
    public void putInfo(Map<String, String> info) {
        TreePath[] selection = this.getSelectionPaths();
        if (selection == null) {
            return;
        }
        StringBuffer nodesText = new StringBuffer();
        for (TreePath eachPath : selection) {
            Object eachNode = eachPath.getLastPathComponent();
            Component c = this.getCellRenderer().getTreeCellRendererComponent(this, eachNode, false, false, false, this.getRowForPath(eachPath), false);
            if (c == null) continue;
            if (nodesText.length() > 0) {
                nodesText.append(";");
            }
            nodesText.append(c.toString());
        }
        if (nodesText.length() > 0) {
            info.put("selectedNodes", nodesText.toString());
        }
    }

    @Override
    public void reshape(int x, int y, int w, int h) {
        super.reshape(x, y, w, h);
    }

    public void setHoldSize(boolean hold) {
        if (hold && this.myHoldSize == null) {
            this.myHoldSize = this.getPreferredSize();
        } else if (!hold && this.myHoldSize != null) {
            this.myHoldSize = null;
            this.revalidate();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        if (this.myHoldSize != null) {
            size.width = Math.max(size.width, this.myHoldSize.width);
            size.height = Math.max(size.height, this.myHoldSize.height);
        }
        return size;
    }

    public static interface NodeFilter<T> {
        public boolean accept(T var1);
    }

    private class MyFocusListener
    extends FocusAdapter {
        private MyFocusListener() {
        }

        private void focusChanges() {
            TreePath[] paths = Tree.this.getSelectionPaths();
            if (paths != null) {
                TreeUI ui = Tree.this.getUI();
                for (int i = paths.length - 1; i >= 0; --i) {
                    Rectangle bounds = ui.getPathBounds(Tree.this, paths[i]);
                    if (bounds == null) continue;
                    Tree.this.repaint(bounds);
                }
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
            this.focusChanges();
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.focusChanges();
        }
    }

    private class MyMouseListener
    extends MouseAdapter {
        private MyMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseevent) {
            TreePath treepath;
            if (!SwingUtilities.isLeftMouseButton(mouseevent) && (SwingUtilities.isRightMouseButton(mouseevent) || SwingUtilities.isMiddleMouseButton(mouseevent)) && (treepath = Tree.this.getPathForLocation(mouseevent.getX(), mouseevent.getY())) != null) {
                TreePath[] selectionPaths;
                if (Tree.this.getSelectionModel().getSelectionMode() != 1 && (selectionPaths = Tree.this.getSelectionModel().getSelectionPaths()) != null) {
                    for (TreePath selectionPath : selectionPaths) {
                        if (selectionPath == null || !selectionPath.equals(treepath)) continue;
                        return;
                    }
                }
                Tree.this.getSelectionModel().setSelectionPath(treepath);
            }
        }
    }

    private static class MySelectionModel
    extends DefaultTreeSelectionModel {
        private TreePath[] myHeldSelection;

        private MySelectionModel() {
        }

        @Override
        protected void fireValueChanged(TreeSelectionEvent e) {
            if (this.myHeldSelection == null) {
                super.fireValueChanged(e);
            }
        }

        public void holdSelection() {
            this.myHeldSelection = this.getSelectionPaths();
            this.clearSelection();
        }

        public void unholdSelection() {
            if (this.myHeldSelection != null) {
                this.setSelectionPaths(this.myHeldSelection);
                this.myHeldSelection = null;
            }
        }
    }
}

