/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.List;

public class RangeBlinker {
    private final Editor myEditor;
    private int myTimeToLive;
    private final List<RangeMarker> myMarkers = new ArrayList<RangeMarker>();
    private boolean show = true;
    private final Alarm myBlinkingAlarm = new Alarm();
    private final TextAttributes myAttributes;
    private final List<RangeHighlighter> myAddedHighlighters = new ArrayList<RangeHighlighter>();

    public RangeBlinker(Editor editor, TextAttributes attributes, int timeToLive) {
        this.myAttributes = attributes;
        this.myEditor = editor;
        this.myTimeToLive = timeToLive;
    }

    public void resetMarkers(List<RangeMarker> markers) {
        this.removeHighlights();
        this.myMarkers.clear();
        this.stopBlinking();
        this.myMarkers.addAll(markers);
        this.show = true;
    }

    private void removeHighlights() {
        MarkupModel markupModel = this.myEditor.getMarkupModel();
        Object[] allHighlighters = markupModel.getAllHighlighters();
        for (RangeHighlighter highlighter : this.myAddedHighlighters) {
            if (ArrayUtil.indexOf((Object[])allHighlighters, (Object)highlighter) == -1) continue;
            markupModel.removeHighlighter(highlighter);
        }
        this.myAddedHighlighters.clear();
    }

    public void startBlinking() {
        Project project = this.myEditor.getProject();
        if (ApplicationManager.getApplication().isDisposed() || this.myEditor.isDisposed() || project != null && project.isDisposed()) {
            return;
        }
        MarkupModel markupModel = this.myEditor.getMarkupModel();
        if (this.show) {
            for (RangeMarker rangeMarker : this.myMarkers) {
                if (!rangeMarker.isValid()) continue;
                RangeHighlighter highlighter = markupModel.addRangeHighlighter(rangeMarker.getStartOffset(), rangeMarker.getEndOffset(), 3000, this.myAttributes, HighlighterTargetArea.EXACT_RANGE);
                this.myAddedHighlighters.add(highlighter);
            }
        } else {
            this.removeHighlights();
        }
        this.stopBlinking();
        this.myBlinkingAlarm.addRequest(new Runnable(){

            @Override
            public void run() {
                if (RangeBlinker.this.myTimeToLive > 0 || RangeBlinker.this.show) {
                    RangeBlinker.this.myTimeToLive--;
                    RangeBlinker.this.show = !RangeBlinker.this.show;
                    RangeBlinker.this.startBlinking();
                }
            }
        }, 400);
    }

    public void stopBlinking() {
        this.myBlinkingAlarm.cancelAllRequests();
    }
}

