/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.breakpoints;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointCustomPropertiesPanel;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointGroupingRule;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.ui.DebuggerIcons;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XBreakpointType<B extends XBreakpoint<P>, P extends XBreakpointProperties> {
    public static final ExtensionPointName<XBreakpointType> EXTENSION_POINT_NAME = ExtensionPointName.create((String)"com.intellij.xdebugger.breakpointType");
    @NonNls
    @NotNull
    private final String myId;
    @Nls
    @NotNull
    private final String myTitle;
    private final boolean mySuspendThreadSupported;

    protected XBreakpointType(@NonNls @NotNull String id, @Nls @NotNull String title) {
        if (id == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/breakpoints/XBreakpointType.<init> must not be null");
        }
        if (title == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/xdebugger/breakpoints/XBreakpointType.<init> must not be null");
        }
        this(id, title, false);
    }

    protected XBreakpointType(@NonNls @NotNull String id, @Nls @NotNull String title, boolean suspendThreadSupported) {
        if (id == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/breakpoints/XBreakpointType.<init> must not be null");
        }
        if (title == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/xdebugger/breakpoints/XBreakpointType.<init> must not be null");
        }
        this.myId = id;
        this.myTitle = title;
        this.mySuspendThreadSupported = suspendThreadSupported;
    }

    @Nullable
    public P createProperties() {
        return null;
    }

    public final boolean isSuspendThreadSupported() {
        return this.mySuspendThreadSupported;
    }

    @NotNull
    public final String getId() {
        String string = this.myId;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/xdebugger/breakpoints/XBreakpointType.getId must not return null");
        }
        return string;
    }

    @NotNull
    public String getTitle() {
        String string = this.myTitle;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/xdebugger/breakpoints/XBreakpointType.getTitle must not return null");
        }
        return string;
    }

    @NotNull
    public Icon getEnabledIcon() {
        Icon icon = DebuggerIcons.ENABLED_BREAKPOINT_ICON;
        if (icon == null) {
            throw new IllegalStateException("@NotNull method com/intellij/xdebugger/breakpoints/XBreakpointType.getEnabledIcon must not return null");
        }
        return icon;
    }

    @NotNull
    public Icon getDisabledIcon() {
        Icon icon = DebuggerIcons.DISABLED_BREAKPOINT_ICON;
        if (icon == null) {
            throw new IllegalStateException("@NotNull method com/intellij/xdebugger/breakpoints/XBreakpointType.getDisabledIcon must not return null");
        }
        return icon;
    }

    public abstract String getDisplayText(B var1);

    @Nullable
    public XBreakpointCustomPropertiesPanel<B> createCustomConditionsPanel() {
        return null;
    }

    @Nullable
    public XBreakpointCustomPropertiesPanel<B> createCustomPropertiesPanel() {
        return null;
    }

    @Nullable
    public XDebuggerEditorsProvider getEditorsProvider() {
        return null;
    }

    public List<XBreakpointGroupingRule<B, ?>> getGroupingRules() {
        return Collections.emptyList();
    }

    @NotNull
    public Comparator<B> getBreakpointComparator() {
        Comparator comparator = XDebuggerUtil.getInstance().getDefaultBreakpointComparator(this);
        if (comparator == null) {
            throw new IllegalStateException("@NotNull method com/intellij/xdebugger/breakpoints/XBreakpointType.getBreakpointComparator must not return null");
        }
        return comparator;
    }

    public boolean isAddBreakpointButtonVisible() {
        return false;
    }

    @Nullable
    public B addBreakpoint(Project project, JComponent parentComponent) {
        return null;
    }

    @Nullable
    @NonNls
    public String getBreakpointsDialogHelpTopic() {
        return null;
    }
}

