/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public class RandomAccessFileInputStream
extends InputStream {
    private RandomAccessFile raf;
    private long cur;
    private long limit;

    public RandomAccessFileInputStream(RandomAccessFile raf, long pos, long limit) {
        this.raf = raf;
        this.setup(pos, limit);
    }

    public void setup(long pos, long limit) {
        this.cur = pos;
        this.limit = limit;
    }

    public RandomAccessFileInputStream(RandomAccessFile raf, long pos) throws IOException {
        this(raf, pos, raf.length());
    }

    @Override
    public int available() {
        return (int)(this.limit - this.cur);
    }

    @Override
    public void close() {
    }

    @Override
    public int read() throws IOException {
        int retval = -1;
        if (this.cur < this.limit) {
            this.raf.seek(this.cur);
            ++this.cur;
            retval = this.raf.read();
        }
        return retval;
    }

    @Override
    public int read(byte[] b, int offset, int length) throws IOException {
        if (length > this.available()) {
            length = this.available();
        }
        int amountRead = -1;
        if (this.available() > 0) {
            this.raf.seek(this.cur);
            amountRead = this.raf.read(b, offset, length);
        }
        if (amountRead > 0) {
            this.cur += (long)amountRead;
        }
        return amountRead;
    }

    @Override
    public long skip(long amountToSkip) {
        long amountSkipped = Math.min(amountToSkip, (long)this.available());
        this.cur += amountSkipped;
        return amountSkipped;
    }
}

