/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.util.xmlb.Accessor;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.XmlSerializationException;
import com.intellij.util.xmlb.XmlSerializerImpl;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.ArrayList;
import org.jdom.Element;
import org.jetbrains.annotations.Nullable;

class JDOMElementBinding
implements Binding {
    private final Accessor myAccessor;
    private final String myTagName;

    public JDOMElementBinding(Accessor accessor) {
        this.myAccessor = accessor;
        Tag tag = XmlSerializerImpl.findAnnotation(this.myAccessor.getAnnotations(), Tag.class);
        assert (tag != null) : "jdom.Element property without @Tag annotation: " + accessor;
        this.myTagName = tag.value();
    }

    @Override
    public Object serialize(Object o, Object context) {
        Object value = this.myAccessor.read(o);
        if (value == null) {
            return context;
        }
        if (value instanceof Element) {
            Element targetElement = (Element)((Element)value).clone();
            targetElement.setName(this.myTagName);
            return targetElement;
        }
        if (value instanceof Element[]) {
            ArrayList<Element> result = new ArrayList<Element>();
            for (Element element : (Element[])value) {
                Element target = ((Element)element.clone()).setName(this.myTagName);
                result.add(target);
            }
            return result;
        }
        throw new XmlSerializationException("org.jdom.Element expected but " + value + " found");
    }

    @Override
    @Nullable
    public Object deserialize(Object context, Object ... nodes) {
        Element[] result = new Element[nodes.length];
        System.arraycopy(nodes, 0, result, 0, nodes.length);
        if (this.myAccessor.getValueClass().isArray()) {
            this.myAccessor.write(context, result);
        } else {
            assert (result.length == 1);
            this.myAccessor.write(context, result[0]);
        }
        return context;
    }

    @Override
    public boolean isBoundTo(Object node) {
        return node instanceof Element && ((Element)node).getName().equals(this.myTagName);
    }

    @Override
    public Class getBoundNodeType() {
        throw new UnsupportedOperationException("Method getBoundNodeType is not supported in " + this.getClass());
    }

    @Override
    public void init() {
    }
}

