/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.copyright.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.maddyhome.idea.copyright.ui.CopyrightFormattingConfigurable;
import com.maddyhome.idea.copyright.ui.CopyrightProfilesPanel;
import com.maddyhome.idea.copyright.ui.ProjectSettingsPanel;
import javax.swing.Icon;
import javax.swing.JComponent;

public class CopyrightProjectConfigurable
extends SearchableConfigurable.Parent.Abstract {
    private final Project project;
    private ProjectSettingsPanel optionsPanel = null;
    private static final Icon icon = IconLoader.getIcon((String)"/resources/copyright32x32.png");
    private static final Logger logger = Logger.getInstance((String)CopyrightProjectConfigurable.class.getName());
    private final CopyrightProfilesPanel myProfilesPanel;

    public CopyrightProjectConfigurable(Project project) {
        this.project = project;
        this.myProfilesPanel = new CopyrightProfilesPanel(project);
    }

    public String getDisplayName() {
        return "Copyright";
    }

    public Icon getIcon() {
        return icon;
    }

    public String getHelpTopic() {
        return this.getId();
    }

    public JComponent createComponent() {
        logger.info("createComponent()");
        this.optionsPanel = new ProjectSettingsPanel(this.project, this.myProfilesPanel);
        return this.optionsPanel.getMainComponent();
    }

    public boolean isModified() {
        logger.info("isModified()");
        boolean res = false;
        if (this.optionsPanel != null) {
            res = this.optionsPanel.isModified();
        }
        logger.info("isModified() = " + res);
        return res;
    }

    public void apply() throws ConfigurationException {
        logger.info("apply()");
        if (this.optionsPanel != null) {
            this.optionsPanel.apply();
        }
    }

    public void reset() {
        logger.info("reset()");
        if (this.optionsPanel != null) {
            this.optionsPanel.reset();
        }
    }

    public void disposeUIResources() {
        this.optionsPanel = null;
    }

    public boolean hasOwnContent() {
        return true;
    }

    public boolean isVisible() {
        return true;
    }

    public String getId() {
        return "copyright";
    }

    public Runnable enableSearch(String option) {
        return null;
    }

    protected Configurable[] buildConfigurables() {
        return new Configurable[]{this.myProfilesPanel, new CopyrightFormattingConfigurable(this.project)};
    }
}

