/*
 * Decompiled with CFR 0.152.
 */
package git4idea.changes;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.VcsDirtyScope;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitContentRevision;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.changes.GitChangeUtils;
import git4idea.commands.GitCommand;
import git4idea.commands.GitSimpleHandler;
import git4idea.commands.StringScanner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;

class ChangeCollector {
    private VcsDirtyScope myDirtyScope;
    private final VirtualFile myVcsRoot;
    private final Project myProject;
    private final List<VirtualFile> myUnversioned = new ArrayList<VirtualFile>();
    private final Set<String> myUnmergedNames = new HashSet<String>();
    private final List<Change> myChanges = new ArrayList<Change>();
    private boolean myIsFailed = true;
    private boolean myIsCollected = false;

    public ChangeCollector(Project project, VcsDirtyScope dirtyScope, VirtualFile vcsRoot) {
        this.myDirtyScope = dirtyScope;
        this.myVcsRoot = vcsRoot;
        this.myProject = project;
    }

    public Collection<VirtualFile> unversioned() throws VcsException {
        this.ensureCollected();
        return this.myUnversioned;
    }

    public Collection<Change> changes() throws VcsException {
        this.ensureCollected();
        return this.myChanges;
    }

    private void ensureCollected() throws VcsException {
        if (this.myIsCollected) {
            if (this.myIsFailed) {
                throw new IllegalStateException("The method should not be called after after exception has been thrown.");
            }
            return;
        }
        this.myIsCollected = true;
        this.updateIndex();
        this.collectUnmergedAndUnversioned();
        this.collectDiffChanges();
        this.myIsFailed = false;
    }

    private void updateIndex() throws VcsException {
        GitSimpleHandler handler = new GitSimpleHandler(this.myProject, this.myVcsRoot, GitCommand.UPDATE_INDEX);
        handler.addParameters("--refresh", "--ignore-missing");
        handler.setSilent(true);
        handler.setNoSSH(true);
        handler.setStdoutSuppressed(true);
        handler.ignoreErrorCode(1);
        handler.run();
    }

    private Collection<FilePath> dirtyPaths(boolean includeChanges) {
        ArrayList<FilePath> paths = new ArrayList<FilePath>();
        FilePath rootPath = VcsUtil.getFilePath((String)this.myVcsRoot.getPath(), (boolean)true);
        for (FilePath p : this.myDirtyScope.getRecursivelyDirtyDirectories()) {
            this.addToPaths(rootPath, paths, p);
        }
        ArrayList candidatePaths = new ArrayList();
        candidatePaths.addAll(this.myDirtyScope.getDirtyFilesNoExpand());
        if (includeChanges) {
            try {
                ChangeListManager cm = ChangeListManager.getInstance((Project)this.myProject);
                for (Change c : cm.getChangesIn(this.myVcsRoot)) {
                    switch (c.getType()) {
                        case NEW: 
                        case DELETED: 
                        case MOVED: {
                            if (c.getAfterRevision() != null) {
                                this.addToPaths(rootPath, paths, c.getAfterRevision().getFile());
                            }
                            if (c.getBeforeRevision() == null) break;
                            this.addToPaths(rootPath, paths, c.getBeforeRevision().getFile());
                        }
                    }
                }
            }
            catch (Exception t) {
                // empty catch block
            }
        }
        for (FilePath p : candidatePaths) {
            this.addToPaths(rootPath, paths, p);
        }
        return paths;
    }

    void addToPaths(FilePath root, Collection<FilePath> paths, FilePath toAdd) {
        if (GitUtil.getGitRootOrNull(toAdd) != this.myVcsRoot) {
            return;
        }
        if (root.isUnder(toAdd, true)) {
            toAdd = root;
        }
        Iterator<FilePath> i = paths.iterator();
        while (i.hasNext()) {
            FilePath p = i.next();
            if (p.isUnder(toAdd, true)) {
                i.remove();
            }
            if (!toAdd.isUnder(p, false)) continue;
            return;
        }
        paths.add(toAdd);
    }

    private void collectDiffChanges() throws VcsException {
        block6: {
            Collection<FilePath> dirtyPaths = this.dirtyPaths(true);
            if (dirtyPaths.isEmpty()) {
                return;
            }
            GitSimpleHandler handler = new GitSimpleHandler(this.myProject, this.myVcsRoot, GitCommand.DIFF);
            handler.addParameters("--name-status", "--diff-filter=ADCMRUX", "-M", "HEAD");
            handler.setNoSSH(true);
            handler.setSilent(true);
            handler.setStdoutSuppressed(true);
            handler.endOptions();
            handler.addRelativePaths(dirtyPaths);
            if (handler.isLargeCommandLine()) {
                handler = new GitSimpleHandler(this.myProject, this.myVcsRoot, GitCommand.DIFF);
                handler.addParameters("--name-status", "--diff-filter=ADCMRUX", "-M", "HEAD");
                handler.setNoSSH(true);
                handler.setSilent(true);
                handler.setStdoutSuppressed(true);
                handler.endOptions();
            }
            try {
                String output = handler.run();
                GitChangeUtils.parseChanges(this.myProject, this.myVcsRoot, null, GitChangeUtils.loadRevision(this.myProject, this.myVcsRoot, "HEAD"), output, this.myChanges, this.myUnmergedNames);
            }
            catch (VcsException ex) {
                if (!GitChangeUtils.isHeadMissing(ex)) {
                    throw ex;
                }
                handler = new GitSimpleHandler(this.myProject, this.myVcsRoot, GitCommand.LS_FILES);
                handler.addParameters("--cached");
                handler.setNoSSH(true);
                handler.setSilent(true);
                handler.setStdoutSuppressed(true);
                String output = handler.run();
                if (output.length() <= 0) break block6;
                StringTokenizer tokenizer = new StringTokenizer(output, "\n\r");
                while (tokenizer.hasMoreTokens()) {
                    String s = tokenizer.nextToken();
                    Change ch = new Change(null, GitContentRevision.createRevision(this.myVcsRoot, s, null, this.myProject, false), FileStatus.ADDED);
                    this.myChanges.add(ch);
                }
            }
        }
    }

    private void collectUnmergedAndUnversioned() throws VcsException {
        Collection<FilePath> dirtyPaths = this.dirtyPaths(false);
        if (dirtyPaths.isEmpty()) {
            return;
        }
        GitSimpleHandler handler = new GitSimpleHandler(this.myProject, this.myVcsRoot, GitCommand.LS_FILES);
        handler.addParameters("-v", "--unmerged");
        handler.setSilent(true);
        handler.setNoSSH(true);
        handler.setStdoutSuppressed(true);
        this.parseFiles(handler.run());
        handler = new GitSimpleHandler(this.myProject, this.myVcsRoot, GitCommand.LS_FILES);
        handler.addParameters("-v", "--others", "--exclude-standard");
        handler.setSilent(true);
        handler.setNoSSH(true);
        handler.setStdoutSuppressed(true);
        handler.endOptions();
        handler.addRelativePaths(dirtyPaths);
        if (handler.isLargeCommandLine()) {
            handler = new GitSimpleHandler(this.myProject, this.myVcsRoot, GitCommand.LS_FILES);
            handler.addParameters("-v", "--others", "--exclude-standard");
            handler.setSilent(true);
            handler.setNoSSH(true);
            handler.setStdoutSuppressed(true);
            handler.endOptions();
        }
        this.parseFiles(handler.run());
    }

    private void parseFiles(String list) throws VcsException {
        StringScanner sc = new StringScanner(list);
        while (sc.hasMoreData()) {
            Object file;
            if (sc.isEol()) {
                sc.nextLine();
                continue;
            }
            char status = sc.peek();
            sc.skipChars(2);
            if ('?' == status) {
                file = this.myVcsRoot.findFileByRelativePath(GitUtil.unescapePath(sc.line()));
                if (GitUtil.gitRootOrNull(file) != this.myVcsRoot) continue;
                this.myUnversioned.add((VirtualFile)file);
                continue;
            }
            if ('M' == status) {
                sc.boundedToken('\t');
                file = GitUtil.unescapePath(sc.line());
                VirtualFile vFile = this.myVcsRoot.findFileByRelativePath((String)file);
                if (GitUtil.gitRootOrNull(vFile) != this.myVcsRoot || !this.myUnmergedNames.add((String)file)) continue;
                ContentRevision before = GitContentRevision.createRevision(this.myVcsRoot, (String)file, new GitRevisionNumber("orig_head"), this.myProject, false);
                ContentRevision after = GitContentRevision.createRevision(this.myVcsRoot, (String)file, null, this.myProject, false);
                this.myChanges.add(new Change(before, after, FileStatus.MERGED_WITH_CONFLICTS));
                continue;
            }
            throw new VcsException("Unsupported type of the merge conflict detected: " + status);
        }
    }
}

