/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rollback;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.rollback.RollbackEnvironment;
import com.intellij.openapi.vcs.rollback.RollbackProgressListener;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitUtil;
import git4idea.commands.GitCommand;
import git4idea.commands.GitFileUtils;
import git4idea.commands.GitSimpleHandler;
import git4idea.i18n.GitBundle;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class GitRollbackEnvironment
implements RollbackEnvironment {
    private final Project myProject;

    public GitRollbackEnvironment(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of git4idea/rollback/GitRollbackEnvironment.<init> must not be null");
        }
        this.myProject = project;
    }

    @NotNull
    public String getRollbackOperationName() {
        String string = GitBundle.getString("revert.action.name");
        if (string == null) {
            throw new IllegalStateException("@NotNull method git4idea/rollback/GitRollbackEnvironment.getRollbackOperationName must not return null");
        }
        return string;
    }

    public void rollbackModifiedWithoutCheckout(@NotNull List<VirtualFile> files, List<VcsException> exceptions, RollbackProgressListener listener) {
        if (files == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of git4idea/rollback/GitRollbackEnvironment.rollbackModifiedWithoutCheckout must not be null");
        }
        throw new UnsupportedOperationException("Explicit file checkout is not supported by GIT.");
    }

    public void rollbackMissingFileDeletion(@NotNull List<FilePath> files, List<VcsException> exceptions, RollbackProgressListener listener) {
        if (files == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of git4idea/rollback/GitRollbackEnvironment.rollbackMissingFileDeletion must not be null");
        }
        throw new UnsupportedOperationException("Missing file delete is not reported by GIT.");
    }

    public void rollbackIfUnchanged(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of git4idea/rollback/GitRollbackEnvironment.rollbackIfUnchanged must not be null");
        }
    }

    public void rollbackChanges(@NotNull List<Change> changes, List<VcsException> exceptions, @NotNull RollbackProgressListener listener) {
        if (changes == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of git4idea/rollback/GitRollbackEnvironment.rollbackChanges must not be null");
        }
        if (listener == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of git4idea/rollback/GitRollbackEnvironment.rollbackChanges must not be null");
        }
        HashMap<VirtualFile, List<FilePath>> toUnindex = new HashMap<VirtualFile, List<FilePath>>();
        HashMap<VirtualFile, List<FilePath>> toRevert = new HashMap<VirtualFile, List<FilePath>>();
        ArrayList<FilePath> toDelete = new ArrayList<FilePath>();
        listener.determinate();
        for (Change change : changes) {
            switch (change.getType()) {
                case NEW: {
                    GitRollbackEnvironment.registerFile(toUnindex, change.getAfterRevision().getFile(), exceptions);
                    break;
                }
                case MOVED: {
                    GitRollbackEnvironment.registerFile(toRevert, change.getBeforeRevision().getFile(), exceptions);
                    GitRollbackEnvironment.registerFile(toUnindex, change.getAfterRevision().getFile(), exceptions);
                    toDelete.add(change.getAfterRevision().getFile());
                    break;
                }
                case MODIFICATION: {
                    GitRollbackEnvironment.registerFile(toUnindex, change.getBeforeRevision().getFile(), exceptions);
                    GitRollbackEnvironment.registerFile(toRevert, change.getBeforeRevision().getFile(), exceptions);
                    break;
                }
                case DELETED: {
                    GitRollbackEnvironment.registerFile(toRevert, change.getBeforeRevision().getFile(), exceptions);
                }
            }
        }
        for (Map.Entry entry : toUnindex.entrySet()) {
            listener.accept((List)entry.getValue());
            try {
                this.unindex((VirtualFile)entry.getKey(), (List)entry.getValue());
            }
            catch (VcsException e) {
                exceptions.add(e);
            }
        }
        for (FilePath filePath : toDelete) {
            listener.accept(filePath);
            try {
                File ioFile = filePath.getIOFile();
                if (!ioFile.exists() || ioFile.delete()) continue;
                exceptions.add(new VcsException("Unable to delete file: " + filePath));
            }
            catch (Exception e) {
                exceptions.add(new VcsException("Unable to delete file: " + filePath, (Throwable)e));
            }
        }
        for (Map.Entry entry : toRevert.entrySet()) {
            listener.accept((List)entry.getValue());
            try {
                this.revert((VirtualFile)entry.getKey(), (List)entry.getValue());
            }
            catch (VcsException e) {
                exceptions.add(e);
            }
        }
    }

    public void revert(VirtualFile root, List<FilePath> files) throws VcsException {
        for (List<String> paths : GitFileUtils.chunkPaths(root, files)) {
            GitSimpleHandler handler = new GitSimpleHandler(this.myProject, root, GitCommand.CHECKOUT);
            handler.setNoSSH(true);
            handler.addParameters("HEAD");
            handler.endOptions();
            handler.addParameters(paths);
            handler.run();
        }
    }

    private void unindex(VirtualFile root, List<FilePath> files) throws VcsException {
        GitFileUtils.delete(this.myProject, root, files, "--cached", "-f");
    }

    private static void registerFile(Map<VirtualFile, List<FilePath>> files, FilePath file, List<VcsException> exceptions) {
        VirtualFile root;
        try {
            root = GitUtil.getGitRoot(file);
        }
        catch (VcsException e) {
            exceptions.add(e);
            return;
        }
        List<FilePath> paths = files.get(root);
        if (paths == null) {
            paths = new ArrayList<FilePath>();
            files.put(root, paths);
        }
        paths.add(file);
    }

    public static GitRollbackEnvironment getInstance(Project project) {
        return (GitRollbackEnvironment)ServiceManager.getService((Project)project, GitRollbackEnvironment.class);
    }
}

