/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui;

import com.intellij.codeStyle.CodeStyleFacade;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckboxTreeBase;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.Processor;
import com.intellij.util.containers.HashMap;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.commands.GitCommand;
import git4idea.commands.GitSimpleHandler;
import git4idea.commands.StringScanner;
import git4idea.config.GitVcsSettings;
import git4idea.config.GitVersion;
import git4idea.i18n.GitBundle;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.MutableTreeNode;

public class GitConvertFilesDialog
extends DialogWrapper {
    private static final GitVersion CHECK_ATTR_STDIN_SUPPORTED = new GitVersion(1, 6, 1, 0);
    public static final int DO_NOT_CONVERT = 2;
    private JCheckBox myDoNotShowCheckBox;
    private JPanel myRootPanel;
    private CheckboxTreeBase myFilesToConvert;
    private CheckedTreeNode myRootNode;

    GitConvertFilesDialog(Project project, Map<VirtualFile, Set<VirtualFile>> filesToShow) {
        super(project, true);
        this.$$$setupUI$$$();
        ArrayList<VirtualFile> roots = new ArrayList<VirtualFile>(filesToShow.keySet());
        Collections.sort(roots, GitUtil.VIRTUAL_FILE_COMPARATOR);
        for (VirtualFile root : roots) {
            CheckedTreeNode vcsRoot = new CheckedTreeNode((Object)root);
            this.myRootNode.add((MutableTreeNode)vcsRoot);
            ArrayList files = new ArrayList(filesToShow.get(root));
            Collections.sort(files, GitUtil.VIRTUAL_FILE_COMPARATOR);
            for (VirtualFile file : files) {
                vcsRoot.add((MutableTreeNode)new CheckedTreeNode((Object)file));
            }
        }
        TreeUtil.expandAll((JTree)this.myFilesToConvert);
        this.setTitle(GitBundle.getString("crlf.convert.title"));
        this.setOKButtonText(GitBundle.getString("crlf.convert.convert"));
        this.init();
    }

    protected Action[] createActions() {
        return new Action[]{this.getOKAction(), new DoNotConvertAction(), this.getCancelAction()};
    }

    private void createUIComponents() {
        this.myRootNode = new CheckedTreeNode((Object)"ROOT");
        this.myFilesToConvert = new CheckboxTree(new FileTreeCellRenderer(), this.myRootNode){

            protected void onNodeStateChanged(CheckedTreeNode node) {
                VirtualFile[] files = (VirtualFile[])GitConvertFilesDialog.this.myFilesToConvert.getCheckedNodes(VirtualFile.class, null);
                GitConvertFilesDialog.this.setOKActionEnabled(files != null && files.length > 0);
                super.onNodeStateChanged(node);
            }
        };
    }

    protected JComponent createCenterPanel() {
        return this.myRootPanel;
    }

    protected String getDimensionServiceKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public static boolean showDialogIfNeeded(final Project project, final GitVcsSettings settings, Map<VirtualFile, List<Change>> sortedChanges, List<VcsException> exceptions) {
        try {
            if (settings.askBeforeLineSeparatorConversion() || settings.getLineSeparatorsConversion() == GitVcsSettings.ConversionPolicy.PROJECT_LINE_SEPARATORS) {
                LocalFileSystem lfs = LocalFileSystem.getInstance();
                String nl = CodeStyleFacade.getInstance((Project)project).getLineSeparator();
                HashMap files = new HashMap();
                for (Map.Entry<VirtualFile, List<Change>> entry : sortedChanges.entrySet()) {
                    VirtualFile root = entry.getKey();
                    HashSet<VirtualFile> added = new HashSet<VirtualFile>();
                    for (Change change : entry.getValue()) {
                        switch (change.getType()) {
                            case NEW: 
                            case MODIFICATION: 
                            case MOVED: {
                                VirtualFile f = lfs.findFileByPath(change.getAfterRevision().getFile().getPath());
                                if (f == null || f.getFileType().isBinary() || nl.equals(LoadTextUtil.detectLineSeparator((VirtualFile)f, (boolean)false))) break;
                                added.add(f);
                                break;
                            }
                        }
                    }
                    if (added.isEmpty()) continue;
                    files.put(root, added);
                }
                GitConvertFilesDialog.ignoreFilesWithCrlfUnset(project, (Map<VirtualFile, Set<VirtualFile>>)files);
                Iterator i = files.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry e = i.next();
                    Set fs = (Set)e.getValue();
                    Iterator j = fs.iterator();
                    while (j.hasNext()) {
                        VirtualFile f = (VirtualFile)j.next();
                        String detectedLineSeparator = LoadTextUtil.detectLineSeparator((VirtualFile)f, (boolean)true);
                        if (detectedLineSeparator != null && !nl.equals(detectedLineSeparator)) continue;
                        j.remove();
                    }
                    if (!fs.isEmpty()) continue;
                    i.remove();
                }
                if (files.isEmpty()) {
                    return true;
                }
                UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable((Map)files, exceptions, nl){
                    final /* synthetic */ Map val$files;
                    final /* synthetic */ List val$exceptions;
                    final /* synthetic */ String val$nl;
                    {
                        this.val$files = map;
                        this.val$exceptions = list;
                        this.val$nl = string;
                    }

                    @Override
                    public void run() {
                        VirtualFile[] selectedFiles = null;
                        if (settings.askBeforeLineSeparatorConversion()) {
                            GitConvertFilesDialog d = new GitConvertFilesDialog(project, this.val$files);
                            d.show();
                            if (d.isOK()) {
                                settings.setAskBeforeLineSeparatorConversion(!d.myDoNotShowCheckBox.isSelected());
                                settings.setLineSeparatorsConversion(GitVcsSettings.ConversionPolicy.PROJECT_LINE_SEPARATORS);
                                selectedFiles = (VirtualFile[])d.myFilesToConvert.getCheckedNodes(VirtualFile.class, null);
                            } else if (d.getExitCode() == 2) {
                                settings.setAskBeforeLineSeparatorConversion(!d.myDoNotShowCheckBox.isSelected());
                                settings.setLineSeparatorsConversion(GitVcsSettings.ConversionPolicy.NONE);
                            } else {
                                this.val$exceptions.add(new VcsException("Commit was cancelled in file conversion dialog"));
                            }
                        } else {
                            ArrayList fileList = new ArrayList();
                            for (Set fileSet : this.val$files.values()) {
                                fileList.addAll(fileSet);
                            }
                            selectedFiles = VfsUtil.toVirtualFileArray(fileList);
                        }
                        if (selectedFiles != null) {
                            for (VirtualFile f : selectedFiles) {
                                try {
                                    LoadTextUtil.changeLineSeparator((Project)project, (Object)GitConvertFilesDialog.class.getName(), (VirtualFile)f, (String)this.val$nl);
                                }
                                catch (IOException e) {
                                    this.val$exceptions.add(new VcsException("Failed to change line separators for the file: " + f.getPresentableUrl(), (Throwable)e));
                                }
                            }
                        }
                    }
                });
            }
        }
        catch (VcsException e) {
            exceptions.add(e);
        }
        return exceptions.isEmpty();
    }

    private static void ignoreFilesWithCrlfUnset(Project project, Map<VirtualFile, Set<VirtualFile>> files) throws VcsException {
        boolean stdin = CHECK_ATTR_STDIN_SUPPORTED.isLessOrEqual(GitVcs.getInstance(project).version());
        for (Map.Entry<VirtualFile, Set<VirtualFile>> e : files.entrySet()) {
            VirtualFile r = e.getKey();
            GitSimpleHandler h = new GitSimpleHandler(project, r, GitCommand.CHECK_ATTR);
            if (stdin) {
                h.addParameters("--stdin", "-z");
            }
            h.addParameters("crlf");
            h.setSilent(true);
            h.setNoSSH(true);
            final HashMap filesToCheck = new HashMap();
            Set<VirtualFile> fileSet = e.getValue();
            for (VirtualFile file : fileSet) {
                filesToCheck.put((Object)GitUtil.relativePath(r, file), (Object)file);
            }
            if (stdin) {
                h.setInputProcessor(new Processor<OutputStream>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public boolean process(OutputStream outputStream) {
                        try {
                            OutputStreamWriter out = new OutputStreamWriter(outputStream, GitUtil.UTF8_CHARSET);
                            try {
                                for (String file : filesToCheck.keySet()) {
                                    out.write(file);
                                    out.write("\u0000");
                                }
                            }
                            finally {
                                out.close();
                            }
                        }
                        catch (IOException ex) {
                            try {
                                outputStream.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        return true;
                    }
                });
            } else {
                h.endOptions();
                h.addRelativeFiles(filesToCheck.values());
            }
            StringScanner output = new StringScanner(h.run());
            String unsetIndicator = ": crlf: unset";
            while (output.hasMoreData()) {
                String l = output.line();
                if (!l.endsWith(unsetIndicator)) continue;
                fileSet.remove(filesToCheck.get((Object)GitUtil.unescapePath(l.substring(0, l.length() - unsetIndicator.length()))));
            }
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JPanel jPanel;
        this.createUIComponents();
        this.myRootPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("crlf.convert.label"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JScrollPane jScrollPane = new JScrollPane();
        jPanel.add((Component)jScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        CheckboxTreeBase checkboxTreeBase = this.myFilesToConvert;
        checkboxTreeBase.setShowsRootHandles(false);
        jScrollPane.setViewportView((Component)checkboxTreeBase);
        this.myDoNotShowCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("common.do.not.show"));
        jCheckBox.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("common.do.not.show.tooltip"));
        jPanel.add((Component)jCheckBox, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        jLabel.setLabelFor(jScrollPane);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    static class FileTreeCellRenderer
    extends CheckboxTree.CheckboxTreeCellRenderer {
        FileTreeCellRenderer() {
        }

        public void customizeRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            ColoredTreeCellRenderer r = this.getTextRenderer();
            if (!(value instanceof CheckedTreeNode)) {
                FileTreeCellRenderer.renderUnknown(r, value);
                return;
            }
            CheckedTreeNode node = (CheckedTreeNode)value;
            if (!(node.getUserObject() instanceof VirtualFile)) {
                FileTreeCellRenderer.renderUnknown(r, node.getUserObject());
                return;
            }
            VirtualFile file = (VirtualFile)node.getUserObject();
            if (leaf) {
                VirtualFile parent = (VirtualFile)((CheckedTreeNode)node.getParent()).getUserObject();
                Icon i = file.getIcon();
                if (i != null) {
                    r.setIcon(i);
                }
                r.append(GitUtil.getRelativeFilePath(file, parent), SimpleTextAttributes.REGULAR_ATTRIBUTES, true);
            } else {
                r.append(file.getPresentableUrl(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES, true);
            }
        }

        private static void renderUnknown(ColoredTreeCellRenderer r, Object value) {
            r.append("UNSUPPORTED NODE TYPE: " + (value == null ? "null" : value.getClass().getName()), SimpleTextAttributes.ERROR_ATTRIBUTES);
        }
    }

    class DoNotConvertAction
    extends AbstractAction {
        private static final long serialVersionUID = 1931383640152023206L;

        DoNotConvertAction() {
            this.putValue("Name", GitBundle.getString("crlf.convert.leave"));
            this.putValue("DefaultAction", Boolean.FALSE);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            if (GitConvertFilesDialog.this.myPerformAction) {
                return;
            }
            try {
                GitConvertFilesDialog.this.myPerformAction = true;
                GitConvertFilesDialog.this.close(2);
            }
            finally {
                GitConvertFilesDialog.this.myPerformAction = false;
            }
        }
    }
}

